/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.junitextentions.parameters.excel;

import com.holmos.webtest.junitextentions.parameters.excel.HolmosCell;
import com.holmos.webtest.junitextentions.parameters.excel.HolmosRow;
import com.holmos.webtest.junitextentions.parameters.excel.HolmosSheet;
import com.holmos.webtest.log.MyLogger;
import com.holmos.webtest.utils.file.MyFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class HolmosWorkBook {
    MyLogger logger = MyLogger.getLogger(HolmosWorkBook.class);
    private Workbook workbook;

    public Workbook getBook() {
        return this.workbook;
    }

    public HolmosWorkBook(String excelFilePath) {
        this.workbook = this.createWorkBook(excelFilePath);
    }

    public HolmosSheet getSheetByName(String sheetName) {
        return new HolmosSheet(this.workbook.getSheet(sheetName));
    }

    public HolmosSheet getSheetByIndex(int index) {
        return new HolmosSheet(this.workbook.getSheetAt(index));
    }

    public Workbook createWorkBook(String excelFilePath) {
        HSSFWorkbook workbook;
        block7: {
            workbook = null;
            if (MyFile.exist(excelFilePath)) {
                try {
                    if (excelFilePath.endsWith(".xls")) {
                        workbook = new HSSFWorkbook((InputStream)new FileInputStream(excelFilePath));
                        break block7;
                    }
                    if (excelFilePath.endsWith(".xlsx")) {
                        workbook = new XSSFWorkbook((InputStream)new FileInputStream(excelFilePath));
                        break block7;
                    }
                    if (excelFilePath.endsWith("csv")) {
                        workbook = new XSSFWorkbook((InputStream)new FileInputStream(excelFilePath));
                        break block7;
                    }
                    this.logger.error(String.valueOf(excelFilePath) + "\u6587\u4ef6\u4e0d\u662fexcel\u6587\u4ef6\u7c7b\u578b!\u8bf7\u68c0\u67e5!");
                }
                catch (Exception exception) {}
            } else {
                this.logger.error(String.valueOf(excelFilePath) + "\u6587\u4ef6\u4e0d\u5b58\u5728!\u8bf7\u68c0\u67e5!");
            }
        }
        return workbook;
    }

    public void saveFile(String excelFilePath) {
        try {
            FileOutputStream outputStream = new FileOutputStream(new File(excelFilePath));
            this.workbook.write((OutputStream)outputStream);
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<ArrayList<HolmosCell>> getValidCellsBySheetIndex(int sheetIndex) {
        ArrayList<ArrayList<HolmosCell>> values = new ArrayList<ArrayList<HolmosCell>>();
        for (HolmosRow row : this.getSheetByIndex(sheetIndex).getValidRows()) {
            values.add(row.getValidCells());
        }
        return values;
    }

    public ArrayList<ArrayList<HolmosCell>> getValidCellsBySheetName(String sheetName) {
        ArrayList<ArrayList<HolmosCell>> values = new ArrayList<ArrayList<HolmosCell>>();
        for (HolmosRow row : this.getSheetByName(sheetName).getValidRows()) {
            values.add(row.getValidCells());
        }
        return values;
    }

    public ArrayList<ArrayList<Object>> getValidValuesBySheetIndex(int sheetIndex) {
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>();
        for (HolmosRow row : this.getSheetByIndex(sheetIndex).getValidRows()) {
            values.add(row.getValidValues());
        }
        return values;
    }

    public ArrayList<ArrayList<Object>> getValidValuesBySheetName(String sheetName) {
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>();
        for (HolmosRow row : this.getSheetByName(sheetName).getValidRows()) {
            values.add(row.getValidValues());
        }
        return values;
    }
}

