/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.junitextentions.parameters.getter;

import com.holmos.webtest.junitextentions.HolmosRunner;
import com.holmos.webtest.junitextentions.annotations.Source;
import com.holmos.webtest.junitextentions.parameters.filepathanalysis.analysisimp.DefaultDataFilePathAnalysisRobot;
import com.holmos.webtest.junitextentions.parameters.getter.CSVDataGetter;
import com.holmos.webtest.junitextentions.parameters.getter.DataGetter;
import com.holmos.webtest.junitextentions.parameters.getter.DatabaseDataGetter;
import com.holmos.webtest.junitextentions.parameters.getter.ExcelDataGetter;
import com.holmos.webtest.junitextentions.parameters.getter.ObjectDataGetter;
import com.holmos.webtest.junitextentions.parameters.getter.PropertiesDataGetter;
import com.holmos.webtest.junitextentions.parameters.getter.XMLDataGetter;

public final class DataGetterFactory {
    public static DataGetter getDataGetter(Source source) {
        if (source == null) {
            return null;
        }
        if (!source.selector().equalsIgnoreCase("") && source.selector().trim().startsWith("select ")) {
            return new DatabaseDataGetter(source.selector().trim());
        }
        if (!source.className().equalsIgnoreCase("")) {
            return new ObjectDataGetter(source.className().trim());
        }
        String mark = source.file().trim();
        String filePath = new DefaultDataFilePathAnalysisRobot().analysis(HolmosRunner.getTestClassForGetter(), mark);
        if (mark.endsWith(".xls") || mark.endsWith(".xlsx")) {
            return new ExcelDataGetter(filePath);
        }
        if (mark.endsWith(".csv")) {
            return new CSVDataGetter(filePath);
        }
        if (mark.endsWith(".xml")) {
            return new XMLDataGetter(filePath);
        }
        if (mark.endsWith(".properties")) {
            return new PropertiesDataGetter(filePath);
        }
        return null;
    }

    public static ExcelDataGetter getExcelDataGetter(String excelFilePath) {
        return new ExcelDataGetter(excelFilePath);
    }

    public static CSVDataGetter getCVSDataGetter(String CVSFilePath) {
        return new CSVDataGetter(CVSFilePath);
    }

    public static DatabaseDataGetter getDatabaseDataGetter(String selectSql) {
        return new DatabaseDataGetter(selectSql);
    }

    public static PropertiesDataGetter getPropertiesDataGetter(String propertiesFilePath) {
        return new PropertiesDataGetter(propertiesFilePath);
    }

    public static XMLDataGetter getXmlDataGetter(String XMLFilePath) {
        return new XMLDataGetter(XMLFilePath);
    }
}

