/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.junitextentions.parameters.getter;

import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.junitextentions.annotations.ID;
import com.holmos.webtest.junitextentions.parameters.getter.AbstractDataGetter;
import com.holmos.webtest.utils.HolmosAnnotationUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.junit.Assert;

public final class ObjectDataGetter
extends AbstractDataGetter {
    private String fullClassName;
    private Object obj;
    private HashMap<Integer, ArrayList<Method>> idForMethods = new HashMap();

    public ObjectDataGetter(String fullClassName) {
        this.fullClassName = fullClassName;
        this.obj = this.getObject();
        this.initIDForMethodInfo();
    }

    @Override
    public ArrayList<Object[]> getParameterByID(int id) {
        ArrayList<Method> methodsWithID = this.idForMethods.get(id);
        if (methodsWithID == null) {
            return null;
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        ArrayList reference = null;
        for (Method method : methodsWithID) {
            try {
                ArrayList returnResult = (ArrayList)method.invoke(this.obj, new Object[0]);
                reference = reference == null ? returnResult : reference;
                this.volidateReturnValueTypes(reference, returnResult);
                result.addAll(returnResult);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private void volidateReturnValueTypes(ArrayList<Object[]> reference, ArrayList<Object[]> returnResult) {
        if (reference == null || returnResult == null) {
            return;
        }
        this.volidateOneMethodReturnValueTypes(reference);
        this.volidateOneMethodReturnValueTypes(returnResult);
        int i = 0;
        while (i < reference.get(0).length) {
            if (!reference.get(0)[i].getClass().getName().equalsIgnoreCase(returnResult.get(0)[i].getClass().getName())) {
                throw new HolmosFailedError("\u5bf9\u8c61\u53c2\u6570\u51c6\u5907\u7684\u65b9\u6cd5:" + this.fullClassName + " \u540c\u4e00id\u53c2\u6570\u7c7b\u578b\u4e0d\u4e00\u81f4!");
            }
            ++i;
        }
    }

    private void volidateOneMethodReturnValueTypes(ArrayList<Object[]> reference) {
        if (reference.size() <= 1) {
            return;
        }
        int i = 1;
        while (i < reference.size()) {
            if (reference.get(i).length != reference.get(0).length) {
                throw new HolmosFailedError("\u5bf9\u8c61\u53c2\u6570\u51c6\u5907\u7684\u65b9\u6cd5:" + this.fullClassName + " \u540c\u4e00id\u53c2\u6570\u5217\u8868\u957f\u5ea6\u4e0d\u4e00\u6837!");
            }
            int j = 0;
            while (j < reference.get(0).length) {
                if (!reference.get(i)[j].getClass().getName().equalsIgnoreCase(reference.get(0)[j].getClass().getName())) {
                    throw new HolmosFailedError("\u5bf9\u8c61\u53c2\u6570\u51c6\u5907\u7684\u65b9\u6cd5:" + this.fullClassName + " \u540c\u4e00id\u53c2\u6570\u7c7b\u578b\u4e0d\u4e00\u81f4!");
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public ArrayList<Object[]> getParameterByIDs(int[] ids) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            result.addAll(this.getParameterByID(id));
            ++n2;
        }
        return result;
    }

    @Override
    public ArrayList<Object[]> getAllParameter() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        Set<Integer> ids = this.idForMethods.keySet();
        for (int id : ids) {
            result.addAll(this.getParameterByID(id));
        }
        return result;
    }

    private void initIDForMethodInfo() {
        Set<Method> allMethods = HolmosAnnotationUtils.getMethodsWithAnnotationBase(this.obj.getClass(), ID.class, true);
        for (Method method : allMethods) {
            if (!this.volidateIDAnnotation(method)) continue;
            int id = method.getAnnotation(ID.class).id();
            if (this.idForMethods.get(id) == null) {
                this.idForMethods.put(id, new ArrayList());
            }
            this.idForMethods.get(id).add(method);
        }
    }

    private boolean volidateIDAnnotation(Method method) {
        if (!method.getReturnType().isAssignableFrom(ArrayList.class)) {
            throw new HolmosFailedError("\u5bf9\u8c61\u53c2\u6570\u51c6\u5907\u7684\u65b9\u6cd5:" + this.fullClassName + "." + method.getName() + "\u5fc5\u987b\u662fArrayList<Object[]>\u7c7b\u578b!");
        }
        ID id = method.getAnnotation(ID.class);
        if (id.id() <= 0) {
            throw new HolmosFailedError("\u5bf9\u8c61\u53c2\u6570\u51c6\u5907\u7684\u65b9\u6cd5:" + this.fullClassName + "." + method.getName());
        }
        return true;
    }

    private Object getObject() {
        try {
            return this.getOnlyConstructor().newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Constructor<?> getOnlyConstructor() {
        try {
            Constructor<?>[] constructors = Class.forName(this.fullClassName).getConstructors();
            Assert.assertEquals((long)1L, (long)constructors.length);
            return constructors[0];
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

