/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.struct;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.BrowserWindow;
import com.holmos.webtest.SeleniumBrowserWindow;
import com.holmos.webtest.WebDriverBrowserWindow;
import com.holmos.webtest.constvalue.ConfigConstValue;
import com.holmos.webtest.constvalue.ConstValue;
import com.holmos.webtest.element.Element;
import com.holmos.webtest.element.locator.AbstractElement;
import com.holmos.webtest.element.locator.Locator;
import com.holmos.webtest.element.locator.LocatorChain;
import com.holmos.webtest.element.tool.SeleniumElementExist;
import com.holmos.webtest.element.tool.WebDriverElementExist;
import com.holmos.webtest.element.tool.WebElementExist;
import com.holmos.webtest.log.MyLogger;
import com.holmos.webtest.struct.SubPage;
import com.holmos.webtest.utils.HolmosBaseUtils;
import com.holmos.webtest.utils.HolmosWindow;
import com.thoughtworks.selenium.Selenium;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Collection
extends AbstractElement {
    protected String wholeComment;
    private WebElementExist exist;
    protected String fullName = "";
    protected String comment;
    private int index = 1;
    private LocatorChain infoChain;
    protected String locatorCurrent = "";
    protected List<Element> elements = new ArrayList<Element>();
    protected List<SubPage> subpages = new ArrayList<SubPage>();
    protected List<Collection> collections = new ArrayList<Collection>();
    private Locator locator;
    protected WebElement element;
    protected MyLogger logger = MyLogger.getLogger(this.getClass());

    public String getWholeComment() {
        return this.wholeComment;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getLocatorCurrent() {
        return this.locatorCurrent;
    }

    @Override
    public void setLocatorCurrent(String locatorCurrent) {
        this.locatorCurrent = locatorCurrent;
    }

    @Override
    public LocatorChain getInfoChain() {
        return this.infoChain;
    }

    @Override
    public String getComment() {
        return "\u7b2c" + this.index + "\u4e2a" + this.comment;
    }

    public String getComment(boolean b) {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void setElement(WebElement element) {
        this.element = element;
    }

    @Override
    public WebElement getElement() {
        return this.element;
    }

    public Collection(String comment) {
        this.locator = new Locator();
        this.infoChain = new LocatorChain();
        this.comment = comment;
    }

    protected void init() {
        Field[] fields = this.getClass().getFields();
        try {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getModifiers() != ConstValue.nestedFatherObjectModifier) {
                    Object o = field.get(this);
                    if (o instanceof Element) {
                        HolmosBaseUtils.insertElementName((Element)o, field.getName());
                        ((Element)o).getInfoChain().addParentNode(this.getInfoChain().getInfoNodes());
                        ((Element)o).setFullName(String.valueOf(this.fullName) + field.getName());
                        ((Element)o).getInfoChain().addNode(this);
                        this.elements.add((Element)o);
                    } else if (o instanceof SubPage) {
                        HolmosBaseUtils.insertSubPageName((SubPage)o, field.getName());
                        ((SubPage)o).getInfoChain().addParentNode(this.getInfoChain().getInfoNodes());
                        ((SubPage)o).setFullName(String.valueOf(this.fullName) + field.getName());
                        ((SubPage)o).getInfoChain().addNode(this);
                        this.subpages.add((SubPage)o);
                        ((SubPage)o).init();
                    } else if (o instanceof Collection) {
                        HolmosBaseUtils.insertCollectionName((Collection)o, field.getName());
                        ((Collection)o).getInfoChain().addParentNode(this.getInfoChain().getInfoNodes());
                        ((Collection)o).setFullName(String.valueOf(this.fullName) + field.getName());
                        ((Collection)o).getInfoChain().addNode(this);
                        this.collections.add((Collection)o);
                        ((Collection)o).init();
                    }
                }
                ++n2;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void addIDLocator(String id) {
        this.locator.addIdLocator(id);
    }

    public void addNameLocator(String name) {
        this.locator.addNameLocator(name);
    }

    public void addXpathLocator(String xpath) {
        this.locator.addXpathLocator(xpath);
    }

    public void addCSSLocator(String css) {
        this.locator.addCSSLocator(css);
    }

    public void addLinkTextLocator(String linkText) {
        this.locator.addLinkTextLocator(linkText);
    }

    public void addPartialLinkTextLocator(String partialLinkText) {
        this.locator.addPartialLinkTextLocator(partialLinkText);
    }

    public void addAttributeLocator(String attributeName, String attributeValue) {
        this.locator.addAttributeLocator(attributeName, attributeValue);
    }

    public void addTagNameLocator(String tagName) {
        this.locator.addTagNameLocator(tagName);
    }

    public void addClassLocator(String className) {
        this.locator.addClassLocator(className);
    }

    private boolean isCollectionExist(int waitCount) {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            this.exist = new SeleniumElementExist(this);
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            this.exist = new WebDriverElementExist(this);
        }
        return this.exist.isElementExist(waitCount);
    }

    public boolean isExist(int index) {
        if (!this.isExist()) {
            return false;
        }
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            if (((Selenium)currentWindow.getDriver().getEngine()).isElementPresent("xpath=" + this.locatorCurrent + "[" + index + "]")) {
                return true;
            }
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            try {
                ((WebDriver)currentWindow.getDriver().getEngine()).findElements(By.xpath((String)this.locatorCurrent)).get(index);
                return true;
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }
        return false;
    }

    public void select(int index) {
        this.index = index;
    }

    @Override
    public Locator getLocator() {
        return this.locator;
    }

    @Override
    public boolean isExist() {
        return this.isCollectionExist(ConfigConstValue.defaultWaitCount);
    }

    public void assertExist() {
        StringBuilder message = new StringBuilder();
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append(":\u5143\u7d20\u5b58\u5728\u6027\u6821\u9a8c\u6210\u529f\uff01\u5143\u7d20\u5b58\u5728\uff01");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append(":\u5143\u7d20\u5b58\u5728\u6821\u9a8c\u5931\u8d25\uff01\u5143\u7d20\u4e0d\u5b58\u5728!");
            this.logger.error(message);
            HolmosWindow.closeAllWindows();
            Assert.fail((String)message.toString());
        }
    }

    public void assertNotExist() {
        StringBuilder message = new StringBuilder();
        if (!this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u5143\u7d20\u4e0d\u5b58\u5728\u6027\u6821\u9a8c\u6210\u529f\uff01\u5143\u7d20\u4e0d\u5b58\u5728\uff01");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u5143\u7d20\u5b58\u5728\u6821\u9a8c\u5931\u8d25\uff01\u5143\u7d20\u5b58\u5728!");
            this.logger.error(message);
            HolmosWindow.closeAllWindows();
            Assert.fail((String)message.toString());
        }
    }

    public void verifyExist() {
        StringBuilder message = new StringBuilder();
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u5143\u7d20\u5b58\u5728\u6027\u6821\u9a8c\u6210\u529f\uff01\u5143\u7d20\u5b58\u5728\uff01");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u5143\u7d20\u5b58\u5728\u6821\u9a8c\u5931\u8d25\uff01\u5143\u7d20\u4e0d\u5b58\u5728!");
            this.logger.error(message);
        }
    }

    public void verifyNotExist() {
        StringBuilder message = new StringBuilder();
        if (!this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u5143\u7d20\u4e0d\u5b58\u5728\u6027\u6821\u9a8c\u6210\u529f\uff01\u5143\u7d20\u4e0d\u5b58\u5728\uff01");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u5143\u7d20\u5b58\u5728\u6821\u9a8c\u5931\u8d25\uff01\u5143\u7d20\u5b58\u5728!");
            this.logger.error(message);
        }
    }

    public boolean waitForExist() {
        if (!this.isCollectionExist(ConfigConstValue.waitCount)) {
            this.logger.error("\u5143\u7d20" + this.wholeComment + "\u4e00\u76f4\u6ca1\u6709\u51fa\u73b0");
            return false;
        }
        return true;
    }

    public void waitForDisppear() {
        int waitCount = 0;
        while (waitCount++ < ConfigConstValue.waitCount) {
            if (this.exist.isElementExistForCheckOnce()) continue;
            return;
        }
    }

    @Override
    public void setWholeComment(String wholeComment) {
        this.wholeComment = wholeComment;
    }

    public int getSize() {
        if (this.isExist()) {
            return this.exist.getCollectionSize();
        }
        return 0;
    }
}

