/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.struct;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.BrowserWindow;
import com.holmos.webtest.SeleniumBrowserWindow;
import com.holmos.webtest.WebDriverBrowserWindow;
import com.holmos.webtest.constvalue.ConfigConstValue;
import com.holmos.webtest.constvalue.ConstValue;
import com.holmos.webtest.element.Element;
import com.holmos.webtest.element.locator.Locator;
import com.holmos.webtest.element.locator.LocatorChain;
import com.holmos.webtest.element.tool.SeleniumElementExist;
import com.holmos.webtest.element.tool.WebDriverElementExist;
import com.holmos.webtest.element.tool.WebElementExist;
import com.holmos.webtest.log.MyLogger;
import com.holmos.webtest.struct.Collection;
import com.holmos.webtest.struct.Page;
import com.holmos.webtest.struct.SubPage;
import com.holmos.webtest.utils.HolmosBaseUtils;
import com.thoughtworks.selenium.Selenium;
import java.lang.reflect.Field;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Frame
extends Page {
    private int index = -1;
    private WebElementExist exist;
    protected String fullName = "";
    protected Page parent;
    private WebElement element;
    private Locator locator = new Locator();
    private static MyLogger logger = MyLogger.getLogger(Frame.class);
    private LocatorChain infoChain = new LocatorChain();

    public int getLocatorByIndex() {
        return this.index;
    }

    public void setParent(Page parent) {
        this.parent = parent;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public WebElement getElement() {
        return this.element;
    }

    @Override
    public void setElement(WebElement element) {
        this.element = element;
    }

    @Override
    public Locator getLocator() {
        return this.locator;
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public Frame(String comment) {
        this.comment = comment;
        this.init();
    }

    public void addIDlocator(String id) {
        this.locator.addIdLocator(id);
    }

    public void addNameLocator(String name) {
        this.locator.addNameLocator(name);
    }

    public void addXpathLocator(String xpath) {
        this.locator.addXpathLocator(xpath);
    }

    public void addCSSLocator(String css) {
        this.locator.addCSSLocator(css);
    }

    public void addLinkTextLocator(String linkText) {
        this.locator.addLinkTextLocator(linkText);
    }

    public void addPartialLinkTextLocator(String partialLinkText) {
        this.locator.addPartialLinkTextLocator(partialLinkText);
    }

    public void addAttributeLocator(String attributeName, String attributeValue) {
        this.locator.addAttributeLocator(attributeName, attributeValue);
    }

    public void addTagNameLocator(String tagName) {
        this.locator.addTagNameLocator(tagName);
    }

    public void addClassLocator(String className) {
        this.locator.addClassLocator(className);
    }

    public void addIndexLocator(int index) {
        this.index = index;
    }

    @Override
    protected void init() {
        Field[] fields = this.getClass().getFields();
        try {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getModifiers() != ConstValue.nestedFatherObjectModifier) {
                    Object o = field.get(this);
                    if (o instanceof Element) {
                        HolmosBaseUtils.insertElementName((Element)o, field.getName());
                        ((Element)o).getInfoChain().addParentNode(this.getInfoChain().getInfoNodes());
                        ((Element)o).getInfoChain().addNode(this);
                        ((Element)o).setFullName(String.valueOf(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)) + field.getName());
                        this.elements.add((Element)o);
                    } else if (o instanceof SubPage) {
                        HolmosBaseUtils.insertSubPageName((SubPage)o, field.getName());
                        ((SubPage)o).getInfoChain().addParentNode(this.getInfoChain().getInfoNodes());
                        ((SubPage)o).getInfoChain().addNode(this);
                        ((SubPage)o).setFullName(String.valueOf(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)) + field.getName());
                        this.subpages.add((SubPage)o);
                        ((SubPage)o).init();
                    } else if (o instanceof Collection) {
                        HolmosBaseUtils.insertCollectionName((Collection)o, field.getName());
                        ((Collection)o).getInfoChain().addParentNode(this.getInfoChain().getInfoNodes());
                        ((Collection)o).getInfoChain().addNode(this);
                        ((Collection)o).setFullName(String.valueOf(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)) + field.getName());
                        this.collections.add((Collection)o);
                        ((Collection)o).init();
                    } else if (o instanceof Frame) {
                        HolmosBaseUtils.insertFrameName((Frame)o, field.getName());
                        ((Frame)o).getInfoChain().addParentNode(this.getInfoChain().getInfoNodes());
                        ((Frame)o).getInfoChain().addNode(this);
                        ((Frame)o).setFullName(String.valueOf(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)) + field.getName());
                        this.frames.add((Frame)o);
                        ((Frame)o).setParent(this);
                        ((Frame)o).init();
                    }
                }
                ++n2;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @Override
    public LocatorChain getInfoChain() {
        return this.infoChain;
    }

    private boolean isFrameExist(int waitCount) {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            this.exist = new SeleniumElementExist(this);
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            this.exist = new WebDriverElementExist(this);
        }
        return this.exist.isElementExist(waitCount);
    }

    @Override
    public boolean isExist() {
        return this.isFrameExist(ConfigConstValue.defaultWaitCount);
    }

    private void selectFrame() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.comment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).selectFrame(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                try {
                    if (this.locator.getLocatorById() != null) {
                        ((WebDriver)currentWindow.getDriver().getEngine()).switchTo().frame(this.locator.getLocatorById());
                    } else if (this.locator.getLocatorByName() != null) {
                        ((WebDriver)currentWindow.getDriver().getEngine()).switchTo().frame(this.locator.getLocatorByName());
                    } else if (this.getLocatorByIndex() != -1) {
                        ((WebDriver)currentWindow.getDriver().getEngine()).switchTo().frame(this.index);
                    } else {
                        ((WebDriver)currentWindow.getDriver().getEngine()).switchTo().frame(this.element);
                    }
                    message.append("\u5b9a\u4f4dFrame\u6210\u529f!\u73b0\u5728\u7684\u63a7\u5236\u6743\u4ea4\u4e88\u8fd9\u4e2a" + this.comment + " Frame!");
                    logger.info(message);
                }
                catch (Exception e) {
                    message.append("\u5b9a\u4f4dFrame\u5931\u8d25\uff0c\u6b64Frame\u5143\u7d20\u5b58\u5728,\u4f46\u662f\u7531\u4e8e\u67d0\u79cd\u539f\u56e0\u5b9a\u4f4d\u51fa\u9519" + this.comment + " Frame!");
                    logger.error(message);
                }
            }
        } else {
            logger.error(String.valueOf(this.comment) + " frame\u4e0d\u5b58\u5728");
        }
    }

    public void select() {
        this.selectTopPage();
        int i = 0;
        i = 1;
        while (i < this.infoChain.getInfoNodes().size()) {
            ((Frame)this.infoChain.getInfoNodes().get(i)).selectFrame();
            ++i;
        }
        this.selectFrame();
    }

    public void selectParentContainer() {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            ((Selenium)currentWindow.getDriver().getEngine()).selectFrame("relative=up");
        } else {
            boolean cfr_ignored_0 = currentWindow instanceof WebDriverBrowserWindow;
        }
    }

    public void selectTopPage() {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            ((Selenium)currentWindow.getDriver().getEngine()).selectFrame("relative=top");
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            ((WebDriver)currentWindow.getDriver().getEngine()).switchTo().defaultContent();
        }
    }

    public boolean waitForExist() {
        if (!this.isFrameExist(ConfigConstValue.waitCount)) {
            logger.error("\u5143\u7d20" + this.comment + "\u4e00\u76f4\u6ca1\u6709\u51fa\u73b0");
            return false;
        }
        return true;
    }

    public void waitForDisppear() {
        int waitCount = 0;
        while (waitCount++ < ConfigConstValue.waitCount) {
            if (this.exist.isElementExistForCheckOnce()) continue;
            return;
        }
    }
}

