/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.utils;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.constvalue.ConfigConstValue;
import com.holmos.webtest.constvalue.ConstValue;
import com.holmos.webtest.element.Element;
import com.holmos.webtest.log.MyLogger;
import com.holmos.webtest.struct.Collection;
import com.holmos.webtest.struct.Frame;
import com.holmos.webtest.struct.Page;
import com.holmos.webtest.struct.SubPage;
import com.holmos.webtest.utils.HolmosPropertiesUtils;
import com.holmos.webtest.utils.HolmosWindow;
import com.holmos.webtest.utils.file.MyFile;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class HolmosBaseUtils {
    private static MyLogger logger = MyLogger.getLogger(HolmosBaseUtils.class);

    public static void killProcess(String processName) {
        Runtime runTime = Runtime.getRuntime();
        try {
            runTime.exec("tskill " + processName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void configScreenShotLocation() {
        String screenShotDir;
        ConstValue.screenShotDir = screenShotDir = HolmosBaseUtils.getScreenShotDirPath();
        File file = new File(screenShotDir);
        if (!file.exists()) {
            try {
                if (file.mkdirs()) {
                    System.out.println("\u622a\u5c4f\u5730\u5740\u521b\u5efa\u6210\u529f!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isFileExist(String filePath) {
        return MyFile.exist(filePath);
    }

    public static String getScreenShotDirPath() {
        if (ConstValue.screenShotDir != null) {
            return ConstValue.screenShotDir;
        }
        Properties properties = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(ConfigConstValue.HOLMOSCONFFILE));
            properties.load(in);
            ((InputStream)in).close();
            return HolmosPropertiesUtils.getValue(properties, "screenShotDir");
        }
        catch (IOException e) {
            logger.error("Holmos \u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25!\u5c06\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e!");
            return null;
        }
    }

    public static void sleep(int miliSeconds) {
        try {
            Thread.sleep(miliSeconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected static String getClipboardText() throws Exception {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipT = clip.getContents(null);
        if (clipT != null && clipT.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return (String)clipT.getTransferData(DataFlavor.stringFlavor);
        }
        return null;
    }

    public static void outPut(Object message) {
        System.out.println(message);
    }

    protected static void setClipboardText(String writeMe) {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection tText = new StringSelection(writeMe);
        clip.setContents(tText, null);
    }

    public static Image getImageFromClipboard() throws Exception {
        Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable cc = sysc.getContents(null);
        if (cc == null) {
            return null;
        }
        if (cc.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            return (Image)cc.getTransferData(DataFlavor.imageFlavor);
        }
        return null;
    }

    protected static void setClipboardImage(final Image image) {
        Transferable trans = new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return DataFlavor.imageFlavor.equals(flavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (this.isDataFlavorSupported(flavor)) {
                    return image;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trans, null);
    }

    public static void openByTarget(String url, String target) {
        if (target == null) {
            Allocator.getInstance().currentWindow.open(url);
        } else if (target.equalsIgnoreCase("_blank")) {
            HolmosWindow.openNewWindow(url);
        } else if (target.equalsIgnoreCase("_self")) {
            Allocator.getInstance().currentWindow.open(url);
        }
    }

    public static void insertElementName(Element element, String name) {
        StringBuilder commentTemp = new StringBuilder(element.getComment());
        commentTemp.append("[" + name + "]");
        element.setComment(commentTemp.toString());
    }

    public static void insertSubPageName(SubPage subpage, String name) {
        StringBuilder commentTemp = new StringBuilder(subpage.getComment());
        commentTemp.append("[" + name + "]");
        subpage.setComment(commentTemp.toString());
    }

    public static void insertPageName(Page page, String name) {
        StringBuilder commentTemp = new StringBuilder(page.getComment());
        commentTemp.append("[" + name + "]");
        page.setComment(commentTemp.toString());
    }

    public static void insertFrameName(Frame frame, String name) {
        StringBuilder commentTemp = new StringBuilder(frame.getComment());
        commentTemp.append("[" + name + "]");
        frame.setComment(commentTemp.toString());
    }

    public static void insertCollectionName(Collection collection, String name) {
        StringBuilder commentTemp = new StringBuilder(collection.getComment(false));
        commentTemp.append("[" + name + "]");
        collection.setComment(commentTemp.toString());
    }
}

