/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.utils;

import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.log.MyLogger;
import com.holmos.webtest.utils.HolmosBaseUtils;
import com.holmos.webtest.utils.HolmosIOUtils;
import com.holmos.webtest.utils.file.MyFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class HolmosPropertiesUtils {
    private static MyLogger logger = MyLogger.getLogger(HolmosBaseUtils.class);

    public static Properties getPropertyInfo(String fullFilePath) {
        File propertyFile = new File(fullFilePath);
        return HolmosPropertiesUtils.getPropertyInfo(propertyFile);
    }

    public static Properties getPropertyInfo(File propertyFile) {
        if (!propertyFile.exists()) {
            logger.error("\u5c5e\u6027\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!");
        }
        try {
            FileInputStream inputStream = new FileInputStream(propertyFile);
            Properties properties = new Properties();
            properties.load(inputStream);
            return properties;
        }
        catch (FileNotFoundException e) {
            logger.error("\u5c5e\u6027\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!");
        }
        catch (IOException e) {
            logger.error("Property.load \u7684\u65f6\u5019\u53d1\u751fio\u9519\u8bef!");
        }
        return null;
    }

    public static void savePropertiesFile(Properties properties, String fullPath, String comments) {
        MyFile.createFile(fullPath);
        try {
            FileOutputStream outputStream = new FileOutputStream(new File(fullPath));
            properties.store(outputStream, comments);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getValue(Properties properties, String propertiesName) {
        String value = properties.getProperty(propertiesName);
        if (value == null || "".equalsIgnoreCase(value)) {
            throw new HolmosFailedError("\u83b7\u53d6\u7684\u5c5e\u6027\u503c\u4e0d\u5b58\u5728\u6216\u8005\u4e3a\u7a7a\u7a9c!");
        }
        return value;
    }

    public static String getValue(Properties properties, String propertiesName, String defaultValue) {
        String value = properties.getProperty(propertiesName);
        if (value == null || "".equalsIgnoreCase(value)) {
            return defaultValue;
        }
        return value;
    }

    public static List<String> getValueList(Properties properties, String propertiesName) {
        String[] propertieValues;
        String values = HolmosPropertiesUtils.getValue(properties, propertiesName);
        ArrayList<String> valuesList = new ArrayList<String>(values.length());
        String[] stringArray = propertieValues = values.split(",");
        int n = propertieValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (!value.trim().equalsIgnoreCase("")) {
                valuesList.add(value.trim());
            }
            ++n2;
        }
        if (valuesList.isEmpty()) {
            throw new HolmosFailedError("\u83b7\u53d6\u7684\u5c5e\u6027\u5217\u8868\u6240\u6709\u7684\u5c5e\u6027\u90fd\u4e3a\u7a7a\u7a9c!");
        }
        return valuesList;
    }

    public static boolean isPropertyInFile(Properties properties, String propertiesName) {
        return properties.get(propertiesName) != null;
    }

    public static boolean getBoolean(Properties properties, String propertiesName) {
        String value = HolmosPropertiesUtils.getValue(properties, propertiesName);
        if (value.trim().equalsIgnoreCase("true")) {
            return true;
        }
        if (value.trim().equalsIgnoreCase("false")) {
            return false;
        }
        throw new HolmosFailedError("\u5c5e\u6027\u503c\u7684\u683c\u5f0f\u9519\u8bef!\u65e0\u6cd5\u8f6c\u6362\u4e3aboolean\u7c7b\u578b!");
    }

    public static boolean getBoolean(Properties properties, String propertiesName, boolean defaultValue) {
        try {
            return HolmosPropertiesUtils.getBoolean(properties, propertiesName);
        }
        catch (HolmosFailedError e) {
            return defaultValue;
        }
    }

    public static long getLong(Properties properties, String propertiesName) {
        String value = HolmosPropertiesUtils.getValue(properties, propertiesName);
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new HolmosFailedError("\u83b7\u5f97\u7684\u5c5e\u6027\u4e0d\u662fLong\u7c7b\u578b!\u65e0\u6cd5\u5b8c\u6210\u8f6c\u578b!");
        }
    }

    public static long getLong(Properties properties, String propertiesName, long defaultValue) {
        try {
            return HolmosPropertiesUtils.getLong(properties, propertiesName);
        }
        catch (HolmosFailedError e) {
            return defaultValue;
        }
    }

    public static int getInt(Properties properties, String propertiesName) {
        String value = HolmosPropertiesUtils.getValue(properties, propertiesName);
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new HolmosFailedError("\u83b7\u5f97\u7684\u5c5e\u6027\u4e0d\u662fLong\u7c7b\u578b!\u65e0\u6cd5\u5b8c\u6210\u8f6c\u578b!");
        }
    }

    public static int getInt(Properties properties, String propertiesName, int defaultValue) {
        try {
            return HolmosPropertiesUtils.getInt(properties, propertiesName);
        }
        catch (HolmosFailedError e) {
            return defaultValue;
        }
    }

    public static List<Boolean> getBooleanList(Properties properties, String propertiesName) {
        ArrayList values = (ArrayList)HolmosPropertiesUtils.getValueList(properties, propertiesName);
        ArrayList<Boolean> booleans = new ArrayList<Boolean>();
        for (String value : values) {
            if (value.trim().equalsIgnoreCase("true")) {
                booleans.add(true);
                continue;
            }
            if (value.trim().equalsIgnoreCase("false")) {
                booleans.add(false);
                continue;
            }
            throw new HolmosFailedError("\u5c5e\u6027\u503c\u7684\u683c\u5f0f\u9519\u8bef!\u65e0\u6cd5\u8f6c\u6362\u4e3aboolean\u7c7b\u578b!");
        }
        return booleans;
    }

    public static List<Boolean> getBooleanList(Properties properties, String propertiesName, boolean defaultValue) {
        ArrayList values = (ArrayList)HolmosPropertiesUtils.getValueList(properties, propertiesName);
        ArrayList<Boolean> booleans = new ArrayList<Boolean>();
        for (String value : values) {
            if (value.trim().equalsIgnoreCase("true")) {
                booleans.add(true);
                continue;
            }
            if (value.trim().equalsIgnoreCase("false")) {
                booleans.add(false);
                continue;
            }
            booleans.add(defaultValue);
        }
        return booleans;
    }

    public static List<Long> getLongList(Properties properties, String propertiesName) {
        ArrayList values = (ArrayList)HolmosPropertiesUtils.getValueList(properties, propertiesName);
        ArrayList<Long> longs = new ArrayList<Long>();
        for (String value : values) {
            try {
                longs.add(Long.valueOf(value));
            }
            catch (NumberFormatException e) {
                throw new HolmosFailedError("\u83b7\u5f97\u7684\u5c5e\u6027\u4e0d\u662fLong\u7c7b\u578b!\u65e0\u6cd5\u5b8c\u6210\u8f6c\u578b!");
            }
        }
        return longs;
    }

    public static List<Long> getLongList(Properties properties, String propertiesName, long defaultValue) {
        ArrayList values = (ArrayList)HolmosPropertiesUtils.getValueList(properties, propertiesName);
        ArrayList<Long> longs = new ArrayList<Long>();
        for (String value : values) {
            try {
                longs.add(Long.valueOf(value));
            }
            catch (NumberFormatException e) {
                longs.add(defaultValue);
            }
        }
        return longs;
    }

    public static List<Integer> getIntList(Properties properties, String propertiesName) {
        ArrayList values = (ArrayList)HolmosPropertiesUtils.getValueList(properties, propertiesName);
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (String value : values) {
            try {
                ints.add(Integer.valueOf(value));
            }
            catch (NumberFormatException e) {
                throw new HolmosFailedError("\u83b7\u5f97\u7684\u5c5e\u6027\u4e0d\u662fLong\u7c7b\u578b!\u65e0\u6cd5\u5b8c\u6210\u8f6c\u578b!");
            }
        }
        return ints;
    }

    public static List<Integer> getIntList(Properties properties, String propertiesName, int defaultValue) {
        ArrayList values = (ArrayList)HolmosPropertiesUtils.getValueList(properties, propertiesName);
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (String value : values) {
            try {
                ints.add(Integer.valueOf(value));
            }
            catch (NumberFormatException e) {
                ints.add(defaultValue);
            }
        }
        return ints;
    }

    public static Properties getPropertiesFromUserhome(String propertiesFileName) {
        if (propertiesFileName == null || "".equalsIgnoreCase(propertiesFileName)) {
            throw new HolmosFailedError("\u6ca1\u6709\u7ed9\u5b9a properties\u6587\u4ef6\u7684\u540d\u5b57!");
        }
        FileInputStream input = null;
        Properties properties = new Properties();
        try {
            File userHomeProperties = new File(String.valueOf(System.getProperty("user.home")) + propertiesFileName);
            if (!userHomeProperties.exists()) {
                return null;
            }
            input = new FileInputStream(userHomeProperties);
            properties.load(input);
            logger.info("\u4f4d\u4e8e\u7528\u6237\u4e3b\u76ee\u5f55\u7684holmos\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u6210\u529f!");
            Properties properties2 = properties;
            HolmosIOUtils.closeStreamIgnoreExpection(input);
            return properties2;
        }
        catch (IOException e) {
            throw new HolmosFailedError("\u4ece\u7528\u6237\u4e3b\u76ee\u5f55\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u53d1\u751f\u5176\u4ed6IO\u9519\u8bef!");
        }
        finally {
            HolmosIOUtils.closeStreamIgnoreExpection(input);
        }
    }

    public static Properties getPropertiesFromClassPath(String propertiesFileName) {
        Properties properties;
        Properties properties2;
        InputStream input;
        block6: {
            if (propertiesFileName == null || "".equalsIgnoreCase(propertiesFileName)) {
                throw new HolmosFailedError("\u6ca1\u6709\u7ed9\u5b9a properties\u6587\u4ef6\u7684\u540d\u5b57!");
            }
            input = null;
            properties2 = new Properties();
            input = HolmosPropertiesUtils.class.getClassLoader().getResourceAsStream(propertiesFileName);
            if (input != null) break block6;
            HolmosIOUtils.closeStreamIgnoreExpection(input);
            return null;
        }
        try {
            properties2.load(input);
            logger.info("\u4f4d\u4e8eclasspath\u7684Resource\u76ee\u5f55\u4e0b\u7684holmos\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u6210\u529f!");
            properties = properties2;
        }
        catch (IOException e) {
            try {
                throw new HolmosFailedError("\u4ece\u7528classpath\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u53d1\u751f\u5176\u4ed6IO\u9519\u8bef!");
            }
            catch (Throwable throwable) {
                HolmosIOUtils.closeStreamIgnoreExpection(input);
                throw throwable;
            }
        }
        HolmosIOUtils.closeStreamIgnoreExpection(input);
        return properties;
    }

    public static Properties getPropertiesFromCommonFilePath(String filePath) {
        if (filePath == null || "".equalsIgnoreCase(filePath)) {
            throw new HolmosFailedError("\u6ca1\u6709\u7ed9\u5b9a properties\u6587\u4ef6\u7684\u540d\u5b57!");
        }
        FileInputStream input = null;
        Properties properties = new Properties();
        try {
            File propertiesFile = new File(filePath);
            if (!propertiesFile.exists()) {
                return null;
            }
            input = new FileInputStream(propertiesFile);
            properties.load(input);
            logger.info("\u4f4d\u4e8e" + filePath + "\u7684holmos\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u6210\u529f!");
            Properties properties2 = properties;
            HolmosIOUtils.closeStreamIgnoreExpection(input);
            return properties2;
        }
        catch (IOException e) {
            throw new HolmosFailedError("\u4ece\u7528" + filePath + "\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u53d1\u751f\u5176\u4ed6IO\u9519\u8bef!");
        }
        finally {
            HolmosIOUtils.closeStreamIgnoreExpection(input);
        }
    }
}

