/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.utils;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.BrowserWindow;
import com.holmos.webtest.EngineType;
import com.holmos.webtest.SeleniumBrowserWindow;
import com.holmos.webtest.SeleniumDriver;
import com.holmos.webtest.WebDriverBrowserWindow;
import com.holmos.webtest.constvalue.ConfigConstValue;
import com.holmos.webtest.log.MyLogger;
import com.thoughtworks.selenium.Selenium;
import java.io.File;
import java.io.IOException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.interactions.Actions;

public class HolmosWindow {
    protected static MyLogger logger = MyLogger.getLogger(HolmosWindow.class);

    public static void closeAllWindows() {
        Allocator.getInstance().closeAllWindows();
    }

    public static void runJavaScript(String javascript) {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            try {
                ((Selenium)currentWindow.getDriver().getEngine()).getEval(javascript);
                logger.info(String.valueOf(javascript) + "\u6267\u884c\u6210\u529f!");
            }
            catch (Exception e) {
                logger.error(String.valueOf(javascript) + "\u6267\u884c\u5931\u8d25!");
            }
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            try {
                JavascriptExecutor executor = (JavascriptExecutor)((WebDriver)currentWindow.getDriver().getEngine());
                executor.executeScript(String.valueOf(javascript) + ";return false;", new Object[0]);
                logger.info(String.valueOf(javascript) + "\u6267\u884c\u6210\u529f!");
            }
            catch (Exception e) {
                logger.error(String.valueOf(javascript) + "\u6267\u884c\u5931\u8d25!");
            }
        }
    }

    public static void runJavaScript(String javascript, Object ... paras) {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            try {
                ((Selenium)currentWindow.getDriver().getEngine()).getEval(javascript);
                logger.info(String.valueOf(javascript) + "\u6267\u884c\u6210\u529f!");
            }
            catch (Exception e) {
                logger.error(String.valueOf(javascript) + "\u6267\u884c\u5931\u8d25!");
            }
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            try {
                JavascriptExecutor executor = (JavascriptExecutor)((WebDriver)currentWindow.getDriver().getEngine());
                executor.executeScript(javascript, paras);
                logger.info(String.valueOf(javascript) + "\u6267\u884c\u6210\u529f!");
            }
            catch (Exception e) {
                logger.error(String.valueOf(javascript) + "\u6267\u884c\u5931\u8d25!");
            }
        }
    }

    public static void moveWindowTo(int xLocation, int yLocation) {
        Allocator.getInstance().currentWindow.moveWindowTo(xLocation, yLocation);
    }

    public static void resizeTo(int horizonSize, int verticalSize) {
        Allocator.getInstance().currentWindow.resizeTo(horizonSize, verticalSize);
    }

    public static String getUrl() {
        return Allocator.getInstance().currentWindow.getUrl();
    }

    public static String getTitle() {
        return Allocator.getInstance().currentWindow.getTitle();
    }

    public static void refresh() {
        Allocator.getInstance().currentWindow.refresh();
    }

    public static void close() {
        Allocator.getInstance().currentWindow.close();
    }

    public static void goForward() {
        Allocator.getInstance().currentWindow.goForward();
    }

    public static void goBack() {
        Allocator.getInstance().currentWindow.goBack();
    }

    public static EngineType getEngineType() {
        return Allocator.getInstance().currentWindow.getEngineType();
    }

    public static void open(String url) {
        Allocator.getInstance().currentWindow.open(url);
    }

    public static SeleniumDriver getDriver() {
        return Allocator.getInstance().currentWindow.getDriver();
    }

    public static void maxSizeWindow() {
        Allocator.getInstance().currentWindow.maxSizeWindow();
    }

    public static void openNewWindow(String url) {
        Allocator.getInstance().addAndSetBrowserWindow(EngineType.WebDriverIE, url);
        Allocator.getInstance().currentWindow.openNewWindow(url);
        Allocator.getInstance().updateWindows();
    }

    public static void openNewWindow(EngineType engineType, String url) {
        Allocator.getInstance().addAndSetBrowserWindow(engineType, url);
        Allocator.getInstance().currentWindow.openNewWindow(url);
    }

    public static void openFFNewWindowWithProfile(String url, FirefoxProfile profile) {
        Allocator.getInstance().addAndSetFFBrowserWindowWithProfile(url, profile);
        Allocator.getInstance().currentWindow.openNewWindow(url);
    }

    public static void attach(String url) {
        Allocator.getInstance().attach(url);
    }

    public static void attachByContains(String url) {
        Allocator.getInstance().attachByContains(url);
    }

    public static void attachByRegular(String url) {
        Allocator.getInstance().attachByRegular(url);
    }

    public static void attachByTitle(String title) {
        Allocator.getInstance().attachByTiltle(title);
    }

    public static void attachByContainTitle(String partTitle) {
        Allocator.getInstance().attachByContainTitle(partTitle);
    }

    public static void attachByRegularTitle(String regularTitle) {
        Allocator.getInstance().attachByRegularTitle(regularTitle);
    }

    public static void shiftKeyDown() {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            ((Selenium)currentWindow.getDriver().getEngine()).shiftKeyDown();
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
            action.build();
            action.keyDown(Keys.SHIFT).perform();
        }
    }

    public static void ctrlKeyDown() {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            ((Selenium)currentWindow.getDriver().getEngine()).controlKeyDown();
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
            action.build();
            action.sendKeys(new CharSequence[]{Keys.CONTROL}).perform();
        }
    }

    public static void metaKeyDown() {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            ((Selenium)currentWindow.getDriver().getEngine()).metaKeyDown();
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
            action.build();
            action.sendKeys(new CharSequence[]{Keys.META}).perform();
        }
    }

    public static void altKeyDown() {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            ((Selenium)currentWindow.getDriver().getEngine()).altKeyDown();
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
            action.build();
            action.keyDown(Keys.ALT).perform();
        }
    }

    public static void shiftKeyUp() {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            ((Selenium)currentWindow.getDriver().getEngine()).shiftKeyUp();
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
            action.build();
            action.keyUp(Keys.SHIFT).perform();
        }
    }

    public static void ctrlKeyUp() {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            ((Selenium)currentWindow.getDriver().getEngine()).controlKeyUp();
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
            action.build();
            action.keyUp(Keys.CONTROL).perform();
        }
    }

    public static void metaKeyUp() {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            ((Selenium)currentWindow.getDriver().getEngine()).metaKeyUp();
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
            action.build();
            action.keyUp(Keys.META).perform();
        }
    }

    public static void altKeyUp() {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            ((Selenium)currentWindow.getDriver().getEngine()).altKeyUp();
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
            action.build();
            action.keyUp(Keys.ALT).perform();
        }
    }

    public static void KeyDown(Keys key) {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            ((Selenium)currentWindow.getDriver().getEngine()).keyPressNative(String.valueOf(key.toString()));
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
            action.build();
            action.sendKeys(new CharSequence[]{key}).perform();
        }
    }

    public static void KeyUp(Keys key) {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            ((Selenium)currentWindow.getDriver().getEngine()).keyDownNative(String.valueOf(key.toString()));
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
            action.build();
            action.sendKeys(new CharSequence[]{key}).perform();
        }
    }

    public static void scrollToTop() {
        HolmosWindow.runJavaScript("window.scrollTo(0,0)");
        logger.info("\u6eda\u52a8\u81f3\u9875\u9762\u9876\u7aef\u6210\u529f!");
    }

    public static void scrollToBottom() {
        HolmosWindow.runJavaScript("window.scrollTo(0,document.body.scrollHeight)");
        logger.info("\u6eda\u52a8\u81f3\u9875\u9762\u5e95\u90e8\u6210\u529f");
    }

    public static void scrollTo(int xLocation, int yLocation) {
        HolmosWindow.runJavaScript("window.scrollTo(" + xLocation + "," + yLocation + ");");
    }

    public static void upLoad(String localFilePath) {
        StringBuilder message = new StringBuilder(String.valueOf(localFilePath) + "\u6587\u4ef6\u4e0a\u4f20");
        try {
            String filePath = localFilePath;
            if (!new File(ConfigConstValue.UPLOADFILE).exists()) {
                message.append(":\u63d0\u4f9b\u4e0a\u4f20\u529f\u80fd\u7684\u811a\u672c\u4e0d\u5b58\u5728!\u8bf7\u8054\u7cfb\u9ec4\u5ead\u540c\u5b66\uff01");
                logger.error(message);
            } else if (!new File(filePath).exists()) {
                message.append(":\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b58\u5728!\u8bf7\u8054\u7cfb\u9ec4\u5ead\u540c\u5b66\uff01");
                logger.error(message);
            } else {
                String cmd = String.valueOf(ConfigConstValue.UPLOADFILE) + " " + "\u9009\u62e9\u8981\u4e0a\u4f20\u7684\u6587\u4ef6 " + filePath;
                Runtime.getRuntime().exec(cmd).waitFor();
                message.append(":\u811a\u672c\u542f\u52a8\u6210\u529f\uff01");
                logger.info(message);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void upLoad(String windowTitle, String localFilePath) {
        StringBuilder message = new StringBuilder(String.valueOf(localFilePath) + "\u6587\u4ef6\u4e0a\u4f20");
        String filePath = localFilePath;
        if (!new File(ConfigConstValue.UPLOADFILE).exists()) {
            message.append(":\u63d0\u4f9b\u4e0a\u4f20\u529f\u80fd\u7684\u811a\u672c\u4e0d\u5b58\u5728!\u8bf7\u8054\u7cfb\u72ec\u884c\u8005\u540c\u5b66\uff01");
            logger.error(message);
        } else if (!new File(filePath).exists()) {
            message.append(":\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b58\u5728!\u8bf7\u68c0\u67e5\u8981\u4e0a\u4f20\u7684\u6587\u4ef6\uff01");
            logger.error(message);
        } else {
            String cmd = String.valueOf(ConfigConstValue.UPLOADFILE) + " " + windowTitle + " " + filePath;
            try {
                Runtime.getRuntime().exec(cmd).waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            message.append(":\u811a\u672c\u542f\u52a8\u6210\u529f\uff01");
            logger.info(message);
        }
    }

    public static void CloseWindow(String title) {
        StringBuilder message = new StringBuilder();
        if (!new File(ConfigConstValue.CLOSEWINDOW).exists()) {
            message.append(":\u63d0\u4f9b\u5173\u95edwindows\u7a97\u53e3\u7684\u529f\u80fd\u7684\u811a\u672c\u4e0d\u5b58\u5728!\u8bf7\u8054\u7cfb\u72ec\u884c\u8005\uff01");
            logger.error(message);
        } else {
            String cmd = String.valueOf(ConfigConstValue.UPLOADFILE) + " " + title;
            try {
                Runtime.getRuntime().exec(cmd).waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            message.append(":\u811a\u672c\u542f\u52a8\u6210\u529f\uff01");
            logger.info(message);
        }
    }

    public static void downLoad(String localFilePath) {
        StringBuilder message = new StringBuilder(String.valueOf(localFilePath) + "\u6587\u4ef6\u4e0b\u8f7d");
        try {
            String filePath = localFilePath;
            if (!new File(ConfigConstValue.DOWNLOADFILE).exists()) {
                message.append(":\u63d0\u4f9b\u4e0a\u4f20\u529f\u80fd\u7684\u811a\u672c\u4e0d\u5b58\u5728!\u8bf7\u8054\u7cfb\u9ec4\u5ead\u540c\u5b66\uff01");
                logger.error(message);
            } else {
                String cmd = String.valueOf(ConfigConstValue.DOWNLOADFILE) + " " + "\u53e6\u5b58\u4e3a " + filePath;
                Runtime.getRuntime().exec(cmd).waitFor();
                message.append(":\u811a\u672c\u542f\u52a8\u6210\u529f\uff01");
                logger.info(message);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void downLoad(String windowTitle, String localFilePath) {
        StringBuilder message = new StringBuilder(String.valueOf(localFilePath) + "\u6587\u4ef6\u4e0b\u8f7d");
        try {
            String filePath = localFilePath;
            if (!new File(ConfigConstValue.DOWNLOADFILE).exists()) {
                message.append(":\u63d0\u4f9b\u4e0a\u4f20\u529f\u80fd\u7684\u811a\u672c\u4e0d\u5b58\u5728!\u8bf7\u8054\u7cfb\u9ec4\u5ead\u540c\u5b66\uff01");
                logger.error(message);
            } else {
                String cmd = String.valueOf(ConfigConstValue.DOWNLOADFILE) + " " + windowTitle + " " + filePath;
                Runtime.getRuntime().exec(cmd).waitFor();
                message.append(":\u811a\u672c\u542f\u52a8\u6210\u529f\uff01");
                logger.info(message);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String dealAlert() {
        return Allocator.getInstance().currentWindow.dealAlert();
    }

    public static String dealPrompt(String input, boolean isYes) {
        return Allocator.getInstance().currentWindow.dealPrompt(input, isYes);
    }

    public static String dealConfirm(boolean isYes) {
        return Allocator.getInstance().currentWindow.dealConfirm(isYes);
    }

    public static void TakeScreenshot(String fileName) {
        Allocator.getInstance().currentWindow.TakeScreenshot(String.valueOf(fileName) + ".png");
    }

    public static void takeScreenshot() {
        Allocator.getInstance().currentWindow.TakeScreenshot(String.valueOf(System.currentTimeMillis()) + ".png");
    }

    public static boolean isLoaded() {
        return Allocator.getInstance().currentWindow.isLoaded();
    }
}

