package com.horntell.remoteimageview;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

/**
 * Created by Maninder Taggar on 31/8/16.
 */

public class Downloader {
    private Context context;
    private static String TAG = Downloader.class.getCanonicalName().toString();
    private RemoteImageDownloadListener remoteImageDownloadListener;
    private ArrayList<String> imageIds;
    private String downloadUrl;

    public Downloader(Context context, String downloadUrl, ArrayList<String> imageIds, RemoteImageDownloadListener listener) {
        this.context = context;
        this.downloadUrl = downloadUrl;
        this.remoteImageDownloadListener = listener;
        this.imageIds = imageIds;
    }

    public Downloader(Context context, RemoteImageDownloadListener listener) {
        this.context = context;
        this.remoteImageDownloadListener = listener;
    }

    void start() {
        final int size = imageIds.size();
        new Thread(new Runnable() {
            @Override
            public void run() {
                StringBuilder commaSeparatedList = new StringBuilder();
                for (int i = 0; i < size; i++) {
                    commaSeparatedList.append(imageIds.get(i) + ",");
                }
                commaSeparatedList.deleteCharAt(commaSeparatedList.length() - 1);
                if (downloadFromArray(commaSeparatedList.toString())) {
                    new Handler(Looper.getMainLooper()).post(new Runnable() {
                        @Override
                        public void run() {
                            remoteImageDownloadListener.onCompleted();
                        }
                    });
                } else {
                    new Handler(Looper.getMainLooper()).post(new Runnable() {
                        @Override
                        public void run() {
                            remoteImageDownloadListener.onError();
                        }
                    });
                }
            }
        }).start();

    }

    private boolean downloadFromArray(String commaSepratedList) {
        String density = Helpers.getScreenDensity(context);
        String download_url = String.format(downloadUrl, density, commaSepratedList);

        try {
            URL url = new URL(download_url);
            InputStream in = new BufferedInputStream(url.openStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int n = 0;
            while (-1 != (n = in.read(buf))) {
                out.write(buf, 0, n);
            }
            out.close();
            in.close();

            JSONObject jsonObject = new JSONObject(out.toString());
            jsonObject = jsonObject.getJSONObject("data");

            int size = imageIds.size();
            for (int i = 0; i < size; i++) {
                String id = imageIds.get(i);
                String link = jsonObject.getString(id);
                if (link == null || link.equals("") || link.equals("null")) {
                    Log.d(TAG, "link is null");
                    return false;
                }
                if (!downloadFromLink(context, id, link)) {
                    return false;
                }
            }
            return true;
        } catch (MalformedURLException e) {
            Log.e(TAG, e.toString());
        } catch (FileNotFoundException e) {
            Log.e(TAG, e.toString());
        } catch (IOException e) {
            Log.e(TAG, e.toString());
        } catch (JSONException e) {
            Log.e(TAG, e.toString());
        }

        return false;
    }


    public static boolean downloadFromLink(Context context, String id, String downloadUrl) {
        File file = new File(context.getFilesDir() + "/" + id);
        if (file.exists()) {
            return true;
        }

        try {
            URL url = new URL(downloadUrl);
            InputStream in = new BufferedInputStream(url.openStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int n = 0;
            while (-1 != (n = in.read(buf))) {
                out.write(buf, 0, n);
            }
            out.close();
            in.close();
            byte[] imageByteArray = out.toByteArray();

            FileOutputStream outputStream = context.openFileOutput(id, Context.MODE_PRIVATE);
            outputStream.write(imageByteArray);
            outputStream.close();
            Log.d(TAG, id + " downloading success");

            return true;
        } catch (MalformedURLException e) {
            Log.e(TAG, e.toString());
        } catch (FileNotFoundException e) {
            Log.e(TAG, e.toString());
        } catch (IOException e) {
            Log.e(TAG, e.toString());
        }

        file.delete();

        return false;
    }

}
