package com.horntell.remoteimageview;

import android.content.Context;

/**
 * Created by Maninder Taggar on 9/11/16.
 */

class Helpers {
    public static String getScreenDensity(Context context) {
        float i = context.getResources().getDisplayMetrics().density;
        if (i == (float) 0.75) {
            return "ldpi";
        } else if (i == (float) 1.0) {
            return "mdpi";
        } else if (i == (float) 1.5) {
            return "hdpi";
        } else if (i == (float) 2.0) {
            return "xhdpi";
        } else if (i == (float) 3.0) {
            return "xxhdpi";
        } else if (i == (float) 4.0) {
            return "xxxhdpi";
        }
        return "default";
    }

    public static String verifyColor(String color) {
        if (color.length() == 4) {
            String newColor = "#"
                    + color.charAt(1) + color.charAt(1)
                    + color.charAt(2) + color.charAt(2)
                    + color.charAt(3) + color.charAt(3);

            return newColor;
        }
        if (color.length() == 5) {
            String newColor = "#"
                    + color.charAt(1) + color.charAt(1)
                    + color.charAt(2) + color.charAt(2)
                    + color.charAt(3) + color.charAt(3)
                    + color.charAt(4) + color.charAt(4);

            return newColor;
        }

        return color;
    }


}
