package com.horntell.remoteimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;

import java.io.FileInputStream;
import java.util.ArrayList;

/**
 * Created by Maninder Taggar on 31/8/16.
 */
public class RemoteImageView extends ImageView {
    private final String TAG = getClass().getCanonicalName().toString();

    private Context context;
    private final static int TYPE_URL = Constants.TYPE_URL;
    private final static int TYPE_COLOR = Constants.TYPE_COLOR;


    public RemoteImageView(Context context) {
        super(context);
    }

    public RemoteImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public RemoteImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.context = context;

        Log.d(TAG, "init: ");
        TypedArray a = getContext().obtainStyledAttributes(attrs, R.styleable.RemoteImageView);
        String src = a.getString(R.styleable.RemoteImageView_rmv_src);
        String background = a.getString(R.styleable.RemoteImageView_rmv_background);

        a.recycle();

        setRemoteImageSrc(src);
        setRemoteImageBackground(background);

    }

    public void setRemoteImageSrc(String src) {
        if (src != null && !src.isEmpty()) {
            switch (getType(src)) {
                case TYPE_COLOR:
                    setColorSrc(src);
                    break;
                case TYPE_URL:
                    setRemoteSrc(src);
                    break;
            }
        }

    }

    public void setRemoteImageBackground(String background) {
        if (background != null && !background.isEmpty()) {
            switch (getType(background)) {
                case TYPE_COLOR:
                    setColorBackground(background);
                    break;
                case TYPE_URL:
                    setRemoteBackground(background);
                    break;
            }
        }

    }

    private void setColorBackground(String background) {
        try {
            setBackgroundColor(Color.parseColor(Helpers.verifyColor(background)));
        } catch (Exception e) {
            Log.e(TAG, e.toString());
        }
    }

    private void setColorSrc(String src) {
        setColorBackground(src);
    }

    private int getType(String data) {
        Log.d(TAG, "getType: " + data);
        if (data.startsWith("#"))
            return TYPE_COLOR;

        return TYPE_URL;
    }

    private void setRemoteBackground(String background) {
        try {
            FileInputStream fis = context.openFileInput(background);
            Bitmap b = BitmapFactory.decodeStream(fis);
            fis.close();

            Drawable d = new BitmapDrawable(getResources(), b);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                setBackground(d);
            } else {
                setBackgroundDrawable(d);
            }
            Log.d(TAG, "setRemoteBackground: ");
        } catch (Exception e) {
            Log.e(TAG, e.toString());
        }

    }

    private void setRemoteSrc(String src) {
        try {
            FileInputStream fis = context.openFileInput(src);
            Bitmap b = BitmapFactory.decodeStream(fis);
            fis.close();
            setImageBitmap(b);
        } catch (Exception e) {
            Log.e(TAG, e.toString());
        }
    }

    public static void intialize(Context context, String url, ArrayList<String> imageIds, RemoteImageDownloadListener downloadListener) {
        new Downloader(context, url, imageIds, downloadListener).start();
    }

}
