/*
 * Decompiled with CFR 0.152.
 */
package com.horntell.remoteimageview;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.horntell.remoteimageview.Helpers;
import com.horntell.remoteimageview.RemoteImageDownloadListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class Downloader {
    private Context context;
    private static String TAG = Downloader.class.getCanonicalName().toString();
    private RemoteImageDownloadListener remoteImageDownloadListener;
    private ArrayList<String> imageIds;
    private String downloadUrl;

    public Downloader(Context context, String downloadUrl, ArrayList<String> imageIds, RemoteImageDownloadListener listener) {
        this.context = context;
        this.downloadUrl = downloadUrl;
        this.remoteImageDownloadListener = listener;
        this.imageIds = imageIds;
    }

    public Downloader(Context context, RemoteImageDownloadListener listener) {
        this.context = context;
        this.remoteImageDownloadListener = listener;
    }

    void start() {
        final int size = this.imageIds.size();
        new Thread(new Runnable(){

            @Override
            public void run() {
                StringBuilder commaSeparatedList = new StringBuilder();
                for (int i = 0; i < size; ++i) {
                    commaSeparatedList.append((String)Downloader.this.imageIds.get(i) + ",");
                }
                commaSeparatedList.deleteCharAt(commaSeparatedList.length() - 1);
                if (Downloader.this.downloadFromArray(commaSeparatedList.toString())) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            Downloader.this.remoteImageDownloadListener.onCompleted();
                        }
                    });
                } else {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            Downloader.this.remoteImageDownloadListener.onError();
                        }
                    });
                }
            }
        }).start();
    }

    private boolean downloadFromArray(String commaSepratedList) {
        String density = Helpers.getScreenDensity(this.context);
        String download_url = String.format(this.downloadUrl, density, commaSepratedList);
        try {
            URL url = new URL(download_url);
            BufferedInputStream in = new BufferedInputStream(url.openStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int n = 0;
            while (-1 != (n = ((InputStream)in).read(buf))) {
                out.write(buf, 0, n);
            }
            out.close();
            ((InputStream)in).close();
            JSONObject jsonObject = new JSONObject(out.toString());
            jsonObject = jsonObject.getJSONObject("data");
            int size = this.imageIds.size();
            for (int i = 0; i < size; ++i) {
                String id = this.imageIds.get(i);
                String link = jsonObject.getString(id);
                if (link == null || link.equals("") || link.equals("null")) {
                    Log.d((String)TAG, (String)"link is null");
                    return false;
                }
                if (Downloader.downloadFromLink(this.context, id, link)) continue;
                return false;
            }
            return true;
        }
        catch (MalformedURLException e) {
            Log.e((String)TAG, (String)e.toString());
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)e.toString());
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.toString());
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.toString());
        }
        return false;
    }

    public static boolean downloadFromLink(Context context, String id, String downloadUrl) {
        File file = new File(context.getFilesDir() + "/" + id);
        if (file.exists()) {
            return true;
        }
        try {
            URL url = new URL(downloadUrl);
            BufferedInputStream in = new BufferedInputStream(url.openStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int n = 0;
            while (-1 != (n = ((InputStream)in).read(buf))) {
                out.write(buf, 0, n);
            }
            out.close();
            ((InputStream)in).close();
            byte[] imageByteArray = out.toByteArray();
            FileOutputStream outputStream = context.openFileOutput(id, 0);
            outputStream.write(imageByteArray);
            outputStream.close();
            Log.d((String)TAG, (String)(id + " downloading success"));
            return true;
        }
        catch (MalformedURLException e) {
            Log.e((String)TAG, (String)e.toString());
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)e.toString());
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.toString());
        }
        file.delete();
        return false;
    }
}

