/*
 * Decompiled with CFR 0.152.
 */
package com.horntell.remoteimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import com.horntell.remoteimageview.Downloader;
import com.horntell.remoteimageview.Helpers;
import com.horntell.remoteimageview.R;
import com.horntell.remoteimageview.RemoteImageDownloadListener;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;

public class RemoteImageView
extends ImageView {
    private final String TAG = ((Object)((Object)this)).getClass().getCanonicalName().toString();
    private Context context;
    private static final int TYPE_URL = 0;
    private static final int TYPE_COLOR = 1;

    public RemoteImageView(Context context) {
        super(context);
    }

    public RemoteImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RemoteImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.context = context;
        Log.d((String)this.TAG, (String)"init: ");
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.RemoteImageView);
        String src = a.getString(R.styleable.RemoteImageView_rmv_src);
        String background = a.getString(R.styleable.RemoteImageView_rmv_background);
        a.recycle();
        this.setRemoteImageSrc(src);
        this.setRemoteImageBackground(background);
    }

    public void setRemoteImageSrc(String src) {
        if (src != null && !src.isEmpty()) {
            switch (this.getType(src)) {
                case 1: {
                    this.setColorSrc(src);
                    break;
                }
                case 0: {
                    this.setRemoteSrc(src);
                }
            }
        }
    }

    public void setRemoteImageBackground(String background) {
        if (background != null && !background.isEmpty()) {
            switch (this.getType(background)) {
                case 1: {
                    this.setColorBackground(background);
                    break;
                }
                case 0: {
                    this.setRemoteBackground(background);
                }
            }
        }
    }

    private void setColorBackground(String background) {
        try {
            this.setBackgroundColor(Color.parseColor((String)Helpers.verifyColor(background)));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)e.toString());
        }
    }

    private void setColorSrc(String src) {
        this.setColorBackground(src);
    }

    private int getType(String data) {
        Log.d((String)this.TAG, (String)("getType: " + data));
        if (data.startsWith("#")) {
            return 1;
        }
        return 0;
    }

    private void setRemoteBackground(String background) {
        try {
            FileInputStream fis = this.context.openFileInput(background);
            Bitmap b = BitmapFactory.decodeStream((InputStream)fis);
            fis.close();
            BitmapDrawable d = new BitmapDrawable(this.getResources(), b);
            if (Build.VERSION.SDK_INT >= 16) {
                this.setBackground((Drawable)d);
            } else {
                this.setBackgroundDrawable((Drawable)d);
            }
            Log.d((String)this.TAG, (String)"setRemoteBackground: ");
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)e.toString());
        }
    }

    private void setRemoteSrc(String src) {
        try {
            FileInputStream fis = this.context.openFileInput(src);
            Bitmap b = BitmapFactory.decodeStream((InputStream)fis);
            fis.close();
            this.setImageBitmap(b);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)e.toString());
        }
    }

    public static void intialize(Context context, String url, ArrayList<String> imageIds, RemoteImageDownloadListener downloadListener) {
        new Downloader(context, url, imageIds, downloadListener).start();
    }
}

