/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cache.view.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.hortonworks.registries.cache.view.config.BytesUnit;
import java.util.concurrent.TimeUnit;

public class ExpiryPolicy {
    private Ttl ttl;
    private long entries;
    private Size size;

    public ExpiryPolicy(Ttl ttl, long entries, Size size) {
        this.ttl = ttl;
        this.entries = entries;
        this.size = size;
    }

    public Ttl getTtl() {
        return this.ttl;
    }

    public void setTtl(Ttl ttl) {
        this.ttl = ttl;
    }

    public long getEntries() {
        return this.entries;
    }

    public void setEntries(long entries) {
        this.entries = entries;
    }

    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public boolean isTtl() {
        return this.ttl != null;
    }

    public boolean isEntries() {
        return this.entries != 0L;
    }

    public boolean isSize() {
        return this.size != null;
    }

    public class Size {
        private final long count;
        private final long bytes;
        private final BytesUnit unit;

        @JsonCreator
        public Size(long count, BytesUnit unit) {
            this.count = count;
            this.unit = unit;
            this.bytes = unit.toBytes(count);
        }

        public long getCount() {
            return this.count;
        }

        public long getBytes() {
            return this.bytes;
        }

        public BytesUnit getUnit() {
            return this.unit;
        }
    }

    public class Ttl {
        private long count;
        private TimeUnit unit;
        private final long ttlSeconds;

        public Ttl(long count, TimeUnit unit) {
            this.count = count;
            this.unit = unit;
            this.ttlSeconds = unit.toSeconds(count);
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public TimeUnit getUnit() {
            return this.unit;
        }

        public void setUnit(TimeUnit unit) {
            this.unit = unit;
        }

        public long getTtlSeconds() {
            return this.ttlSeconds;
        }
    }
}

