/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cache.view.impl.redis;

import com.hortonworks.registries.cache.Cache;
import com.hortonworks.registries.cache.exception.CacheException;
import com.hortonworks.registries.cache.stats.CacheStats;
import com.hortonworks.registries.cache.view.config.ExpiryPolicy;
import com.hortonworks.registries.cache.view.impl.redis.RedisAbstractCache;
import com.lambdaworks.redis.RedisConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisHashesCache<K, V>
extends RedisAbstractCache<K, V>
implements Cache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(RedisHashesCache.class);
    private final K key;

    public RedisHashesCache(RedisConnection<K, V> redisConnection, K key) {
        this(redisConnection, key, null);
    }

    public RedisHashesCache(RedisConnection<K, V> redisConnection, K key, ExpiryPolicy expiryPolicy) {
        super(redisConnection, expiryPolicy);
        this.key = key;
    }

    @Override
    public V get(K field) throws CacheException {
        return (V)this.redisConnection.hget(this.key, field);
    }

    @Override
    public Map<K, V> getAll(Collection<? extends K> fields) {
        Map present = this.redisConnection.hgetall(this.key);
        present.entrySet().retainAll(fields);
        LOG.debug("Entries existing in cache [{}]. Keys non existing in cache: [{}]", (Object)present, (Object)fields.removeAll(present.keySet()));
        return present;
    }

    @Override
    public void put(K field, V val) {
        this.redisConnection.hset(this.key, field, val);
        LOG.debug("Set (key, field, val) => ({},{})", new Object[]{this.key, field, val});
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> entries) {
        this.redisConnection.hmset(this.key, new HashMap<K, V>(entries));
    }

    @Override
    public void remove(K field) {
        this.redisConnection.hdel(this.key, new Object[]{field});
    }

    @Override
    public void removeAll(Collection<? extends K> fields) {
        this.redisConnection.del(fields.toArray(new Object[fields.size()]));
    }

    @Override
    public void clear() {
        this.redisConnection.del(new Object[]{this.key});
    }

    @Override
    public long size() {
        return this.redisConnection.hlen(this.key);
    }

    @Override
    public CacheStats stats() {
        return null;
    }
}

