/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cache.view.impl.redis;

import com.hortonworks.registries.cache.Cache;
import com.hortonworks.registries.cache.exception.CacheException;
import com.hortonworks.registries.cache.stats.CacheStats;
import com.hortonworks.registries.cache.view.config.ExpiryPolicy;
import com.hortonworks.registries.cache.view.impl.redis.RedisAbstractCache;
import com.lambdaworks.redis.RedisConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisStringsCache<K, V>
extends RedisAbstractCache<K, V>
implements Cache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(RedisStringsCache.class);

    public RedisStringsCache(RedisConnection<K, V> redisConnection) {
        this(redisConnection, null);
    }

    public RedisStringsCache(RedisConnection<K, V> redisConnection, ExpiryPolicy expiryPolicy) {
        super(redisConnection, expiryPolicy);
    }

    @Override
    public V get(K key) throws CacheException {
        return (V)this.redisConnection.get(key);
    }

    @Override
    public Map<K, V> getAll(Collection<? extends K> keys) {
        Object[] ks = keys.toArray(new Object[keys.size()]);
        List vals = this.redisConnection.mget(ks);
        HashMap present = new HashMap();
        if (ks.length != vals.size()) {
            LOG.error("Number of keys [{}] does not match unexpected number of values [{}]. Returning empty map");
        } else {
            for (int i = 0; i < vals.size(); ++i) {
                Object val = vals.get(i);
                if (val != null) {
                    present.put(ks[i], val);
                    continue;
                }
                LOG.debug("Key [{}] has null value. Skipping", ks[i]);
            }
        }
        LOG.debug("Entries existing in cache [{}]. Keys non existing in cache: [{}]", present, (Object)keys.removeAll(present.keySet()));
        return present;
    }

    @Override
    public void put(K key, V val) {
        this.redisConnection.set(key, val);
        LOG.debug("Set (key,val) => ({},{})", key, val);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> entries) {
        this.redisConnection.mset(new HashMap<K, V>(entries));
    }

    @Override
    public void remove(K key) {
        this.redisConnection.del(new Object[]{key});
    }

    @Override
    public void removeAll(Collection<? extends K> keys) {
        this.redisConnection.del(keys.toArray(new Object[keys.size()]));
    }

    @Override
    public void clear() {
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public CacheStats stats() {
        return null;
    }

    public static interface BytesCalculator<T> {
        public long computeBytes(T var1);
    }

    public static class Builder<K, V> {
        private static final long DEFAULT_MAX_BYTES = 0xA00000L;
        private long sizeBytes = 0xA00000L;
        private BytesCalculator bytesCalculator;
        private long maxSizeBytes;

        public Builder setMaxSizeBytes(long maxSizeBytes) {
            this.maxSizeBytes = maxSizeBytes;
            return this;
        }

        public Builder setMaxSizeBytesConverter(BytesCalculator bytesCalculator) {
            this.bytesCalculator = bytesCalculator;
            return this;
        }

        public Cache<K, V> build() {
            if (this.bytesCalculator != null) {
                LOG.debug("Setting ");
            }
            return null;
        }
    }
}

