/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cache.view.io.loader;

import com.hortonworks.registries.cache.Cache;
import com.hortonworks.registries.cache.view.datastore.DataStoreReader;
import com.hortonworks.registries.cache.view.io.loader.CacheLoaderCallback;
import java.util.Collection;
import org.slf4j.Logger;

public abstract class CacheLoader<K, V> {
    protected final Cache<K, V> cache;
    protected final DataStoreReader<K, V> dataStoreReader;

    public CacheLoader(Cache<K, V> cache, DataStoreReader<K, V> dataStoreReader) {
        this.cache = cache;
        this.dataStoreReader = dataStoreReader;
    }

    public abstract void loadAll(Collection<? extends K> var1, CacheLoaderCallback<K, V> var2);

    protected void handleException(Collection<? extends K> keys, CacheLoaderCallback<K, V> callback, Exception e, Logger LOG) {
        String msg = String.format("Exception occurred while loading keys [%s]", keys);
        callback.onCacheLoadingFailure(new Exception(msg, e));
        LOG.error(msg, (Throwable)e);
    }
}

