/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cache.view.service;

import com.hortonworks.registries.cache.view.Factory;
import com.hortonworks.registries.cache.view.config.CacheConfig;
import com.hortonworks.registries.cache.view.config.ExpiryPolicy;
import com.hortonworks.registries.cache.view.config.TypeConfig;
import com.hortonworks.registries.cache.view.config.ViewConfig;
import com.hortonworks.registries.cache.view.impl.redis.RedisHashesCache;
import com.hortonworks.registries.cache.view.impl.redis.RedisStringsCache;
import com.hortonworks.registries.cache.view.service.DataStoreBackedCacheService;
import com.lambdaworks.redis.RedisConnection;
import java.util.Arrays;
import java.util.List;

public class RedisCacheService<K, V>
extends DataStoreBackedCacheService<K, V> {
    private final Factory<RedisConnection<K, V>> connFactory;

    private RedisCacheService(Builder<K, V> builder) {
        super(builder);
        this.connFactory = ((Builder)builder).connFactory;
    }

    public void registerHashesCache(String id, K key) {
        this.registerHashesCache(id, key, this.expiryPolicy);
    }

    public void registerHashesCache(String id, K key, ExpiryPolicy expiryPolicy) {
        this.registerCache(id, this.createRedisHashesCache(key, expiryPolicy));
    }

    public void registerStringsCache(String id) {
        this.registerStringsCache(id, this.expiryPolicy);
    }

    public void registerStringsCache(String id, ExpiryPolicy expiryPolicy) {
        this.registerCache(id, this.createRedisStringsCache(expiryPolicy));
    }

    public void registerDelegateCache(String id) {
    }

    public Factory<RedisConnection<K, V>> getConnFactory() {
        return this.connFactory;
    }

    private RedisHashesCache<K, V> createRedisHashesCache(K key, ExpiryPolicy expiryPolicy) {
        ExpiryPolicy ep = expiryPolicy != null ? expiryPolicy : this.expiryPolicy;
        return new RedisHashesCache<K, V>(this.connFactory.create(), key, ep);
    }

    private RedisStringsCache<K, V> createRedisStringsCache(ExpiryPolicy expiryPolicy) {
        ExpiryPolicy ep = expiryPolicy != null ? expiryPolicy : this.expiryPolicy;
        return new RedisStringsCache<K, V>(this.connFactory.create(), ep);
    }

    public static class Builder<K, V>
    extends DataStoreBackedCacheService.Builder<K, V> {
        private final Factory<RedisConnection<K, V>> connFactory;

        public Builder(String id, TypeConfig.Cache cacheType, Factory<RedisConnection<K, V>> connFactory) {
            super(id, cacheType);
            this.connFactory = connFactory;
        }

        @Override
        public RedisCacheService<K, V> build() {
            return new RedisCacheService(this);
        }

        public RedisCacheService<K, V> build(CacheConfig cacheConfig) {
            RedisCacheService cacheService = new RedisCacheService(this);
            this.registerCaches(cacheService, cacheConfig);
            return cacheService;
        }

        private void registerCaches(RedisCacheService<K, V> cacheService, CacheConfig cacheConfig) {
            List<ViewConfig> viewsConfig = cacheConfig.getViewsConfig();
            for (ViewConfig viewConfig : viewsConfig) {
                this.registerCache(cacheService, viewConfig);
            }
        }

        private void registerCache(RedisCacheService<K, V> cacheService, ViewConfig viewConfig) {
            ExpiryPolicy expiryPolicy = viewConfig.getExpiryPolicy();
            String id = viewConfig.getId();
            TypeConfig.RedisDatatype redisDatatype = ((ViewConfig.RedisViewConfig)viewConfig).getRedisDatatype();
            switch (redisDatatype) {
                case STRINGS: {
                    cacheService.registerStringsCache(id, expiryPolicy);
                    break;
                }
                case HASHES: {
                    String key = ((ViewConfig.RedisViewConfig)viewConfig).getKey();
                    cacheService.registerHashesCache(id, key, expiryPolicy);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported Redis type: " + (Object)((Object)redisDatatype) + ". Valid options are " + Arrays.toString((Object[])TypeConfig.RedisDatatype.values()));
                }
            }
        }
    }
}

