/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cache.view.service;

import com.hortonworks.registries.cache.view.Factory;
import com.hortonworks.registries.cache.view.config.CacheConfig;
import com.hortonworks.registries.cache.view.config.ConnectionConfig;
import com.hortonworks.registries.cache.view.config.DataStoreConfig;
import com.hortonworks.registries.cache.view.config.ExpiryPolicy;
import com.hortonworks.registries.cache.view.config.TypeConfig;
import com.hortonworks.registries.cache.view.datastore.DataStoreReader;
import com.hortonworks.registries.cache.view.datastore.DataStoreWriter;
import com.hortonworks.registries.cache.view.datastore.phoenix.PhoenixDataStore;
import com.hortonworks.registries.cache.view.impl.redis.connection.RedisConnectionFactory;
import com.hortonworks.registries.cache.view.impl.redis.connection.RedisConnectionPoolFactory;
import com.hortonworks.registries.cache.view.io.loader.CacheLoaderAsyncFactory;
import com.hortonworks.registries.cache.view.io.loader.CacheLoaderFactory;
import com.hortonworks.registries.cache.view.io.loader.CacheLoaderSyncFactory;
import com.hortonworks.registries.cache.view.io.writer.CacheWriter;
import com.hortonworks.registries.cache.view.io.writer.CacheWriterAsync;
import com.hortonworks.registries.cache.view.io.writer.CacheWriterSync;
import com.hortonworks.registries.cache.view.service.CacheService;
import com.hortonworks.registries.cache.view.service.CacheServiceId;
import com.hortonworks.registries.cache.view.service.RedisCacheService;
import com.hortonworks.registries.cache.view.service.registry.CacheServiceLocalRegistry;
import com.hortonworks.registries.common.util.ReflectionHelper;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import java.util.Arrays;

public class RedisCacheServiceBuilder {
    private final CacheConfig cacheConfig;

    public RedisCacheServiceBuilder(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    public void register() {
        CacheServiceLocalRegistry.INSTANCE.register(new CacheServiceId(this.cacheConfig.getId()), this.getCacheService());
    }

    private <T extends CacheService> T getCacheService() {
        TypeConfig.Cache cacheType = this.cacheConfig.getCacheType();
        switch (cacheType) {
            case REDIS: {
                return (T)this.getRedisCacheService();
            }
            case GUAVA: {
                return (T)this.getGuavaCacheService();
            }
        }
        throw new IllegalStateException("Invalid cache option. " + (Object)((Object)cacheType) + ". Valid options are " + Arrays.toString((Object[])TypeConfig.Cache.values()));
    }

    private RedisCacheService getRedisCacheService() {
        String cacheServiceId = this.cacheConfig.getId();
        TypeConfig.Cache cacheType = this.cacheConfig.getCacheType();
        return (RedisCacheService)new RedisCacheService.Builder(cacheServiceId, cacheType, this.getRedisConnectionFactory()).setCacheLoaderFactory(this.getCacheLoaderFactory()).setCacheWriter(this.getCacheWriter(this.getDataStoreWriter(this.getNamespace()))).setDataStoreReader(this.getDataStoreReader(this.getNamespace())).setExpiryPolicy(this.getExpiryPolicy()).build();
    }

    private CacheService getGuavaCacheService() {
        throw new UnsupportedOperationException("Must implement Guava Cache Service");
    }

    private ExpiryPolicy getExpiryPolicy() {
        return this.cacheConfig.getExpiryPolicy();
    }

    private String getNamespace() {
        return this.cacheConfig.getDataStore().getNamespace();
    }

    private DataStoreWriter getDataStoreWriter(String namespace) {
        TypeConfig.DataStore dataStoreType = this.cacheConfig.getDataStore().getDataStoreType();
        switch (dataStoreType) {
            case PHOENIX: {
                return new PhoenixDataStore(namespace);
            }
            case MYSQL: {
                return null;
            }
            case HBASE: {
                return null;
            }
        }
        throw new IllegalStateException("Invalid DataStore option. " + (Object)((Object)dataStoreType) + ". Valid options are " + Arrays.toString((Object[])TypeConfig.DataStore.values()));
    }

    private DataStoreReader<Object, Object> getDataStoreReader(String namespace) {
        TypeConfig.DataStore dataStoreType = this.cacheConfig.getDataStore().getDataStoreType();
        switch (dataStoreType) {
            case PHOENIX: {
                return new PhoenixDataStore<Object, Object>(namespace);
            }
            case MYSQL: {
                return null;
            }
            case HBASE: {
                return null;
            }
        }
        throw new IllegalStateException("Invalid DataStore option. " + (Object)((Object)dataStoreType) + ". Valid options are " + Arrays.toString((Object[])TypeConfig.DataStore.values()));
    }

    private CacheWriter getCacheWriter(DataStoreWriter dataStoreWriter) {
        TypeConfig.CacheWriter cacheWriterType = this.cacheConfig.getDataStore().getCacheWriterType();
        switch (cacheWriterType) {
            case SYNC: {
                return new CacheWriterSync(dataStoreWriter);
            }
            case ASYNC: {
                return new CacheWriterAsync(dataStoreWriter);
            }
        }
        throw new IllegalStateException("Invalid CacheWriter option. " + (Object)((Object)cacheWriterType) + ". Valid options are " + Arrays.toString((Object[])TypeConfig.CacheWriter.values()));
    }

    private CacheLoaderFactory getCacheLoaderFactory() {
        DataStoreConfig dataStore = this.cacheConfig.getDataStore();
        if (dataStore != null) {
            TypeConfig.CacheLoader cacheLoaderType = dataStore.getCacheLoaderType();
            switch (cacheLoaderType) {
                case SYNC: {
                    return new CacheLoaderSyncFactory();
                }
                case ASYNC: {
                    return new CacheLoaderAsyncFactory();
                }
            }
            throw new IllegalStateException("Invalid CacheLoader option. " + (Object)((Object)cacheLoaderType) + ". Valid options are " + Arrays.toString((Object[])TypeConfig.CacheLoader.values()));
        }
        return null;
    }

    private Factory<RedisConnection> getRedisConnectionFactory() {
        ConnectionConfig.RedisConnectionConfig connectionConfig = (ConnectionConfig.RedisConnectionConfig)this.cacheConfig.getConnectionConfig();
        if (connectionConfig != null) {
            if (connectionConfig.getPool() != null) {
                return new RedisConnectionPoolFactory(RedisClient.create((String)this.getRedisUri()), this.getRedisCodec());
            }
            return new RedisConnectionFactory(RedisClient.create((String)this.getRedisUri()), this.getRedisCodec());
        }
        return null;
    }

    private RedisCodec getRedisCodec() {
        String codec = this.cacheConfig.getCacheEntry().getCodec();
        if (codec != null) {
            return new Utf8StringCodec();
        }
        try {
            return (RedisCodec)ReflectionHelper.newInstance((String)codec);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred creating codec", e);
        }
    }

    private String getRedisUri() {
        ConnectionConfig.RedisConnectionConfig rcc = (ConnectionConfig.RedisConnectionConfig)this.cacheConfig.getConnectionConfig();
        return "redis://" + rcc.getHost() + ":" + rcc.getPort();
    }
}

