/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cache.view.test;

import com.hortonworks.registries.cache.view.test.RedisClients;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCacheTestMain {
    protected static final Logger LOG = LoggerFactory.getLogger(RedisCacheTestMain.class);
    private static RedisConnection<String, String> connection;
    private static RedisConnection<String, String> connection1;
    private static Executor executor;

    public static void main(String[] args) throws InterruptedException {
        RedisCacheTestMain.setConnection();
        RedisCacheTestMain.setExecutor();
        RedisCacheTestMain.runClients();
        List keys = connection.keys((Object)"*");
        LOG.info("{}", (Object)keys);
        RedisCacheTestMain.readInput();
    }

    private static void runClients() {
        executor.execute(new RedisClients.Client1());
        executor.execute(new RedisClients.Client2());
    }

    private static void setExecutor() {
        executor = Executors.newFixedThreadPool(4);
    }

    private static void setConnection() {
        RedisClient redisClient = RedisClient.create((String)"redis://127.0.0.1:6379");
        connection = redisClient.connect();
        connection1 = redisClient.connect();
    }

    public static RedisConnection<String, String> getConnection() {
        return connection;
    }

    public static RedisConnection<String, String> getConnection1() {
        return connection1;
    }

    public static void readInput() {
        LOG.info("Type ENTER to stop");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            br.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

