/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2015 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.hortonworks.registries.shaded.org.glassfish.jersey.jackson;

import com.hortonworks.registries.shaded.javax.ws.rs.core.Configuration;
import com.hortonworks.registries.shaded.javax.ws.rs.core.Feature;
import com.hortonworks.registries.shaded.javax.ws.rs.core.FeatureContext;
import com.hortonworks.registries.shaded.javax.ws.rs.ext.MessageBodyReader;
import com.hortonworks.registries.shaded.javax.ws.rs.ext.MessageBodyWriter;

import com.hortonworks.registries.shaded.org.glassfish.jersey.CommonProperties;
import com.hortonworks.registries.shaded.org.glassfish.jersey.internal.InternalProperties;
import com.hortonworks.registries.shaded.org.glassfish.jersey.internal.util.PropertiesHelper;
import com.hortonworks.registries.shaded.org.glassfish.jersey.jackson.internal.FilteringJacksonJaxbJsonProvider;
import com.hortonworks.registries.shaded.org.glassfish.jersey.jackson.internal.JacksonFilteringFeature;
import com.hortonworks.registries.shaded.org.glassfish.jersey.message.filtering.EntityFilteringFeature;

import com.hortonworks.registries.shaded.com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.hortonworks.registries.shaded.com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import com.hortonworks.registries.shaded.com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;

/**
 * Feature used to register Jackson JSON providers.
 *
 * @author Stepan Kopriva
 * @author Michal Gajdos
 */
public class JacksonFeature implements Feature {

    private static final String JSON_FEATURE = JacksonFeature.class.getSimpleName();

    @Override
    public boolean configure(final FeatureContext context) {
        final Configuration config = context.getConfiguration();

        final String jsonFeature = CommonProperties.getValue(config.getProperties(), config.getRuntimeType(),
                InternalProperties.JSON_FEATURE, JSON_FEATURE, String.class);
        // Other JSON providers registered.
        if (!JSON_FEATURE.equalsIgnoreCase(jsonFeature)) {
            return false;
        }

        // Disable other JSON providers.
        context.property(PropertiesHelper.getPropertyNameForRuntime(InternalProperties.JSON_FEATURE, config.getRuntimeType()),
                JSON_FEATURE);

        // Register Jackson.
        if (!config.isRegistered(JacksonJaxbJsonProvider.class)) {
            // add the default Jackson exception mappers
            context.register(JsonParseExceptionMapper.class);
            context.register(JsonMappingExceptionMapper.class);

            if (EntityFilteringFeature.enabled(config)) {
                context.register(JacksonFilteringFeature.class);
                context.register(FilteringJacksonJaxbJsonProvider.class, MessageBodyReader.class, MessageBodyWriter.class);
            } else {
                context.register(JacksonJaxbJsonProvider.class, MessageBodyReader.class, MessageBodyWriter.class);
            }
        }

        return true;
    }
}
