/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2016 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.hortonworks.registries.shaded.org.jvnet.hk2.internal;

import java.util.Collections;
import java.util.Map;

import com.hortonworks.registries.shaded.org.glassfish.hk2.api.ActiveDescriptor;
import com.hortonworks.registries.shaded.org.glassfish.hk2.api.Injectee;
import com.hortonworks.registries.shaded.org.glassfish.hk2.api.InstanceLifecycleEvent;
import com.hortonworks.registries.shaded.org.glassfish.hk2.api.InstanceLifecycleEventType;

/**
 * @author jwells
 *
 */
public class InstanceLifecycleEventImpl implements InstanceLifecycleEvent {
    private final InstanceLifecycleEventType eventType;
    private final ActiveDescriptor<?> descriptor;
    private final Object lifecycleObject;
    private final Map<Injectee, Object> knownInjectees;
    
    /* package */ InstanceLifecycleEventImpl(InstanceLifecycleEventType eventType,
            Object lifecycleObject, Map<Injectee,Object> knownInjectees, ActiveDescriptor<?> descriptor) {
        this.eventType = eventType;
        this.lifecycleObject = lifecycleObject;
        if (knownInjectees == null) {
            this.knownInjectees = null;
        }
        else {
            this.knownInjectees = Collections.unmodifiableMap(knownInjectees);
        }
        this.descriptor = descriptor;
    }
    
    /* package */ InstanceLifecycleEventImpl(InstanceLifecycleEventType eventType,
            Object lifecycleObject, ActiveDescriptor<?> descriptor) {
        this(eventType, lifecycleObject, null, descriptor);
    }

    /* (non-Javadoc)
     * @see com.hortonworks.registries.shaded.org.glassfish.hk2.api.InstanceLifecycleEvent#getEventType()
     */
    @Override
    public InstanceLifecycleEventType getEventType() {
        return eventType;
    }

    /* (non-Javadoc)
     * @see com.hortonworks.registries.shaded.org.glassfish.hk2.api.InstanceLifecycleEvent#getActiveDescriptor()
     */
    @Override
    public ActiveDescriptor<?> getActiveDescriptor() {
        return descriptor;
    }
    
    /* (non-Javadoc)
     * @see com.hortonworks.registries.shaded.org.glassfish.hk2.api.InstanceLifecycleEvent#getLifecycleObject()
     */
    @Override
    public Object getLifecycleObject() {
        return lifecycleObject;
    }

    /* (non-Javadoc)
     * @see com.hortonworks.registries.shaded.org.glassfish.hk2.api.InstanceLifecycleEvent#getKnownInjectees()
     */
    @Override
    public Map<Injectee, Object> getKnownInjectees() {
        return knownInjectees;
    }

    public String toString() {
        String descName = (descriptor == null) ? "null" : descriptor.getImplementation() ;
        
        return "InstanceLifecycleEventImpl(" + eventType + "," + descName + "," + System.identityHashCode(this) + ")";
    }
}
