/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.shaded.javax.ws.rs.ext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FactoryFinder {
    private static final Logger LOGGER = Logger.getLogger(FactoryFinder.class.getName());

    private FactoryFinder() {
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException ex) {
                    LOGGER.log(Level.WARNING, "Unable to get context classloader instance.", ex);
                }
                return cl;
            }
        });
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> spiClass;
            if (classLoader == null) {
                spiClass = Class.forName(className);
            } else {
                try {
                    spiClass = Class.forName(className, false, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    LOGGER.log(Level.FINE, "Unable to load provider class " + className + " using custom classloader " + classLoader.getClass().getName() + " trying again with current classloader.", ex);
                    spiClass = Class.forName(className);
                }
            }
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw x;
        }
        catch (Exception x) {
            throw new ClassNotFoundException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static Object find(String factoryId, String fallbackClassName) throws ClassNotFoundException {
        block39: {
            block36: {
                block37: {
                    block38: {
                        block34: {
                            block35: {
                                classLoader = FactoryFinder.getContextClassLoader();
                                serviceId = "META-INF/services/" + factoryId;
                                reader = null;
                                is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
                                if (is == null || (factoryClassName = (reader = new BufferedReader(new InputStreamReader(is, "UTF-8"))).readLine()) == null || "".equals(factoryClassName)) break block34;
                                var7_10 = FactoryFinder.newInstance(factoryClassName, classLoader);
                                if (reader == null) break block35;
                                try {
                                    reader.close();
                                }
                                catch (IOException ex) {
                                    FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{serviceId}), ex);
                                }
                            }
                            return var7_10;
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException ex) {
                                FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{serviceId}), ex);
                            }
                        }
                        break block38;
                        catch (Exception ex) {
                            try {
                                FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + " from " + serviceId, ex);
                                ** if (reader == null) goto lbl-1000
                            }
                            catch (Throwable var9_18) {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (IOException ex) {
                                        FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{serviceId}), ex);
                                    }
                                }
                                throw var9_18;
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    reader.close();
                                }
                                catch (IOException ex) {
                                    FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{serviceId}), ex);
                                }
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                    }
                    inputStream = null;
                    configFile = null;
                    javah = System.getProperty("java.home");
                    configFile = javah + File.separator + "lib" + File.separator + "jaxrs.properties";
                    f = new File(configFile);
                    if (!f.exists()) break block36;
                    props = new Properties();
                    inputStream = new FileInputStream(f);
                    props.load(inputStream);
                    factoryClassName = props.getProperty(factoryId);
                    var11_22 = FactoryFinder.newInstance(factoryClassName, classLoader);
                    if (inputStream == null) break block37;
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {
                        FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                    }
                }
                return var11_22;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                }
            }
            break block39;
            catch (Exception ex) {
                try {
                    FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + " from $java.home/lib/jaxrs.properties", ex);
                    ** if (inputStream == null) goto lbl-1000
                }
                catch (Throwable var13_24) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ex) {
                            FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                        }
                    }
                    throw var13_24;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {
                        FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                    }
                }
lbl-1000:
                // 2 sources

                {
                }
            }
        }
        try {
            systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                return FactoryFinder.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException se) {
            FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + " from a system property", se);
        }
        if (fallbackClassName == null) {
            throw new ClassNotFoundException("Provider for " + factoryId + " cannot be found", null);
        }
        return FactoryFinder.newInstance(fallbackClassName, classLoader);
    }
}

