/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cron;

import com.hortonworks.registries.schemaregistry.HAServerNotificationManager;
import com.hortonworks.registries.schemaregistry.HostConfigStorable;
import com.hortonworks.registries.storage.Storable;
import com.hortonworks.registries.storage.StorageManager;
import com.hortonworks.registries.storage.TransactionManager;
import com.hortonworks.registries.storage.transaction.TransactionIsolation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshHAServerListTask
extends TimerTask {
    private StorageManager storageManager;
    private TransactionManager transactionManager;
    private HAServerNotificationManager haServerNotificationManager;
    private static final Logger LOG = LoggerFactory.getLogger(RefreshHAServerListTask.class);

    public RefreshHAServerListTask(StorageManager storageManager, TransactionManager transactionManager, HAServerNotificationManager haServerNotificationManager) {
        this.storageManager = storageManager;
        this.transactionManager = transactionManager;
        this.haServerNotificationManager = haServerNotificationManager;
    }

    @Override
    public void run() {
        try {
            this.transactionManager.beginTransaction(TransactionIsolation.SERIALIZABLE);
            Collection hostConfigStorables = this.storageManager.list("host_config");
            List hostConfigWithoutStaleEntries = hostConfigStorables.stream().filter(hostConfigStorable -> {
                if (System.currentTimeMillis() - hostConfigStorable.getTimestamp() > 600000L) {
                    LOG.debug("Removing : {} from list of available servers", (Object)hostConfigStorable.getHostUrl());
                    this.storageManager.remove(hostConfigStorable.getStorableKey());
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
            LOG.debug("Fetched : {} as the latest available servers", (Object)Arrays.toString(hostConfigWithoutStaleEntries.toArray()));
            this.haServerNotificationManager.refreshServerInfo(hostConfigWithoutStaleEntries);
            HostConfigStorable hostConfWithUpdatedTimeStamp = (HostConfigStorable)this.storageManager.get(new HostConfigStorable(this.haServerNotificationManager.getHomeNodeURL()).getStorableKey());
            if (hostConfWithUpdatedTimeStamp == null) {
                hostConfWithUpdatedTimeStamp = new HostConfigStorable(this.storageManager.nextId("host_config"), this.haServerNotificationManager.getHomeNodeURL(), Long.valueOf(System.currentTimeMillis()));
            } else {
                hostConfWithUpdatedTimeStamp.setTimestamp(Long.valueOf(System.currentTimeMillis()));
            }
            this.storageManager.addOrUpdate((Storable)hostConfWithUpdatedTimeStamp);
            this.transactionManager.commitTransaction();
        }
        catch (Exception e) {
            this.transactionManager.rollbackTransaction();
            throw e;
        }
    }
}

