/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cron;

import com.hortonworks.registries.cron.RefreshHAServerListTask;
import com.hortonworks.registries.schemaregistry.HAServerNotificationManager;
import com.hortonworks.registries.storage.StorageManager;
import com.hortonworks.registries.storage.TransactionManager;
import io.dropwizard.lifecycle.Managed;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshHAServerManagedTask
implements Managed {
    private StorageManager storageManager;
    private TransactionManager transactionManager;
    private HAServerNotificationManager haServerNotificationManager;
    private RefreshHAServerListTask refreshHAServerListTask;
    private Timer timer = new Timer();
    protected Long HOST_LIST_SYNC_INTERVAL_IN_MILLISEC = 15000L;
    private static final Logger LOG = LoggerFactory.getLogger(RefreshHAServerManagedTask.class);

    public RefreshHAServerManagedTask(StorageManager storageManager, TransactionManager transactionManager, HAServerNotificationManager haServerNotificationManager) {
        this.storageManager = storageManager;
        this.transactionManager = transactionManager;
        this.haServerNotificationManager = haServerNotificationManager;
        this.refreshHAServerListTask = new RefreshHAServerListTask(storageManager, transactionManager, haServerNotificationManager);
    }

    public void start() {
        LOG.debug("Kick start timer task to send heartbeat to the database and sync up the latest nodes in HA mode");
        this.timer.scheduleAtFixedRate((TimerTask)this.refreshHAServerListTask, 0L, (long)this.HOST_LIST_SYNC_INTERVAL_IN_MILLISEC);
    }

    public void stop() throws Exception {
        LOG.debug("Shutdown timer task for sending heartbeat to the database");
        this.timer.cancel();
    }
}

