/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.ha.zk;

import com.google.common.base.Preconditions;
import com.hortonworks.registries.common.ha.LeadershipParticipant;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKLeadershipParticipant
implements LeadershipParticipant {
    public static final String LEADER_LOCK_NODE_PATH = "-leader-lock";
    public static final int DEFAULT_CONN_TIMOUT = 201000;
    public static final int DEFAULT_SESSION_TIMEOUT = 301000;
    public static final int DEFAULT_BASE_SLEEP_TIME = 1000;
    public static final int DEFAULT_MAX_SLEEP_TIME = 5000;
    public static final int DEFAULT_RETRY_LIMIT = 5;
    private static final Logger LOG = LoggerFactory.getLogger(ZKLeadershipParticipant.class);
    public static final String CONNECT_URL = "connect.url";
    public static final String CONNECTION_TIMEOUT_MS = "connection.timeout.ms";
    public static final String SESSION_TIMEOUT_MS = "session.timeout.ms";
    public static final String RETRY_BASE_SLEEP_TIME_MS = "retry.base.sleep.time.ms";
    public static final String RETRY_MAX_SLEEP_TIME_MS = "retry.max.sleep.time.ms";
    public static final String RETRY_LIMIT = "retry.limit";
    private CuratorFramework curatorFramework;
    private Map<String, Object> conf;
    private String serverUrl;
    private LeaderLatchListener leaderLatchListener;
    private AtomicReference<LeaderLatch> leaderLatchRef;
    private String leaderLatchPath;

    public void init(Map<String, Object> conf, String participantId) {
        Preconditions.checkNotNull((Object)participantId, (Object)"participantId can not be null");
        Preconditions.checkNotNull(conf, (Object)"conf can not be null");
        this.conf = conf;
        this.serverUrl = participantId;
        this.leaderLatchListener = this.createLeaderLatchListener();
        LOG.info("Received configuration : [{}]", conf);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        String url = (String)conf.get(CONNECT_URL);
        String rootPrefix = (String)conf.get("root");
        builder.connectString(url);
        builder.connectionTimeoutMs(((Integer)conf.getOrDefault(CONNECTION_TIMEOUT_MS, 201000)).intValue());
        builder.sessionTimeoutMs(((Integer)conf.getOrDefault(SESSION_TIMEOUT_MS, 301000)).intValue());
        builder.retryPolicy((RetryPolicy)new BoundedExponentialBackoffRetry(((Integer)conf.getOrDefault(RETRY_BASE_SLEEP_TIME_MS, 1000)).intValue(), ((Integer)conf.getOrDefault(RETRY_MAX_SLEEP_TIME_MS, 5000)).intValue(), ((Integer)conf.getOrDefault(RETRY_LIMIT, 5)).intValue()));
        this.curatorFramework = builder.build();
        this.leaderLatchPath = rootPrefix + LEADER_LOCK_NODE_PATH;
        this.leaderLatchRef = new AtomicReference<LeaderLatch>(this.createLeaderLatch());
        this.curatorFramework.start();
    }

    private LeaderLatchListener createLeaderLatchListener() {
        return new LeaderLatchListener(){

            public void isLeader() {
                LOG.info("This instance with id [{}] acquired leadership", (Object)ZKLeadershipParticipant.this.serverUrl);
            }

            public void notLeader() {
                LOG.info("This instance with id [{}] lost leadership", (Object)ZKLeadershipParticipant.this.serverUrl);
            }
        };
    }

    private LeaderLatch createLeaderLatch() {
        return new LeaderLatch(this.curatorFramework, this.leaderLatchPath, this.serverUrl);
    }

    public boolean checkLeaderLatchPathExists() {
        try {
            this.curatorFramework.getChildren().forPath(this.leaderLatchPath);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void participateForLeadership() throws Exception {
        if (LeaderLatch.State.CLOSED.equals((Object)this.leaderLatchRef.get().getState())) {
            this.leaderLatchRef.get().removeListener(this.leaderLatchListener);
            this.leaderLatchRef.set(this.createLeaderLatch());
            this.leaderLatchRef.get().addListener(this.leaderLatchListener);
            LOG.info("Existing leader latch is in CLOSED state, it is recreated.");
        }
        if (LeaderLatch.State.LATENT.equals((Object)this.leaderLatchRef.get().getState())) {
            this.leaderLatchRef.get().start();
            LOG.info("Existing leader latch is in LATENT state, it is started. leader latch: [{}]", (Object)this.leaderLatchRef.get());
        }
    }

    public String getCurrentLeader() throws Exception {
        return this.leaderLatchRef.get().getLeader().getId();
    }

    public void exitFromLeaderParticipation() throws IOException {
        this.leaderLatchRef.get().close();
    }

    public boolean isLeader() {
        return this.leaderLatchRef.get().hasLeadership();
    }

    public void close() throws IOException {
        this.leaderLatchRef.get().close();
        this.curatorFramework.close();
    }

    public String toString() {
        return "ZKLeadershipParticipant{conf=" + this.conf + ", serverUrl='" + this.serverUrl + '\'' + ", leaderLatchPath='" + this.leaderLatchPath + '\'' + '}' + super.toString();
    }
}

