/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.storage.transaction;

import com.hortonworks.registries.storage.TransactionManager;
import com.hortonworks.registries.storage.transaction.TransactionIsolation;
import com.hortonworks.registries.storage.transaction.UnitOfWork;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

public class TransactionEventListener
implements ApplicationEventListener {
    private final ConcurrentMap<ResourceMethod, Optional<UnitOfWork>> methodMap = new ConcurrentHashMap<ResourceMethod, Optional<UnitOfWork>>();
    private final TransactionManager transactionManager;
    private final boolean runWithTxnIfNotConfigured;
    private TransactionIsolation defaultTransactionIsolation;

    public TransactionEventListener(TransactionManager transactionManager) {
        this(transactionManager, false);
    }

    public TransactionEventListener(TransactionManager transactionManager, TransactionIsolation defaultTransactionIsolation) {
        this(transactionManager, false);
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public TransactionEventListener(TransactionManager transactionManager, boolean runWithTxnIfNotConfigured) {
        this.transactionManager = transactionManager;
        this.runWithTxnIfNotConfigured = runWithTxnIfNotConfigured;
    }

    public TransactionEventListener(TransactionManager transactionManager, boolean runWithTxnIfNotConfigured, TransactionIsolation defaultTransactionIsolation) {
        this.transactionManager = transactionManager;
        this.runWithTxnIfNotConfigured = runWithTxnIfNotConfigured;
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public void onEvent(ApplicationEvent applicationEvent) {
    }

    public RequestEventListener onRequest(RequestEvent requestEvent) {
        return new UnitOfWorkEventListener(this.methodMap, this.transactionManager, this.runWithTxnIfNotConfigured, this.defaultTransactionIsolation);
    }

    private static class UnitOfWorkEventListener
    implements RequestEventListener {
        private final ConcurrentMap<ResourceMethod, Optional<UnitOfWork>> methodMap;
        private final TransactionManager transactionManager;
        private final boolean runWithTxnIfNotConfigured;
        private final TransactionIsolation defaultTransactionIsolation;
        private boolean useTransactionForUnitOfWork = true;
        private boolean isTransactionActive = false;

        public UnitOfWorkEventListener(ConcurrentMap<ResourceMethod, Optional<UnitOfWork>> methodMap, TransactionManager transactionManager, boolean runWithTxnIfNotConfigured, TransactionIsolation defaultTransactionIsolation) {
            this.methodMap = methodMap;
            this.transactionManager = transactionManager;
            this.runWithTxnIfNotConfigured = runWithTxnIfNotConfigured;
            this.defaultTransactionIsolation = defaultTransactionIsolation;
        }

        public void onEvent(RequestEvent event) {
            RequestEvent.Type eventType = event.getType();
            if (eventType == RequestEvent.Type.RESOURCE_METHOD_START) {
                Optional unitOfWork = this.methodMap.computeIfAbsent(event.getUriInfo().getMatchedResourceMethod(), UnitOfWorkEventListener::registerUnitOfWorkAnnotations);
                this.useTransactionForUnitOfWork = unitOfWork.map(UnitOfWork::transactional).orElse(this.runWithTxnIfNotConfigured);
                TransactionIsolation transactionIsolation = unitOfWork.map(x -> {
                    TransactionIsolation result = x.transactionIsolation();
                    if (result == TransactionIsolation.APPLICATION_DEFAULT) {
                        result = this.defaultTransactionIsolation == null ? TransactionIsolation.DATABASE_SENSITIVE : this.defaultTransactionIsolation;
                    }
                    return result;
                }).orElse(TransactionIsolation.DATABASE_SENSITIVE);
                if (this.useTransactionForUnitOfWork) {
                    this.transactionManager.beginTransaction(transactionIsolation);
                    this.isTransactionActive = true;
                }
            } else if (eventType == RequestEvent.Type.RESP_FILTERS_START) {
                if (this.useTransactionForUnitOfWork && this.isTransactionActive) {
                    if (event.getContainerResponse().getStatus() < 400) {
                        this.transactionManager.commitTransaction();
                    } else {
                        this.transactionManager.rollbackTransaction();
                    }
                    this.isTransactionActive = false;
                }
            } else if (eventType == RequestEvent.Type.ON_EXCEPTION && this.useTransactionForUnitOfWork && this.isTransactionActive) {
                this.transactionManager.rollbackTransaction();
                this.isTransactionActive = false;
            }
        }

        private static Optional<UnitOfWork> registerUnitOfWorkAnnotations(ResourceMethod method) {
            UnitOfWork annotation = method.getInvocable().getDefinitionMethod().getAnnotation(UnitOfWork.class);
            if (annotation == null) {
                annotation = method.getInvocable().getHandlingMethod().getAnnotation(UnitOfWork.class);
            }
            return Optional.ofNullable(annotation);
        }
    }
}

