/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.webservice;

import com.codahale.metrics.health.HealthCheck;
import com.hortonworks.registries.common.FileStorageConfiguration;
import com.hortonworks.registries.common.GenericExceptionMapper;
import com.hortonworks.registries.common.HAConfiguration;
import com.hortonworks.registries.common.ModuleConfiguration;
import com.hortonworks.registries.common.ModuleRegistration;
import com.hortonworks.registries.common.ServletFilterConfiguration;
import com.hortonworks.registries.common.ha.LeadershipAware;
import com.hortonworks.registries.common.ha.LeadershipParticipant;
import com.hortonworks.registries.common.ha.LocalLeader;
import com.hortonworks.registries.common.util.FileStorage;
import com.hortonworks.registries.cron.RefreshHAServerManagedTask;
import com.hortonworks.registries.schemaregistry.DefaultSchemaRegistry;
import com.hortonworks.registries.schemaregistry.HAServerNotificationManager;
import com.hortonworks.registries.schemaregistry.HAServersAware;
import com.hortonworks.registries.schemaregistry.HostConfigStorable;
import com.hortonworks.registries.storage.NOOPTransactionManager;
import com.hortonworks.registries.storage.Storable;
import com.hortonworks.registries.storage.StorageManager;
import com.hortonworks.registries.storage.StorageManagerAware;
import com.hortonworks.registries.storage.StorageProviderConfiguration;
import com.hortonworks.registries.storage.TransactionManager;
import com.hortonworks.registries.storage.TransactionManagerAware;
import com.hortonworks.registries.storage.transaction.TransactionEventListener;
import com.hortonworks.registries.storage.transaction.TransactionIsolation;
import com.hortonworks.registries.webservice.RegistryConfiguration;
import com.hortonworks.registries.webservice.healthchecks.DummyHealthCheck;
import io.dropwizard.Application;
import io.dropwizard.Bundle;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.federecio.dropwizard.swagger.SwaggerBundle;
import io.federecio.dropwizard.swagger.SwaggerBundleConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryApplication
extends Application<RegistryConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryApplication.class);
    protected AtomicReference<LeadershipParticipant> leadershipParticipantRef = new AtomicReference();
    protected StorageManager storageManager;
    protected HAServerNotificationManager haServerNotificationManager = new HAServerNotificationManager();
    protected TransactionManager transactionManager;
    protected RefreshHAServerManagedTask refreshHAServerManagedTask;

    public void run(RegistryConfiguration registryConfiguration, Environment environment) throws Exception {
        this.initializeUGI(registryConfiguration);
        this.registerHA(registryConfiguration.getHaConfig(), environment);
        this.registerResources(environment, registryConfiguration);
        environment.jersey().register(GenericExceptionMapper.class);
        environment.healthChecks().register("dummy", (HealthCheck)new DummyHealthCheck());
        if (registryConfiguration.isEnableCors()) {
            this.enableCORS(environment);
        }
        this.addServletFilters(registryConfiguration, environment);
        this.registerAndNotifyOtherServers(registryConfiguration, environment);
    }

    private void initializeUGI(RegistryConfiguration conf) throws IOException {
        if (conf.getServiceAuthenticationConfiguration() != null) {
            String authenticationType = conf.getServiceAuthenticationConfiguration().getType();
            if (authenticationType != null && authenticationType.equals("kerberos")) {
                Map serviceAuthenticationProperties = conf.getServiceAuthenticationConfiguration().getProperties();
                if (serviceAuthenticationProperties != null) {
                    String principal = (String)serviceAuthenticationProperties.get("principal");
                    String keytab = (String)serviceAuthenticationProperties.get("keytab");
                    if (StringUtils.isNotEmpty((CharSequence)principal) && StringUtils.isNotEmpty((CharSequence)keytab)) {
                        LOG.debug("Login with principal = '" + principal + "' and keyTab = '" + keytab + "'");
                        try {
                            UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
                            LOG.debug("Successfully logged in");
                        }
                        catch (Exception e) {
                            LOG.error("Failed to log in", (Throwable)e);
                        }
                    } else {
                        LOG.error("Invalid service authentication configuration for 'kerberos' principal = '" + principal + "' and keytab = '" + keytab + "'");
                    }
                } else {
                    LOG.error("No service authentication properties were configured for 'kerberos'");
                }
            } else {
                LOG.error("Invalid service authentication type : " + authenticationType);
            }
        } else {
            LOG.debug("No service authentication is configured");
        }
    }

    private void registerAndNotifyOtherServers(final RegistryConfiguration configuration, final Environment environment) {
        environment.lifecycle().addServerLifecycleListener(new ServerLifecycleListener(){

            public void serverStarted(Server server) {
                DefaultSchemaRegistry.Options options = null;
                for (ModuleConfiguration moduleConfiguration : configuration.getModules()) {
                    if (!moduleConfiguration.getClassName().equals("com.hortonworks.registries.schemaregistry.webservice.SchemaRegistryModule")) continue;
                    options = new DefaultSchemaRegistry.Options(moduleConfiguration.getConfig());
                    RegistryApplication.this.haServerNotificationManager.setIsCacheEnabled(options.isCacheEnabled().booleanValue());
                }
                if (options.isCacheEnabled().booleanValue()) {
                    LOG.debug("Enabled server side caching");
                    String serverURL = server.getURI().toString();
                    RegistryApplication.this.haServerNotificationManager.setHomeNodeURL(serverURL);
                    try {
                        RegistryApplication.this.transactionManager.beginTransaction(TransactionIsolation.SERIALIZABLE);
                        HostConfigStorable hostConfigStorable = (HostConfigStorable)RegistryApplication.this.storageManager.get(new HostConfigStorable(serverURL).getStorableKey());
                        if (hostConfigStorable == null) {
                            RegistryApplication.this.storageManager.add((Storable)new HostConfigStorable(RegistryApplication.this.storageManager.nextId("host_config"), serverURL, Long.valueOf(System.currentTimeMillis())));
                        }
                        RegistryApplication.this.haServerNotificationManager.refreshServerInfo(RegistryApplication.this.storageManager.list("host_config"));
                        RegistryApplication.this.transactionManager.commitTransaction();
                    }
                    catch (Exception e) {
                        RegistryApplication.this.transactionManager.rollbackTransaction();
                        throw e;
                    }
                    RegistryApplication.this.haServerNotificationManager.notifyDebut();
                    RegistryApplication.this.refreshHAServerManagedTask = new RefreshHAServerManagedTask(RegistryApplication.this.storageManager, RegistryApplication.this.transactionManager, RegistryApplication.this.haServerNotificationManager);
                    environment.lifecycle().manage((Managed)RegistryApplication.this.refreshHAServerManagedTask);
                    RegistryApplication.this.refreshHAServerManagedTask.start();
                } else {
                    LOG.debug("Disabled server side caching");
                }
            }
        });
    }

    private void registerHA(final HAConfiguration haConfiguration, Environment environment) throws Exception {
        if (haConfiguration != null) {
            environment.lifecycle().addServerLifecycleListener(new ServerLifecycleListener(){

                public void serverStarted(Server server) {
                    String serverUrl = server.getURI().toString();
                    LOG.info("Received callback as server is started with server URL:[{}]", (Object)server);
                    LOG.info("HA configuration: [{}]", (Object)haConfiguration);
                    String className = haConfiguration.getClassName();
                    LeadershipParticipant leadershipParticipant = null;
                    try {
                        leadershipParticipant = (LeadershipParticipant)Class.forName(className).newInstance();
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                    leadershipParticipant.init(haConfiguration.getConfig(), serverUrl);
                    RegistryApplication.this.leadershipParticipantRef.set(leadershipParticipant);
                    LOG.info("Registering for leadership with participant [{}]", (Object)leadershipParticipant);
                    try {
                        RegistryApplication.this.leadershipParticipantRef.get().participateForLeadership();
                    }
                    catch (Exception e) {
                        LOG.error("Error occurred while participating for leadership with serverUrl [{}]", (Object)serverUrl, (Object)e);
                        throw new RuntimeException(e);
                    }
                    LOG.info("Registered for leadership with participant [{}]", (Object)leadershipParticipant);
                }
            });
        } else {
            this.leadershipParticipantRef.set((LeadershipParticipant)LocalLeader.getInstance());
            LOG.info("No HA configuration exists, using [{}]", this.leadershipParticipantRef);
        }
    }

    public String getName() {
        return "Schema Registry";
    }

    public void initialize(Bootstrap<RegistryConfiguration> bootstrap) {
        bootstrap.addBundle((Bundle)new AssetsBundle("/assets", "/ui", "index.html", "static"));
        bootstrap.addBundle((ConfiguredBundle)new SwaggerBundle<RegistryConfiguration>(){

            protected SwaggerBundleConfiguration getSwaggerBundleConfiguration(RegistryConfiguration registryConfiguration) {
                return registryConfiguration.getSwaggerBundleConfiguration();
            }
        });
        super.initialize(bootstrap);
    }

    private void registerResources(Environment environment, RegistryConfiguration registryConfiguration) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.storageManager = this.getStorageManager(registryConfiguration.getStorageProviderConfiguration());
        this.transactionManager = this.storageManager instanceof TransactionManager ? (TransactionManager)this.storageManager : new NOOPTransactionManager();
        FileStorage fileStorage = this.getJarStorage(registryConfiguration.getFileStorageConfiguration());
        List<ModuleConfiguration> modules = registryConfiguration.getModules();
        ArrayList resourcesToRegister = new ArrayList();
        for (ModuleConfiguration moduleConfiguration : modules) {
            LeadershipAware leadershipAware;
            String moduleName = moduleConfiguration.getName();
            String moduleClassName = moduleConfiguration.getClassName();
            LOG.info("Registering module [{}] with class [{}]", (Object)moduleName, (Object)moduleClassName);
            ModuleRegistration moduleRegistration = (ModuleRegistration)Class.forName(moduleClassName).newInstance();
            if (moduleConfiguration.getConfig() == null) {
                moduleConfiguration.setConfig(new HashMap());
            }
            moduleRegistration.init(moduleConfiguration.getConfig(), fileStorage);
            if (moduleRegistration instanceof StorageManagerAware) {
                LOG.info("Module [{}] is StorageManagerAware and setting StorageManager.", (Object)moduleName);
                StorageManagerAware storageManagerAware = (StorageManagerAware)moduleRegistration;
                storageManagerAware.setStorageManager(this.storageManager);
            }
            if (moduleRegistration instanceof TransactionManagerAware) {
                LOG.info("Module [{}] is TransactionManagerAware and setting TransactionManager.", (Object)moduleName);
                TransactionManagerAware transactionManagerAware = (TransactionManagerAware)moduleRegistration;
                transactionManagerAware.setTransactionManager(this.transactionManager);
            }
            if (moduleRegistration instanceof LeadershipAware) {
                LOG.info("Module [{}] is registered for LeadershipParticipant registration.", (Object)moduleName);
                leadershipAware = (LeadershipAware)moduleRegistration;
                leadershipAware.setLeadershipParticipant(this.leadershipParticipantRef);
            }
            if (moduleRegistration instanceof HAServersAware) {
                LOG.info("Module [{}] is registered for HAServersAware registration.");
                leadershipAware = (HAServersAware)moduleRegistration;
                leadershipAware.setHAServerConfigManager(this.haServerNotificationManager);
            }
            resourcesToRegister.addAll(moduleRegistration.getResources());
        }
        LOG.info("Registering resources to Jersey environment: [{}]", resourcesToRegister);
        for (Object resource : resourcesToRegister) {
            environment.jersey().register(resource);
        }
        environment.jersey().register(MultiPartFeature.class);
        environment.jersey().register((Object)new TransactionEventListener(this.transactionManager, TransactionIsolation.READ_COMMITTED));
    }

    private void enableCORS(Environment environment) {
        FilterRegistration.Dynamic cors = environment.servlets().addFilter("CORS", CrossOriginFilter.class);
        cors.setInitParameter("allowedOrigins", "*");
        cors.setInitParameter("allowedHeaders", "X-Requested-With,Authorization,Content-Type,Accept,Origin");
        cors.setInitParameter("allowedMethods", "OPTIONS,GET,PUT,POST,DELETE,HEAD");
        cors.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
    }

    private FileStorage getJarStorage(FileStorageConfiguration fileStorageConfiguration) {
        FileStorage fileStorage = null;
        if (fileStorageConfiguration.getClassName() != null) {
            try {
                fileStorage = (FileStorage)Class.forName(fileStorageConfiguration.getClassName(), true, Thread.currentThread().getContextClassLoader()).newInstance();
                fileStorage.init(fileStorageConfiguration.getProperties());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return fileStorage;
    }

    private StorageManager getStorageManager(StorageProviderConfiguration storageProviderConfiguration) {
        StorageManager storageManager;
        String providerClass = storageProviderConfiguration.getProviderClass();
        try {
            storageManager = (StorageManager)Class.forName(providerClass).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        storageManager.init(storageProviderConfiguration.getProperties());
        return storageManager;
    }

    private void addServletFilters(RegistryConfiguration registryConfiguration, Environment environment) {
        List<ServletFilterConfiguration> servletFilterConfigurations = registryConfiguration.getServletFilters();
        if (servletFilterConfigurations != null && !servletFilterConfigurations.isEmpty()) {
            for (ServletFilterConfiguration servletFilterConfig : servletFilterConfigurations) {
                try {
                    String className = servletFilterConfig.getClassName();
                    Map params = servletFilterConfig.getParams();
                    String typeSuffix = params.get("type") != null ? "-" + ((String)params.get("type")).toString() : "";
                    LOG.info("Registering servlet filter [{}]", (Object)servletFilterConfig);
                    Class<?> filterClass = Class.forName(className);
                    FilterRegistration.Dynamic dynamic = environment.servlets().addFilter(className + typeSuffix, filterClass);
                    if (params != null) {
                        dynamic.setInitParameters(params);
                    }
                    dynamic.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
                }
                catch (Exception e) {
                    LOG.error("Error registering servlet filter {}", (Object)servletFilterConfig);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        RegistryApplication registryApplication = new RegistryApplication();
        registryApplication.run(args);
    }
}

