/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hortonworks.registries.schemaregistry.client.SchemaRegistryClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderCache {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoaderCache.class);
    public static final String CACHE_SIZE_KEY = SchemaRegistryClient.Configuration.CLASSLOADER_CACHE_SIZE.name();
    public static final String CACHE_EXPIRY_INTERVAL_KEY = SchemaRegistryClient.Configuration.CLASSLOADER_CACHE_EXPIRY_INTERVAL_SECS.name();
    private final LoadingCache<String, ClassLoader> loadingCache;
    private final SchemaRegistryClient schemaRegistryClient;
    private final File localJarsDir;

    public ClassLoaderCache(SchemaRegistryClient schemaRegistryClient) {
        this.schemaRegistryClient = schemaRegistryClient;
        CacheLoader<String, ClassLoader> cacheLoader = new CacheLoader<String, ClassLoader>(){

            public ClassLoader load(String fileId) throws Exception {
                File file = ClassLoaderCache.this.getFile(fileId);
                return new URLClassLoader(new URL[]{file.toURI().toURL()});
            }
        };
        SchemaRegistryClient.Configuration configuration = schemaRegistryClient.getConfiguration();
        this.loadingCache = CacheBuilder.newBuilder().maximumSize(((Number)configuration.getValue(CACHE_SIZE_KEY)).longValue()).expireAfterAccess(((Number)configuration.getValue(CACHE_EXPIRY_INTERVAL_KEY)).longValue(), TimeUnit.SECONDS).build((CacheLoader)cacheLoader);
        this.localJarsDir = new File((String)this.schemaRegistryClient.getConfiguration().getValue(SchemaRegistryClient.Configuration.LOCAL_JAR_PATH.name()));
        this.ensureLocalDirsExist();
    }

    private void ensureLocalDirsExist() {
        if (!this.localJarsDir.exists() && !this.localJarsDir.mkdirs()) {
            LOG.error("Could not create given local jar storage dir: [{}]", (Object)this.localJarsDir.getAbsolutePath());
        }
    }

    private File getFile(String fileId) throws IOException {
        this.ensureLocalDirsExist();
        File file = new File(this.localJarsDir, fileId);
        boolean created = file.createNewFile();
        if (created) {
            LOG.debug("File [{}] is created successfully", (Object)file);
        } else {
            LOG.debug("File [{}] already exists", (Object)file);
        }
        try (FileOutputStream fos = new FileOutputStream(file);
             FileInputStream fileInputStream = new FileInputStream(file);){
            LOG.debug("Loading file: [{}]", (Object)file);
            if (fileInputStream.read() != -1) {
                LOG.debug("File [{}] is already written with content and returning the existing file", (Object)file);
                File file2 = file;
                return file2;
            }
            LOG.debug("File [{}] does not have content, downloading and storing started..", (Object)file);
            try (InputStream inputStream = this.schemaRegistryClient.downloadFile(fileId);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)fos);
                LOG.debug("Finished storing file [{}]", (Object)file);
            }
            catch (Exception e) {
                fos.getChannel().truncate(0L);
                throw e;
            }
        }
        return file;
    }

    public ClassLoader getClassLoader(String fileId) {
        try {
            return (ClassLoader)this.loadingCache.get((Object)fileId);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

