/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.client;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import com.hortonworks.registries.auth.KerberosLogin;
import com.hortonworks.registries.auth.Login;
import com.hortonworks.registries.auth.NOOPLogin;
import com.hortonworks.registries.auth.util.JaasConfiguration;
import com.hortonworks.registries.common.SchemaRegistryServiceInfo;
import com.hortonworks.registries.common.SchemaRegistryVersion;
import com.hortonworks.registries.common.catalog.CatalogResponse;
import com.hortonworks.registries.common.util.ClassLoaderAwareInvocationHandler;
import com.hortonworks.registries.schemaregistry.CompatibilityResult;
import com.hortonworks.registries.schemaregistry.ConfigEntry;
import com.hortonworks.registries.schemaregistry.SchemaBranch;
import com.hortonworks.registries.schemaregistry.SchemaFieldQuery;
import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.SchemaMetadata;
import com.hortonworks.registries.schemaregistry.SchemaMetadataInfo;
import com.hortonworks.registries.schemaregistry.SchemaProviderInfo;
import com.hortonworks.registries.schemaregistry.SchemaVersion;
import com.hortonworks.registries.schemaregistry.SchemaVersionInfo;
import com.hortonworks.registries.schemaregistry.SchemaVersionKey;
import com.hortonworks.registries.schemaregistry.SchemaVersionMergeResult;
import com.hortonworks.registries.schemaregistry.SchemaVersionRetriever;
import com.hortonworks.registries.schemaregistry.SerDesInfo;
import com.hortonworks.registries.schemaregistry.SerDesPair;
import com.hortonworks.registries.schemaregistry.cache.SchemaVersionInfoCache;
import com.hortonworks.registries.schemaregistry.client.ClassLoaderCache;
import com.hortonworks.registries.schemaregistry.client.FailoverUrlSelector;
import com.hortonworks.registries.schemaregistry.client.ISchemaRegistryClient;
import com.hortonworks.registries.schemaregistry.client.LoadBalancedFailoverUrlSelector;
import com.hortonworks.registries.schemaregistry.client.SchemaMetadataCache;
import com.hortonworks.registries.schemaregistry.client.UrlSelector;
import com.hortonworks.registries.schemaregistry.errors.IncompatibleSchemaException;
import com.hortonworks.registries.schemaregistry.errors.InvalidSchemaBranchDeletionException;
import com.hortonworks.registries.schemaregistry.errors.InvalidSchemaException;
import com.hortonworks.registries.schemaregistry.errors.SchemaBranchAlreadyExistsException;
import com.hortonworks.registries.schemaregistry.errors.SchemaBranchNotFoundException;
import com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException;
import com.hortonworks.registries.schemaregistry.exceptions.RegistryRetryableException;
import com.hortonworks.registries.schemaregistry.retry.RetryExecutor;
import com.hortonworks.registries.schemaregistry.retry.policy.BackoffPolicy;
import com.hortonworks.registries.schemaregistry.retry.policy.NOOPBackoffPolicy;
import com.hortonworks.registries.schemaregistry.serde.SerDesException;
import com.hortonworks.registries.schemaregistry.serde.SnapshotDeserializer;
import com.hortonworks.registries.schemaregistry.serde.SnapshotSerializer;
import com.hortonworks.registries.schemaregistry.serde.pull.PullDeserializer;
import com.hortonworks.registries.schemaregistry.serde.pull.PullSerializer;
import com.hortonworks.registries.schemaregistry.serde.push.PushDeserializer;
import com.hortonworks.registries.schemaregistry.state.SchemaLifecycleException;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStateMachineInfo;
import com.hortonworks.registries.shaded.javax.ws.rs.BadRequestException;
import com.hortonworks.registries.shaded.javax.ws.rs.NotFoundException;
import com.hortonworks.registries.shaded.javax.ws.rs.ProcessingException;
import com.hortonworks.registries.shaded.javax.ws.rs.client.Client;
import com.hortonworks.registries.shaded.javax.ws.rs.client.ClientBuilder;
import com.hortonworks.registries.shaded.javax.ws.rs.client.Entity;
import com.hortonworks.registries.shaded.javax.ws.rs.client.WebTarget;
import com.hortonworks.registries.shaded.javax.ws.rs.core.MediaType;
import com.hortonworks.registries.shaded.javax.ws.rs.core.Response;
import com.hortonworks.registries.shaded.org.glassfish.jersey.SslConfigurator;
import com.hortonworks.registries.shaded.org.glassfish.jersey.client.ClientConfig;
import com.hortonworks.registries.shaded.org.glassfish.jersey.client.JerseyClientBuilder;
import com.hortonworks.registries.shaded.org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import com.hortonworks.registries.shaded.org.glassfish.jersey.media.multipart.BodyPart;
import com.hortonworks.registries.shaded.org.glassfish.jersey.media.multipart.FormDataMultiPart;
import com.hortonworks.registries.shaded.org.glassfish.jersey.media.multipart.MultiPart;
import com.hortonworks.registries.shaded.org.glassfish.jersey.media.multipart.MultiPartFeature;
import com.hortonworks.registries.shaded.org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class SchemaRegistryClient
implements ISchemaRegistryClient {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaRegistryClient.class);
    private static final String SCHEMA_REGISTRY_PATH = "/schemaregistry";
    private static final String SCHEMAS_PATH = "/schemaregistry/schemas/";
    private static final String SCHEMA_PROVIDERS_PATH = "/schemaregistry/schemaproviders/";
    private static final String SCHEMAS_BY_ID_PATH = "/schemaregistry/schemasById/";
    private static final String SCHEMA_VERSIONS_PATH = "/schemaregistry/schemas/versions/";
    private static final String FILES_PATH = "/schemaregistry/files/";
    private static final String SERIALIZERS_PATH = "/schemaregistry/serdes/";
    private static final String REGISTY_CLIENT_JAAS_SECTION = "RegistryClient";
    private static final Set<Class<?>> DESERIALIZER_INTERFACE_CLASSES = Sets.newHashSet((Object[])new Class[]{SnapshotDeserializer.class, PullDeserializer.class, PushDeserializer.class});
    private static final Set<Class<?>> SERIALIZER_INTERFACE_CLASSES = Sets.newHashSet((Object[])new Class[]{SnapshotSerializer.class, PullSerializer.class});
    private static final String SEARCH_FIELDS = "/schemaregistry/search/schemas/fields";
    private static final long KERBEROS_SYNCHRONIZATION_TIMEOUT_MS = 180000L;
    private static final String SSL_KEY_PASSWORD = "keyPassword";
    private static final String SSL_KEY_STORE_PATH = "keyStorePath";
    private static final SchemaRegistryVersion CLIENT_VERSION = SchemaRegistryServiceInfo.get().version();
    private Login login;
    private final Client client;
    private final UrlSelector urlSelector;
    private final Map<String, SchemaRegistryTargets> urlWithTargets;
    private final Configuration configuration;
    private final ClassLoaderCache classLoaderCache;
    private final SchemaVersionInfoCache schemaVersionInfoCache;
    private final SchemaMetadataCache schemaMetadataCache;
    private final Cache<SchemaDigestEntry, SchemaIdVersion> schemaTextCache;
    private static final String SSL_CONFIGURATION_KEY = "schema.registry.client.ssl";
    private static final String SSL_PROTOCOL_KEY = "schema.registry.client.ssl.protocol";
    private static final String HOSTNAME_VERIFIER_CLASS_KEY = "hostnameVerifierClass";
    private static final String CLIENT_RETRY_POLICY_KEY = "schema.registry.client.retry.policy";
    private static final String RETRY_POLICY_CLASS_NAME_KEY = "className";
    private static final String RETRY_POLICY_CONFIG_KEY = "config";
    private static final String DEFAULT_RETRY_STRATEGY_CLASS = NOOPBackoffPolicy.class.getCanonicalName();
    private final RetryExecutor retryExecutor;

    public SchemaRegistryClient(File confFile) throws IOException {
        this(SchemaRegistryClient.buildConfFromFile(confFile));
    }

    private static Map<String, ?> buildConfFromFile(File confFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(confFile);){
            Map map = (Map)new Yaml().load(IOUtils.toString((InputStream)fis, (String)"UTF-8"));
            return map;
        }
    }

    public SchemaRegistryClient(Map<String, ?> conf) {
        this.configuration = new Configuration(conf);
        this.initializeSecurityContext();
        ClientConfig config = this.createClientConfig(conf);
        ClientBuilder clientBuilder = (ClientBuilder)JerseyClientBuilder.newBuilder().withConfig((com.hortonworks.registries.shaded.javax.ws.rs.core.Configuration)config).property("jersey.config.client.followRedirects", (Object)Boolean.TRUE);
        if (conf.containsKey(SSL_CONFIGURATION_KEY) || conf.containsKey(SSL_PROTOCOL_KEY)) {
            Map<String, String> sslConfigurations = (Map<String, String>)conf.get(SSL_CONFIGURATION_KEY);
            if (sslConfigurations == null) {
                sslConfigurations = conf.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("schema.registry.client.ssl.")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(SSL_CONFIGURATION_KEY.length() + 1), entry -> (String)entry.getValue()));
            }
            clientBuilder.sslContext(this.createSSLContext(sslConfigurations));
            if (sslConfigurations.containsKey(HOSTNAME_VERIFIER_CLASS_KEY)) {
                HostnameVerifier hostNameVerifier = null;
                String hostNameVerifierClassName = sslConfigurations.get(HOSTNAME_VERIFIER_CLASS_KEY);
                try {
                    hostNameVerifier = (HostnameVerifier)Class.forName(hostNameVerifierClassName).newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to instantiate hostNameVerifierClass : " + hostNameVerifierClassName, e);
                }
                clientBuilder.hostnameVerifier(hostNameVerifier);
            }
        }
        this.client = clientBuilder.build();
        this.client.register(MultiPartFeature.class);
        String userName = (String)this.configuration.getValue(Configuration.AUTH_USERNAME.name());
        String password = (String)this.configuration.getValue(Configuration.AUTH_PASSWORD.name());
        if (StringUtils.isNotEmpty((CharSequence)userName) && StringUtils.isNotEmpty((CharSequence)password)) {
            HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic((String)userName, (String)password);
            this.client.register((Object)feature);
        }
        this.urlSelector = this.createUrlSelector();
        this.urlWithTargets = new ConcurrentHashMap<String, SchemaRegistryTargets>();
        String retryPolicyClass = DEFAULT_RETRY_STRATEGY_CLASS;
        Map<String, Object> retryPolicyProps = new HashMap<String, Object>();
        if (conf.containsKey(CLIENT_RETRY_POLICY_KEY)) {
            Map retryStrategyConfigurations = (Map)conf.get(CLIENT_RETRY_POLICY_KEY);
            retryPolicyClass = retryStrategyConfigurations.getOrDefault(RETRY_POLICY_CLASS_NAME_KEY, DEFAULT_RETRY_STRATEGY_CLASS);
            if (retryStrategyConfigurations.containsKey(RETRY_POLICY_CONFIG_KEY)) {
                retryPolicyProps = (Map)retryStrategyConfigurations.get(RETRY_POLICY_CONFIG_KEY);
            }
        }
        BackoffPolicy backoffPolicy = this.createRetryPolicy(retryPolicyClass, retryPolicyProps);
        this.retryExecutor = new RetryExecutor.Builder().backoffPolicy(backoffPolicy).retryOnException(RegistryRetryableException.class).build();
        this.classLoaderCache = new ClassLoaderCache(this);
        this.schemaVersionInfoCache = new SchemaVersionInfoCache(new SchemaVersionRetriever(){

            public SchemaVersionInfo retrieveSchemaVersion(SchemaVersionKey key) throws SchemaNotFoundException {
                return SchemaRegistryClient.this.doGetSchemaVersionInfo(key);
            }

            public SchemaVersionInfo retrieveSchemaVersion(SchemaIdVersion key) throws SchemaNotFoundException {
                return SchemaRegistryClient.this.doGetSchemaVersionInfo(key);
            }
        }, ((Number)this.configuration.getValue(Configuration.SCHEMA_VERSION_CACHE_SIZE.name())).intValue(), ((Number)this.configuration.getValue(Configuration.SCHEMA_VERSION_CACHE_EXPIRY_INTERVAL_SECS.name())).longValue() * 1000L);
        SchemaMetadataCache.SchemaMetadataFetcher schemaMetadataFetcher = this.createSchemaMetadataFetcher();
        this.schemaMetadataCache = new SchemaMetadataCache(((Number)this.configuration.getValue(Configuration.SCHEMA_METADATA_CACHE_SIZE.name())).longValue(), ((Number)this.configuration.getValue(Configuration.SCHEMA_METADATA_CACHE_EXPIRY_INTERVAL_SECS.name())).longValue(), schemaMetadataFetcher);
        this.schemaTextCache = CacheBuilder.newBuilder().maximumSize(((Number)this.configuration.getValue(Configuration.SCHEMA_TEXT_CACHE_SIZE.name())).longValue()).expireAfterAccess(((Number)this.configuration.getValue(Configuration.SCHEMA_TEXT_CACHE_EXPIRY_INTERVAL_SECS.name())).longValue(), TimeUnit.SECONDS).build();
    }

    private BackoffPolicy createRetryPolicy(String retryPolicyClass, Map<String, Object> retryPolicyProps) {
        BackoffPolicy backoffPolicy;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(retryPolicyClass, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to initiate the retry policy class : " + retryPolicyClass, e);
        }
        try {
            backoffPolicy = (BackoffPolicy)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to create an instance of retry policy class : " + retryPolicyClass, e);
        }
        backoffPolicy.init(retryPolicyProps);
        return backoffPolicy;
    }

    protected void initializeSecurityContext() {
        String jaasConfigFile;
        String saslJaasConfig = (String)this.configuration.getValue(Configuration.SASL_JAAS_CONFIG.name());
        if (saslJaasConfig != null) {
            KerberosLogin kerberosLogin = new KerberosLogin(180000L);
            try {
                kerberosLogin.configure(new HashMap(), REGISTY_CLIENT_JAAS_SECTION, (javax.security.auth.login.Configuration)new JaasConfiguration(REGISTY_CLIENT_JAAS_SECTION, saslJaasConfig));
                kerberosLogin.login();
                this.login = kerberosLogin;
                return;
            }
            catch (LoginException e) {
                LOG.error("Failed to initialize the dynamic JAAS config: " + saslJaasConfig + ". Attempting static JAAS config.");
            }
            catch (Exception e) {
                LOG.error("Failed to parse the dynamic JAAS config. Attempting static JAAS config.", (Throwable)e);
            }
        }
        if ((jaasConfigFile = System.getProperty("java.security.auth.login.config")) != null && !jaasConfigFile.trim().isEmpty()) {
            KerberosLogin kerberosLogin = new KerberosLogin(180000L);
            kerberosLogin.configure(new HashMap(), REGISTY_CLIENT_JAAS_SECTION);
            try {
                kerberosLogin.login();
                this.login = kerberosLogin;
            }
            catch (LoginException e) {
                LOG.error("Could not login using jaas config  section RegistryClient");
                this.login = new NOOPLogin();
            }
        } else {
            LOG.warn("System property for jaas config file is not defined. Its okay if schema registry is not running in secured mode");
            this.login = new NOOPLogin();
        }
    }

    protected SSLContext createSSLContext(Map<String, String> sslConfigurations) {
        SslConfigurator sslConfigurator = SslConfigurator.newInstance();
        if (sslConfigurations.containsKey(SSL_KEY_STORE_PATH)) {
            sslConfigurator.keyStoreType(sslConfigurations.get("keyStoreType")).keyStoreFile(sslConfigurations.get(SSL_KEY_STORE_PATH)).keyStorePassword(sslConfigurations.get("keyStorePassword")).keyStoreProvider(sslConfigurations.get("keyStoreProvider")).keyManagerFactoryAlgorithm(sslConfigurations.get("keyManagerFactoryAlgorithm")).keyManagerFactoryProvider(sslConfigurations.get("keyManagerFactoryProvider"));
            if (sslConfigurations.containsKey(SSL_KEY_PASSWORD)) {
                sslConfigurator.keyPassword(sslConfigurations.get(SSL_KEY_PASSWORD));
            }
        }
        sslConfigurator.trustStoreType(sslConfigurations.get("trustStoreType")).trustStoreFile(sslConfigurations.get("trustStorePath")).trustStorePassword(sslConfigurations.get("trustStorePassword")).trustStoreProvider(sslConfigurations.get("trustStoreProvider")).trustManagerFactoryAlgorithm(sslConfigurations.get("trustManagerFactoryAlgorithm")).trustManagerFactoryProvider(sslConfigurations.get("trustManagerFactoryProvider"));
        sslConfigurator.securityProtocol(sslConfigurations.get("protocol"));
        return sslConfigurator.createSSLContext();
    }

    private SchemaRegistryTargets currentSchemaRegistryTargets() {
        String url = this.urlSelector.select();
        this.urlWithTargets.computeIfAbsent(url, s -> new SchemaRegistryTargets(this.client.target(s)));
        return this.urlWithTargets.get(url);
    }

    private UrlSelector createUrlSelector() {
        UrlSelector urlSelector = null;
        String rootCatalogURL = (String)this.configuration.getValue(Configuration.SCHEMA_REGISTRY_URL.name());
        String urlSelectorClass = (String)this.configuration.getValue(Configuration.URL_SELECTOR_CLASS.name());
        if (urlSelectorClass == null) {
            urlSelector = new LoadBalancedFailoverUrlSelector(rootCatalogURL);
        } else {
            try {
                urlSelector = (UrlSelector)Class.forName(urlSelectorClass).getConstructor(String.class).newInstance(rootCatalogURL);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        urlSelector.init(this.configuration.getConfig());
        return urlSelector;
    }

    private SchemaMetadataCache.SchemaMetadataFetcher createSchemaMetadataFetcher() {
        return new SchemaMetadataCache.SchemaMetadataFetcher(){

            @Override
            public SchemaMetadataInfo fetch(String name) throws SchemaNotFoundException {
                try {
                    return (SchemaMetadataInfo)SchemaRegistryClient.this.runRetryableBlock(targets -> (SchemaMetadataInfo)SchemaRegistryClient.this.getEntity(targets.schemasTarget.path(name), SchemaMetadataInfo.class));
                }
                catch (NotFoundException e) {
                    throw new SchemaNotFoundException((Throwable)e);
                }
            }

            @Override
            public SchemaMetadataInfo fetch(Long id) throws SchemaNotFoundException {
                try {
                    return (SchemaMetadataInfo)SchemaRegistryClient.this.runRetryableBlock(targets -> (SchemaMetadataInfo)SchemaRegistryClient.this.getEntity(targets.schemasByIdTarget.path(id.toString()), SchemaMetadataInfo.class));
                }
                catch (NotFoundException e) {
                    throw new SchemaNotFoundException((Throwable)e);
                }
            }
        };
    }

    protected ClientConfig createClientConfig(Map<String, ?> conf) {
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.connectTimeout", (Object)30000);
        config.property("jersey.config.client.readTimeout", (Object)30000);
        config.property("jersey.config.client.followRedirects", (Object)true);
        for (Map.Entry<String, ?> entry : conf.entrySet()) {
            config.property(entry.getKey(), entry.getValue());
        }
        return config;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Collection<SchemaProviderInfo> getSupportedSchemaProviders() {
        return this.runRetryableBlock(targets -> this.getEntities(targets.schemaProvidersTarget, SchemaProviderInfo.class));
    }

    public Long registerSchemaMetadata(SchemaMetadata schemaMetadata) {
        return this.addSchemaMetadata(schemaMetadata);
    }

    public Long addSchemaMetadata(SchemaMetadata schemaMetadata) {
        SchemaMetadataInfo schemaMetadataInfo = this.schemaMetadataCache.getIfPresent(SchemaMetadataCache.Key.of(schemaMetadata.getName()));
        if (schemaMetadataInfo == null) {
            return this.runRetryableBlock(targets -> this.doRegisterSchemaMetadata(schemaMetadata, targets.schemasTarget));
        }
        return schemaMetadataInfo.getId();
    }

    public SchemaMetadataInfo updateSchemaMetadata(String schemaName, SchemaMetadata schemaMetadata) {
        SchemaMetadataInfo schemaMetadataInfo = this.runRetryableBlock(targets -> this.postEntity(targets.schemasTarget.path(schemaName), schemaMetadata, SchemaMetadataInfo.class));
        if (schemaMetadataInfo != null) {
            this.schemaMetadataCache.put(SchemaMetadataCache.Key.of(schemaName), schemaMetadataInfo);
        }
        return schemaMetadataInfo;
    }

    private Long doRegisterSchemaMetadata(SchemaMetadata schemaMetadata, WebTarget schemasTarget) {
        try {
            return this.postEntity(schemasTarget, schemaMetadata, Long.class);
        }
        catch (BadRequestException ex) {
            Response response = ex.getResponse();
            CatalogResponse catalogResponse = SchemaRegistryClient.readCatalogResponse((String)response.readEntity(String.class));
            if (catalogResponse.getResponseCode() == CatalogResponse.ResponseMessage.ENTITY_CONFLICT.getCode()) {
                return this.getSchemaMetadataInfo(schemaMetadata.getName()).getId();
            }
            throw ex;
        }
    }

    public SchemaMetadataInfo getSchemaMetadataInfo(String schemaName) {
        return this.schemaMetadataCache.get(SchemaMetadataCache.Key.of(schemaName));
    }

    public SchemaMetadataInfo getSchemaMetadataInfo(Long schemaMetadataId) {
        return this.schemaMetadataCache.get(SchemaMetadataCache.Key.of(schemaMetadataId));
    }

    public void deleteSchema(String schemaName) throws SchemaNotFoundException {
        Response response;
        int status;
        Collection<SchemaVersionInfo> schemaVersionInfos = this.getAllVersions(schemaName);
        this.schemaMetadataCache.invalidateSchemaMetadata(SchemaMetadataCache.Key.of(schemaName));
        if (schemaVersionInfos != null) {
            for (SchemaVersionInfo schemaVersionInfo : schemaVersionInfos) {
                SchemaIdVersion schemaIdVersion = new SchemaIdVersion(schemaVersionInfo.getId());
                this.schemaVersionInfoCache.invalidateSchema(SchemaVersionInfoCache.Key.of((SchemaIdVersion)schemaIdVersion));
            }
        }
        if ((status = (response = this.runRetryableBlock(targets -> {
            final WebTarget target = targets.schemasTarget.path(String.format("%s", schemaName));
            try {
                return (Response)this.login.doAction((PrivilegedAction)new PrivilegedAction<Response>(){

                    @Override
                    public Response run() {
                        return (Response)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Response.class);
                    }
                });
            }
            catch (ProcessingException | LoginException e) {
                throw new RegistryRetryableException(e);
            }
        })).getStatus()) == Response.Status.NOT_FOUND.getStatusCode()) {
            throw new SchemaNotFoundException((String)response.readEntity(String.class));
        }
        if (status == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            throw new RuntimeException((String)response.readEntity(String.class));
        }
    }

    public SchemaIdVersion addSchemaVersion(SchemaMetadata schemaMetadata, SchemaVersion schemaVersion, boolean disableCanonicalCheck) throws InvalidSchemaException, IncompatibleSchemaException, SchemaNotFoundException, SchemaBranchNotFoundException {
        return this.addSchemaVersion("MASTER", schemaMetadata, schemaVersion, disableCanonicalCheck);
    }

    public SchemaIdVersion addSchemaVersion(String schemaBranchName, SchemaMetadata schemaMetadata, SchemaVersion schemaVersion, boolean disableCanonicalCheck) throws InvalidSchemaException, IncompatibleSchemaException, SchemaNotFoundException, SchemaBranchNotFoundException {
        SchemaDigestEntry schemaDigestEntry = this.buildSchemaTextEntry(schemaVersion, schemaMetadata.getName());
        SchemaIdVersion schemaIdVersion = (SchemaIdVersion)this.schemaTextCache.getIfPresent((Object)schemaDigestEntry);
        if (schemaIdVersion == null) {
            Long metadataId = this.registerSchemaMetadata(schemaMetadata);
            if (metadataId == null) {
                LOG.error("Schema Metadata [{}] is not registered successfully", (Object)schemaMetadata);
                throw new RuntimeException("Given SchemaMetadata could not be registered: " + schemaMetadata);
            }
            schemaIdVersion = this.addSchemaVersion(schemaBranchName, schemaMetadata.getName(), schemaVersion, disableCanonicalCheck);
        }
        return schemaIdVersion;
    }

    public SchemaIdVersion uploadSchemaVersion(String schemaName, String description, InputStream schemaVersionTextFile) throws InvalidSchemaException, IncompatibleSchemaException, SchemaNotFoundException, SchemaBranchNotFoundException {
        return this.uploadSchemaVersion("MASTER", schemaName, description, schemaVersionTextFile);
    }

    public SchemaIdVersion uploadSchemaVersion(String schemaBranchName, String schemaName, String description, InputStream schemaVersionInputStream) throws InvalidSchemaException, IncompatibleSchemaException, SchemaNotFoundException, SchemaBranchNotFoundException {
        SchemaMetadataInfo schemaMetadataInfo = this.getSchemaMetadataInfo(schemaName);
        if (schemaMetadataInfo == null) {
            throw new SchemaNotFoundException("Schema with name " + schemaName + " not found");
        }
        StreamDataBodyPart streamDataBodyPart = new StreamDataBodyPart("file", schemaVersionInputStream);
        Response response = this.runRetryableBlock(targets -> {
            final WebTarget target = targets.schemasTarget.path(schemaName).path("/versions/upload").queryParam("branch", new Object[]{schemaBranchName});
            MultiPart multipartEntity = new FormDataMultiPart().field("description", (Object)description, MediaType.APPLICATION_JSON_TYPE).bodyPart((BodyPart)streamDataBodyPart);
            final Entity multiPartEntity = Entity.entity((Object)multipartEntity, (String)"multipart/form-data");
            try {
                return (Response)this.login.doAction((PrivilegedAction)new PrivilegedAction<Response>(){

                    @Override
                    public Response run() {
                        return (Response)target.request().post(multiPartEntity, Response.class);
                    }
                });
            }
            catch (ProcessingException | LoginException e) {
                throw new RegistryRetryableException(e);
            }
        });
        return this.handleSchemaIdVersionResponse(schemaMetadataInfo, response);
    }

    private SchemaDigestEntry buildSchemaTextEntry(SchemaVersion schemaVersion, String name) {
        byte[] digest;
        try {
            digest = MessageDigest.getInstance("MD5").digest(schemaVersion.getSchemaText().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return new SchemaDigestEntry(name, digest);
    }

    public SchemaIdVersion addSchemaVersion(String schemaName, SchemaVersion schemaVersion, boolean disableCanonicalCheck) throws InvalidSchemaException, IncompatibleSchemaException, SchemaNotFoundException, SchemaBranchNotFoundException {
        return this.addSchemaVersion("MASTER", schemaName, schemaVersion, disableCanonicalCheck);
    }

    public SchemaIdVersion addSchemaVersion(String schemaBranchName, String schemaName, SchemaVersion schemaVersion, boolean disableCanonicalCheck) throws InvalidSchemaException, IncompatibleSchemaException, SchemaNotFoundException, SchemaBranchNotFoundException {
        try {
            return (SchemaIdVersion)this.schemaTextCache.get((Object)this.buildSchemaTextEntry(schemaVersion, schemaName), () -> this.doAddSchemaVersion(schemaBranchName, schemaName, schemaVersion, disableCanonicalCheck));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            LOG.error("Encountered error while adding new version [{}] of schema [{}] and error [{}]", new Object[]{schemaVersion, schemaName, e});
            if (cause != null) {
                if (cause instanceof InvalidSchemaException) {
                    throw (InvalidSchemaException)cause;
                }
                if (cause instanceof IncompatibleSchemaException) {
                    throw (IncompatibleSchemaException)cause;
                }
                if (cause instanceof SchemaNotFoundException) {
                    throw (SchemaNotFoundException)cause;
                }
                throw new RuntimeException(cause.getMessage(), cause);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void deleteSchemaVersion(SchemaVersionKey schemaVersionKey) throws SchemaNotFoundException, SchemaLifecycleException {
        this.schemaVersionInfoCache.invalidateSchema(new SchemaVersionInfoCache.Key(schemaVersionKey));
        Response response = this.runRetryableBlock(targets -> {
            final WebTarget target = targets.schemasTarget.path(String.format("%s/versions/%s", schemaVersionKey.getSchemaName(), schemaVersionKey.getVersion()));
            try {
                return (Response)this.login.doAction((PrivilegedAction)new PrivilegedAction<Response>(){

                    @Override
                    public Response run() {
                        return (Response)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Response.class);
                    }
                });
            }
            catch (ProcessingException | LoginException e) {
                throw new RegistryRetryableException(e);
            }
        });
        this.handleDeleteSchemaResponse(response);
    }

    private void handleDeleteSchemaResponse(Response response) throws SchemaNotFoundException, SchemaLifecycleException {
        String msg = (String)response.readEntity(String.class);
        switch (Response.Status.fromStatusCode((int)response.getStatus())) {
            case NOT_FOUND: {
                throw new SchemaNotFoundException(msg);
            }
            case BAD_REQUEST: {
                throw new SchemaLifecycleException(msg);
            }
            case INTERNAL_SERVER_ERROR: {
                throw new RuntimeException(msg);
            }
        }
    }

    private SchemaIdVersion doAddSchemaVersion(String schemaBranchName, String schemaName, final SchemaVersion schemaVersion, boolean disableCanonicalCheck) throws IncompatibleSchemaException, InvalidSchemaException, SchemaNotFoundException {
        SchemaMetadataInfo schemaMetadataInfo = this.getSchemaMetadataInfo(schemaName);
        if (schemaMetadataInfo == null) {
            throw new SchemaNotFoundException("Schema with name " + schemaName + " not found");
        }
        Response response = this.runRetryableBlock(targets -> {
            try {
                final WebTarget target = targets.schemasTarget.path(schemaName).path("/versions").queryParam("branch", new Object[]{schemaBranchName}).queryParam("disableCanonicalCheck", new Object[]{disableCanonicalCheck});
                return (Response)this.login.doAction((PrivilegedAction)new PrivilegedAction<Response>(){

                    @Override
                    public Response run() {
                        return (Response)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)schemaVersion), Response.class);
                    }
                });
            }
            catch (ProcessingException | LoginException e) {
                throw new RegistryRetryableException(e);
            }
        });
        return this.handleSchemaIdVersionResponse(schemaMetadataInfo, response);
    }

    private SchemaIdVersion handleSchemaIdVersionResponse(SchemaMetadataInfo schemaMetadataInfo, Response response) throws IncompatibleSchemaException, InvalidSchemaException {
        int status = response.getStatus();
        String msg = (String)response.readEntity(String.class);
        if (status == Response.Status.BAD_REQUEST.getStatusCode() || status == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            CatalogResponse catalogResponse = SchemaRegistryClient.readCatalogResponse(msg);
            if (CatalogResponse.ResponseMessage.INCOMPATIBLE_SCHEMA.getCode() == catalogResponse.getResponseCode()) {
                throw new IncompatibleSchemaException(catalogResponse.getResponseMessage());
            }
            if (CatalogResponse.ResponseMessage.INVALID_SCHEMA.getCode() == catalogResponse.getResponseCode()) {
                throw new InvalidSchemaException(catalogResponse.getResponseMessage());
            }
            throw new RuntimeException(catalogResponse.getResponseMessage());
        }
        Integer version = this.readEntity(msg, Integer.class);
        SchemaVersionInfo schemaVersionInfo = this.doGetSchemaVersionInfo(new SchemaVersionKey(schemaMetadataInfo.getSchemaMetadata().getName(), version));
        return new SchemaIdVersion(schemaMetadataInfo.getId(), version, schemaVersionInfo.getId());
    }

    public static CatalogResponse readCatalogResponse(String msg) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode node = objectMapper.readTree(msg);
            return (CatalogResponse)objectMapper.treeToValue((TreeNode)node, CatalogResponse.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SchemaVersionInfo getSchemaVersionInfo(SchemaIdVersion schemaIdVersion) throws SchemaNotFoundException {
        try {
            return this.schemaVersionInfoCache.getSchema(SchemaVersionInfoCache.Key.of((SchemaIdVersion)schemaIdVersion));
        }
        catch (SchemaNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public SchemaVersionInfo getLatestSchemaVersionInfo(String schemaName) throws SchemaNotFoundException {
        return this.getLatestSchemaVersionInfo("MASTER", schemaName);
    }

    public SchemaVersionInfo getSchemaVersionInfo(SchemaVersionKey schemaVersionKey) throws SchemaNotFoundException {
        try {
            return this.schemaVersionInfoCache.getSchema(SchemaVersionInfoCache.Key.of((SchemaVersionKey)schemaVersionKey));
        }
        catch (SchemaNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private SchemaVersionInfo doGetSchemaVersionInfo(SchemaIdVersion schemaIdVersion) throws SchemaNotFoundException {
        if (schemaIdVersion.getSchemaVersionId() != null) {
            LOG.info("Getting schema version from target registry for [{}]", (Object)schemaIdVersion.getSchemaVersionId());
            return this.runRetryableBlock(targets -> this.getEntity(targets.schemaVersionsByIdTarget.path(schemaIdVersion.getSchemaVersionId().toString()), SchemaVersionInfo.class));
        }
        if (schemaIdVersion.getSchemaMetadataId() != null) {
            SchemaMetadataInfo schemaMetadataInfo = this.getSchemaMetadataInfo(schemaIdVersion.getSchemaMetadataId());
            SchemaVersionKey schemaVersionKey = new SchemaVersionKey(schemaMetadataInfo.getSchemaMetadata().getName(), schemaIdVersion.getVersion());
            LOG.info("Getting schema version from target registry for key [{}]", (Object)schemaVersionKey);
            return this.doGetSchemaVersionInfo(schemaVersionKey);
        }
        throw new IllegalArgumentException("Given argument not valid: " + schemaIdVersion);
    }

    private SchemaVersionInfo doGetSchemaVersionInfo(SchemaVersionKey schemaVersionKey) {
        LOG.info("Getting schema version from target registry for [{}]", (Object)schemaVersionKey);
        String schemaName = schemaVersionKey.getSchemaName();
        return this.runRetryableBlock(targets -> {
            WebTarget webTarget = targets.schemasTarget.path(String.format("%s/versions/%d", schemaName, schemaVersionKey.getVersion()));
            return this.getEntity(webTarget, SchemaVersionInfo.class);
        });
    }

    public SchemaVersionInfo getLatestSchemaVersionInfo(String schemaBranchName, String schemaName) throws SchemaNotFoundException {
        return this.runRetryableBlock(targets -> {
            WebTarget webTarget = targets.schemasTarget.path(SchemaRegistryClient.encode(schemaName) + "/versions/latest").queryParam("branch", new Object[]{schemaBranchName});
            return this.getEntity(webTarget, SchemaVersionInfo.class);
        });
    }

    public Collection<SchemaVersionInfo> getAllVersions(String schemaName) throws SchemaNotFoundException {
        return this.getAllVersions("MASTER", schemaName);
    }

    private static String encode(String schemaName) {
        try {
            return URLEncoder.encode(schemaName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void enableSchemaVersion(Long schemaVersionId) throws SchemaNotFoundException, SchemaLifecycleException, IncompatibleSchemaException {
        try {
            this.transitionSchemaVersionState(schemaVersionId, "enable", null);
        }
        catch (SchemaLifecycleException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof IncompatibleSchemaException) {
                throw (IncompatibleSchemaException)cause;
            }
            throw e;
        }
    }

    public void disableSchemaVersion(Long schemaVersionId) throws SchemaNotFoundException, SchemaLifecycleException {
        this.transitionSchemaVersionState(schemaVersionId, "disable", null);
    }

    public void deleteSchemaVersion(Long schemaVersionId) throws SchemaNotFoundException, SchemaLifecycleException {
        this.transitionSchemaVersionState(schemaVersionId, "delete", null);
    }

    public void archiveSchemaVersion(Long schemaVersionId) throws SchemaNotFoundException, SchemaLifecycleException {
        this.transitionSchemaVersionState(schemaVersionId, "archive", null);
    }

    public void startSchemaVersionReview(Long schemaVersionId) throws SchemaNotFoundException, SchemaLifecycleException {
        this.transitionSchemaVersionState(schemaVersionId, "startReview", null);
    }

    public SchemaVersionMergeResult mergeSchemaVersion(Long schemaVersionId, boolean disableCanonicalCheck) throws SchemaNotFoundException, IncompatibleSchemaException {
        Response response = this.runRetryableBlock(targets -> {
            try {
                final WebTarget target = targets.schemasTarget.path(schemaVersionId + "/merge").queryParam("disableCanonicalCheck", new Object[]{disableCanonicalCheck});
                return (Response)this.login.doAction((PrivilegedAction)new PrivilegedAction<Response>(){

                    @Override
                    public Response run() {
                        return target.request().post(null);
                    }
                });
            }
            catch (ProcessingException | LoginException e) {
                throw new RegistryRetryableException(e);
            }
        });
        int status = response.getStatus();
        if (status == Response.Status.OK.getStatusCode()) {
            String msg = (String)response.readEntity(String.class);
            return this.readEntity(msg, SchemaVersionMergeResult.class);
        }
        if (status == Response.Status.NOT_FOUND.getStatusCode()) {
            throw new SchemaNotFoundException((String)response.readEntity(String.class));
        }
        if (status == Response.Status.BAD_REQUEST.getStatusCode()) {
            throw new IncompatibleSchemaException((String)response.readEntity(String.class));
        }
        throw new RuntimeException((String)response.readEntity(String.class));
    }

    public void transitionState(Long schemaVersionId, Byte targetStateId, byte[] transitionDetails) throws SchemaNotFoundException, SchemaLifecycleException {
        boolean result = this.transitionSchemaVersionState(schemaVersionId, targetStateId.toString(), transitionDetails);
    }

    public SchemaVersionLifecycleStateMachineInfo getSchemaVersionLifecycleStateMachineInfo() {
        return this.runRetryableBlock(targets -> this.getEntity(targets.schemaVersionsStatesMachineTarget, SchemaVersionLifecycleStateMachineInfo.class));
    }

    public SchemaBranch createSchemaBranch(Long schemaVersionId, final SchemaBranch schemaBranch) throws SchemaBranchAlreadyExistsException, SchemaNotFoundException {
        Response response = this.runRetryableBlock(targets -> {
            final WebTarget target = targets.schemasTarget.path("versionsById/" + schemaVersionId + "/branch");
            try {
                return (Response)this.login.doAction((PrivilegedAction)new PrivilegedAction<Response>(){

                    @Override
                    public Response run() {
                        return (Response)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)schemaBranch), Response.class);
                    }
                });
            }
            catch (ProcessingException | LoginException e) {
                throw new RegistryRetryableException(e);
            }
        });
        int status = response.getStatus();
        if (status == Response.Status.OK.getStatusCode()) {
            String msg = (String)response.readEntity(String.class);
            SchemaBranch returnedSchemaBranch = this.readEntity(msg, SchemaBranch.class);
            return returnedSchemaBranch;
        }
        if (status == Response.Status.BAD_REQUEST.getStatusCode()) {
            throw new SchemaNotFoundException((String)response.readEntity(String.class));
        }
        if (status == Response.Status.CONFLICT.getStatusCode()) {
            throw new SchemaBranchAlreadyExistsException((String)response.readEntity(String.class));
        }
        throw new RuntimeException((String)response.readEntity(String.class));
    }

    public Collection<SchemaBranch> getSchemaBranches(String schemaName) throws SchemaNotFoundException {
        Response response = this.runRetryableBlock(targets -> {
            final WebTarget target = targets.schemasTarget.path(SchemaRegistryClient.encode(schemaName) + "/branches");
            try {
                return (Response)this.login.doAction((PrivilegedAction)new PrivilegedAction<Response>(){

                    @Override
                    public Response run() {
                        return target.request().get();
                    }
                });
            }
            catch (ProcessingException | LoginException e) {
                throw new RegistryRetryableException(e);
            }
        });
        int status = response.getStatus();
        if (status == Response.Status.NOT_FOUND.getStatusCode()) {
            throw new SchemaNotFoundException((String)response.readEntity(String.class));
        }
        if (status != Response.Status.OK.getStatusCode()) {
            throw new RuntimeException((String)response.readEntity(String.class));
        }
        return this.parseResponseAsEntities((String)response.readEntity(String.class), SchemaBranch.class);
    }

    public void deleteSchemaBranch(Long schemaBranchId) throws SchemaBranchNotFoundException, InvalidSchemaBranchDeletionException {
        Response response = this.runRetryableBlock(targets -> {
            final WebTarget target = targets.schemasTarget.path("branch/" + schemaBranchId);
            try {
                return (Response)this.login.doAction((PrivilegedAction)new PrivilegedAction<Response>(){

                    @Override
                    public Response run() {
                        return target.request().delete();
                    }
                });
            }
            catch (ProcessingException | LoginException e) {
                throw new RegistryRetryableException(e);
            }
        });
        int status = response.getStatus();
        if (status == Response.Status.NOT_FOUND.getStatusCode()) {
            throw new SchemaBranchNotFoundException((String)response.readEntity(String.class));
        }
        if (status == Response.Status.BAD_REQUEST.getStatusCode()) {
            throw new InvalidSchemaBranchDeletionException((String)response.readEntity(String.class));
        }
        if (status != Response.Status.OK.getStatusCode()) {
            throw new RuntimeException((String)response.readEntity(String.class));
        }
    }

    public Collection<SchemaVersionInfo> getAllVersions(String schemaBranchName, String schemaName, List<Byte> stateIds) throws SchemaNotFoundException, SchemaBranchNotFoundException {
        return this.runRetryableBlock(targets -> {
            WebTarget webTarget = targets.schemasTarget.path(SchemaRegistryClient.encode(schemaName) + "/versions").queryParam("branch", new Object[]{schemaBranchName}).queryParam("states", stateIds.toArray());
            return this.getEntities(webTarget, SchemaVersionInfo.class);
        });
    }

    private boolean transitionSchemaVersionState(Long schemaVersionId, String operationOrTargetState, final byte[] transitionDetails) throws SchemaNotFoundException, SchemaLifecycleException {
        Response response = this.runRetryableBlock(targets -> {
            final WebTarget webTarget = targets.schemaVersionsTarget.path(schemaVersionId + "/state/" + operationOrTargetState);
            try {
                return (Response)this.login.doAction((PrivilegedAction)new PrivilegedAction<Response>(){

                    @Override
                    public Response run() {
                        return webTarget.request().post(Entity.text((Object)transitionDetails));
                    }
                });
            }
            catch (ProcessingException | LoginException e) {
                throw new RegistryRetryableException(e);
            }
        });
        boolean result = this.handleSchemaLifeCycleResponse(response);
        this.schemaVersionInfoCache.invalidateSchema(SchemaVersionInfoCache.Key.of((SchemaIdVersion)new SchemaIdVersion(schemaVersionId)));
        return result;
    }

    private boolean handleSchemaLifeCycleResponse(Response response) throws SchemaNotFoundException, SchemaLifecycleException {
        int status = response.getStatus();
        if (status != Response.Status.OK.getStatusCode()) {
            if (status == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new SchemaNotFoundException((String)response.readEntity(String.class));
            }
            if (status == Response.Status.BAD_REQUEST.getStatusCode()) {
                CatalogResponse catalogResponse = SchemaRegistryClient.readCatalogResponse((String)response.readEntity(String.class));
                if (catalogResponse.getResponseCode() == CatalogResponse.ResponseMessage.INCOMPATIBLE_SCHEMA.getCode()) {
                    throw new SchemaLifecycleException((Throwable)new IncompatibleSchemaException(catalogResponse.getResponseMessage()));
                }
                throw new SchemaLifecycleException(catalogResponse.getResponseMessage());
            }
            throw new RuntimeException((String)response.readEntity(String.class));
        }
        boolean result = (Boolean)response.readEntity(Boolean.class);
        return result;
    }

    public Collection<SchemaVersionInfo> getAllVersions(String schemaBranchName, String schemaName) throws SchemaNotFoundException {
        return this.runRetryableBlock(targets -> {
            WebTarget webTarget = targets.schemasTarget.path(SchemaRegistryClient.encode(schemaName) + "/versions").queryParam("branch", new Object[]{schemaBranchName});
            return this.getEntities(webTarget, SchemaVersionInfo.class);
        });
    }

    public CompatibilityResult checkCompatibility(String schemaName, String toSchemaText) throws SchemaNotFoundException, SchemaBranchNotFoundException {
        return this.checkCompatibility("MASTER", schemaName, toSchemaText);
    }

    public CompatibilityResult checkCompatibility(String schemaBranchName, String schemaName, final String toSchemaText) throws SchemaNotFoundException {
        String response = this.runRetryableBlock(targets -> {
            try {
                final WebTarget webTarget = targets.schemasTarget.path(SchemaRegistryClient.encode(schemaName) + "/compatibility").queryParam("branch", new Object[]{schemaBranchName});
                return (String)this.login.doAction((PrivilegedAction)new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return (String)webTarget.request().post(Entity.text((Object)toSchemaText), String.class);
                    }
                });
            }
            catch (ProcessingException | LoginException e) {
                throw new RegistryRetryableException(e);
            }
        });
        return this.readEntity(response, CompatibilityResult.class);
    }

    public boolean isCompatibleWithAllVersions(String schemaName, String toSchemaText) throws SchemaNotFoundException, SchemaBranchNotFoundException {
        return this.isCompatibleWithAllVersions("MASTER", schemaName, toSchemaText);
    }

    public boolean isCompatibleWithAllVersions(String schemaBranchName, String schemaName, String toSchemaText) throws SchemaNotFoundException, SchemaBranchNotFoundException {
        return this.checkCompatibility(schemaBranchName, schemaName, toSchemaText).isCompatible();
    }

    public Collection<SchemaVersionKey> findSchemasByFields(SchemaFieldQuery schemaFieldQuery) {
        return this.runRetryableBlock(targets -> {
            WebTarget target = targets.searchFieldsTarget;
            for (Map.Entry entry : schemaFieldQuery.toQueryMap().entrySet()) {
                target = target.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
            }
            return this.getEntities(target, SchemaVersionKey.class);
        });
    }

    public String uploadFile(InputStream inputStream) {
        final MultiPart multiPart = new MultiPart();
        StreamDataBodyPart filePart = new StreamDataBodyPart("file", inputStream, "file");
        multiPart.bodyPart((BodyPart)filePart);
        return this.runRetryableBlock(targets -> {
            try {
                return (String)this.login.doAction((PrivilegedAction)new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return (String)targets.filesTarget.request().post(Entity.entity((Object)multiPart, (String)"multipart/form-data"), String.class);
                    }
                });
            }
            catch (ProcessingException | LoginException e) {
                throw new RegistryRetryableException(e);
            }
        });
    }

    public InputStream downloadFile(final String fileId) {
        return this.runRetryableBlock(targets -> {
            try {
                return (InputStream)this.login.doAction((PrivilegedAction)new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        return (InputStream)targets.filesTarget.path("download/" + SchemaRegistryClient.encode(fileId)).request().get(InputStream.class);
                    }
                });
            }
            catch (ProcessingException | LoginException e) {
                this.urlSelector.urlWithError(targets.rootTarget.getUri().toString(), (Exception)e);
                throw new RegistryRetryableException(e);
            }
        });
    }

    public Long addSerDes(SerDesPair serDesPair) {
        return this.runRetryableBlock(targets -> this.postEntity(targets.serializersTarget, serDesPair, Long.class));
    }

    public void mapSchemaWithSerDes(String schemaName, Long serDesId) {
        String path = String.format("%s/mapping/%s", SchemaRegistryClient.encode(schemaName), serDesId.toString());
        Boolean success = this.runRetryableBlock(targets -> this.postEntity(targets.schemasTarget.path(path), null, Boolean.class));
        LOG.info("Received response while mapping schema [{}] with serialzer/deserializer [{}] : [{}]", new Object[]{schemaName, serDesId, success});
    }

    public <T> T getDefaultSerializer(String type) throws SerDesException {
        Collection<SchemaProviderInfo> supportedSchemaProviders = this.getSupportedSchemaProviders();
        for (SchemaProviderInfo schemaProvider : supportedSchemaProviders) {
            if (!schemaProvider.getType().equals(type)) continue;
            try {
                return (T)Class.forName(schemaProvider.getDefaultSerializerClassName()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new SerDesException((Throwable)e);
            }
        }
        throw new IllegalArgumentException("No schema provider registered for the given type " + type);
    }

    public <T> T getDefaultDeserializer(String type) throws SerDesException {
        Collection<SchemaProviderInfo> supportedSchemaProviders = this.getSupportedSchemaProviders();
        for (SchemaProviderInfo schemaProvider : supportedSchemaProviders) {
            if (!schemaProvider.getType().equals(type)) continue;
            try {
                return (T)Class.forName(schemaProvider.getDefaultDeserializerClassName()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new SerDesException((Throwable)e);
            }
        }
        throw new IllegalArgumentException("No schema provider registered for the given type " + type);
    }

    public Collection<SerDesInfo> getSerDes(String schemaName) {
        return this.runRetryableBlock(targets -> {
            String path = SchemaRegistryClient.encode(schemaName) + "/serdes/";
            return this.getEntities(targets.schemasTarget.path(path), SerDesInfo.class);
        });
    }

    public <T> T createSerializerInstance(SerDesInfo serDesInfo) {
        return this.createInstance(serDesInfo, true);
    }

    public <T> T createDeserializerInstance(SerDesInfo serDesInfo) {
        return this.createInstance(serDesInfo, false);
    }

    public void close() {
        this.client.close();
    }

    public SchemaRegistryVersion clientVersion() {
        return CLIENT_VERSION;
    }

    private <T> T createInstance(SerDesInfo serDesInfo, boolean isSerializer) {
        Object t;
        Set<Class<?>> interfaceClasses;
        Set<Class<?>> set = interfaceClasses = isSerializer ? SERIALIZER_INTERFACE_CLASSES : DESERIALIZER_INTERFACE_CLASSES;
        if (interfaceClasses == null || interfaceClasses.isEmpty()) {
            throw new IllegalArgumentException("interfaceClasses array must be neither null nor empty.");
        }
        SerDesPair serDesPair = serDesInfo.getSerDesPair();
        String fileId = serDesPair.getFileId();
        ClassLoader classLoader = this.classLoaderCache.getClassLoader(fileId);
        try {
            String className = isSerializer ? serDesPair.getSerializerClassName() : serDesPair.getDeserializerClassName();
            Class<?> clazz = Class.forName(className, true, classLoader);
            t = clazz.newInstance();
            ArrayList classes = new ArrayList();
            for (Class<?> interfaceClass : interfaceClasses) {
                if (!interfaceClass.isAssignableFrom(clazz)) continue;
                classes.add(interfaceClass);
            }
            if (classes.isEmpty()) {
                throw new RuntimeException("Given Serialize/Deserializer " + className + " class does not implement any one of the registered interfaces: " + interfaceClasses);
            }
            Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), classes.toArray(new Class[classes.size()]), (InvocationHandler)new ClassLoaderAwareInvocationHandler(classLoader, t));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SerDesException((Throwable)e);
        }
        return (T)t;
    }

    private <T> List<T> getEntities(final WebTarget target, Class<T> clazz) {
        String response = null;
        try {
            response = (String)this.login.doAction((PrivilegedAction)new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return (String)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(String.class);
                }
            });
        }
        catch (ProcessingException | LoginException e) {
            throw new RegistryRetryableException(e);
        }
        return this.parseResponseAsEntities(response, clazz);
    }

    private <T> List<T> parseResponseAsEntities(String response, Class<T> clazz) {
        ArrayList<Object> entities = new ArrayList<Object>();
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(response);
            Iterator it = node.get("entities").elements();
            while (it.hasNext()) {
                entities.add(mapper.treeToValue((TreeNode)it.next(), clazz));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return entities;
    }

    private <T> T postEntity(final WebTarget target, final Object json, Class<T> responseType) {
        String response = null;
        try {
            response = (String)this.login.doAction((PrivilegedAction)new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return (String)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)json), String.class);
                }
            });
        }
        catch (ProcessingException | LoginException e) {
            throw new RegistryRetryableException(e);
        }
        return this.readEntity(response, responseType);
    }

    private <T> T readEntity(String response, Class<T> clazz) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (T)mapper.readValue(response, clazz);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private <T> T getEntity(final WebTarget target, Class<T> clazz) {
        String response = null;
        try {
            response = (String)this.login.doAction((PrivilegedAction)new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return (String)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(String.class);
                }
            });
        }
        catch (ProcessingException | LoginException e) {
            throw new RegistryRetryableException(e);
        }
        return this.readEntity(response, clazz);
    }

    private <T> T runRetryableBlock(RegistryRetryableBlock<T> registryRetryableBlock) {
        return (T)this.retryExecutor.execute(() -> {
            WebTarget initialWebTarget = null;
            RegistryRetryableException retryableException = null;
            while (true) {
                SchemaRegistryTargets targets = this.currentSchemaRegistryTargets();
                if (initialWebTarget == null) {
                    initialWebTarget = targets.rootTarget;
                } else if (initialWebTarget.equals(targets.rootTarget)) {
                    throw retryableException;
                }
                try {
                    LOG.debug("Using '" + targets.rootTarget + "' to make request");
                    return registryRetryableBlock.run(targets);
                }
                catch (RegistryRetryableException e) {
                    this.urlSelector.urlWithError(targets.rootTarget.getUri().toString(), (Exception)((Object)e));
                    retryableException = e;
                    continue;
                }
                break;
            }
        });
    }

    private static interface RegistryRetryableBlock<T> {
        public T run(SchemaRegistryTargets var1) throws RegistryRetryableException;
    }

    private static class SchemaDigestEntry {
        private final String name;
        private final byte[] schemaDigest;

        SchemaDigestEntry(String name, byte[] schemaDigest) {
            Preconditions.checkNotNull((Object)name, (Object)"name can not be null");
            Preconditions.checkNotNull((Object)schemaDigest, (Object)"schema digest can not be null");
            this.name = name;
            this.schemaDigest = schemaDigest;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaDigestEntry that = (SchemaDigestEntry)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return Arrays.equals(this.schemaDigest, that.schemaDigest);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + Arrays.hashCode(this.schemaDigest);
            return result;
        }
    }

    public static final class Configuration {
        public static final ConfigEntry<String> SCHEMA_REGISTRY_URL = ConfigEntry.mandatory((String)"schema.registry.url", String.class, (String)"URL of schema registry to which this client connects to. For ex: http://localhost:9090/api/v1", (Object)"http://localhost:9090/api/v1", (ConfigEntry.Converter)ConfigEntry.StringConverter.get(), (ConfigEntry.Validator)ConfigEntry.NonEmptyStringValidator.get());
        public static final String DEFAULT_LOCAL_JARS_PATH = "/tmp/schema-registry/local-jars";
        public static final ConfigEntry<String> LOCAL_JAR_PATH = ConfigEntry.optional((String)"schema.registry.client.local.jars.path", String.class, (String)"URL of schema registry to which this client connects to. For ex: http://localhost:9090/api/v1", (Object)"/tmp/schema-registry/local-jars", (ConfigEntry.Converter)ConfigEntry.StringConverter.get(), (ConfigEntry.Validator)ConfigEntry.NonEmptyStringValidator.get());
        public static final long DEFAULT_CLASSLOADER_CACHE_SIZE = 1024L;
        public static final long DEFAULT_CLASSLOADER_CACHE_EXPIRY_INTERVAL_SECS = 3600L;
        public static final ConfigEntry<Number> CLASSLOADER_CACHE_SIZE = ConfigEntry.optional((String)"schema.registry.client.class.loader.cache.size", Integer.class, (String)"Maximum size of classloader cache", (Object)1024L, (ConfigEntry.Converter)ConfigEntry.IntegerConverter.get(), (ConfigEntry.Validator)ConfigEntry.PositiveNumberValidator.get());
        public static final ConfigEntry<Number> CLASSLOADER_CACHE_EXPIRY_INTERVAL_SECS = ConfigEntry.optional((String)"schema.registry.client.class.loader.cache.expiry.interval.secs", Integer.class, (String)"Expiry interval(in seconds) of an entry in classloader cache", (Object)3600L, (ConfigEntry.Converter)ConfigEntry.IntegerConverter.get(), (ConfigEntry.Validator)ConfigEntry.PositiveNumberValidator.get());
        public static final long DEFAULT_SCHEMA_CACHE_SIZE = 1024L;
        public static final long DEFAULT_SCHEMA_CACHE_EXPIRY_INTERVAL_SECS = 300L;
        public static final ConfigEntry<Number> SCHEMA_VERSION_CACHE_SIZE = ConfigEntry.optional((String)"schema.registry.client.schema.version.cache.size", Integer.class, (String)"Maximum size of schema version cache", (Object)1024L, (ConfigEntry.Converter)ConfigEntry.IntegerConverter.get(), (ConfigEntry.Validator)ConfigEntry.PositiveNumberValidator.get());
        public static final ConfigEntry<Number> SCHEMA_VERSION_CACHE_EXPIRY_INTERVAL_SECS = ConfigEntry.optional((String)"schema.registry.client.schema.version.cache.expiry.interval.secs", Integer.class, (String)"Expiry interval(in seconds) of an entry in schema version cache", (Object)300L, (ConfigEntry.Converter)ConfigEntry.IntegerConverter.get(), (ConfigEntry.Validator)ConfigEntry.PositiveNumberValidator.get());
        public static final ConfigEntry<Number> SCHEMA_METADATA_CACHE_SIZE = ConfigEntry.optional((String)"schema.registry.client.schema.metadata.cache.size", Integer.class, (String)"Maximum size of schema metadata cache", (Object)1024L, (ConfigEntry.Converter)ConfigEntry.IntegerConverter.get(), (ConfigEntry.Validator)ConfigEntry.PositiveNumberValidator.get());
        public static final ConfigEntry<Number> SCHEMA_METADATA_CACHE_EXPIRY_INTERVAL_SECS = ConfigEntry.optional((String)"schema.registry.client.schema.metadata.cache.expiry.interval.secs", Integer.class, (String)"Expiry interval(in seconds) of an entry in schema metadata cache", (Object)300L, (ConfigEntry.Converter)ConfigEntry.IntegerConverter.get(), (ConfigEntry.Validator)ConfigEntry.PositiveNumberValidator.get());
        public static final ConfigEntry<Number> SCHEMA_TEXT_CACHE_SIZE = ConfigEntry.optional((String)"schema.registry.client.schema.text.cache.size", Integer.class, (String)"Maximum size of schema text cache", (Object)1024L, (ConfigEntry.Converter)ConfigEntry.IntegerConverter.get(), (ConfigEntry.Validator)ConfigEntry.PositiveNumberValidator.get());
        public static final ConfigEntry<Number> SCHEMA_TEXT_CACHE_EXPIRY_INTERVAL_SECS = ConfigEntry.optional((String)"schema.registry.client.schema.text.cache.expiry.interval.secs", Integer.class, (String)"Expiry interval(in seconds) of an entry in schema text cache.", (Object)300L, (ConfigEntry.Converter)ConfigEntry.IntegerConverter.get(), (ConfigEntry.Validator)ConfigEntry.PositiveNumberValidator.get());
        public static final ConfigEntry<String> URL_SELECTOR_CLASS = ConfigEntry.optional((String)"schema.registry.client.url.selector", String.class, (String)"Schema Registry URL selector class.", (Object)FailoverUrlSelector.class.getName(), (ConfigEntry.Converter)ConfigEntry.StringConverter.get(), (ConfigEntry.Validator)ConfigEntry.NonEmptyStringValidator.get());
        public static final ConfigEntry<String> SASL_JAAS_CONFIG = ConfigEntry.optional((String)"sasl.jaas.config", String.class, (String)"Schema Registry Dynamic JAAS config for SASL connection.", null, (ConfigEntry.Converter)ConfigEntry.StringConverter.get(), (ConfigEntry.Validator)ConfigEntry.NonEmptyStringValidator.get());
        public static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
        public static final int DEFAULT_READ_TIMEOUT = 30000;
        public static final ConfigEntry<String> AUTH_USERNAME = ConfigEntry.optional((String)"schema.registry.auth.username", String.class, (String)"Username for basic authentication", null, (ConfigEntry.Converter)ConfigEntry.StringConverter.get(), (ConfigEntry.Validator)ConfigEntry.NonEmptyStringValidator.get());
        public static final ConfigEntry<String> AUTH_PASSWORD = ConfigEntry.optional((String)"schema.registry.auth.password", String.class, (String)"Password for basic authentication", null, (ConfigEntry.Converter)ConfigEntry.StringConverter.get(), (ConfigEntry.Validator)ConfigEntry.NonEmptyStringValidator.get());
        private final Map<String, ?> config;
        private final Map<String, ConfigEntry<?>> options;

        public Configuration(Map<String, ?> config) {
            Field[] fields = this.getClass().getDeclaredFields();
            this.options = Collections.unmodifiableMap(this.buildOptions(fields));
            this.config = this.buildConfig(config);
        }

        private Map<String, ?> buildConfig(Map<String, ?> config) {
            HashMap result = new HashMap();
            for (Map.Entry<String, ?> entry : config.entrySet()) {
                Object value;
                String key = entry.getKey();
                Object finalValue = value = entry.getValue();
                ConfigEntry<?> configEntry = this.options.get(key);
                if (configEntry != null) {
                    if (value != null) {
                        finalValue = configEntry.converter().convert(value);
                        configEntry.validator().validate(finalValue);
                    } else {
                        finalValue = configEntry.defaultValue();
                    }
                }
                result.put(key, finalValue);
            }
            return result;
        }

        private Map<String, ConfigEntry<?>> buildOptions(Field[] fields) {
            HashMap options = new HashMap();
            for (Field field : fields) {
                Class<ConfigEntry> type = field.getType();
                if (!type.isAssignableFrom(ConfigEntry.class)) continue;
                field.setAccessible(true);
                try {
                    ConfigEntry configEntry = (ConfigEntry)field.get(this);
                    options.put(configEntry.name(), configEntry);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return options;
        }

        public <T> T getValue(String propertyKey) {
            return (T)(this.config.containsKey(propertyKey) ? this.config.get(propertyKey) : this.options.get(propertyKey).defaultValue());
        }

        public Map<String, Object> getConfig() {
            return Collections.unmodifiableMap(this.config);
        }

        public Collection<ConfigEntry<?>> getAvailableConfigEntries() {
            return this.options.values();
        }
    }

    private static class SchemaRegistryTargets {
        private final WebTarget schemaProvidersTarget;
        private final WebTarget schemasTarget;
        private final WebTarget schemasByIdTarget;
        private final WebTarget rootTarget;
        private final WebTarget searchFieldsTarget;
        private final WebTarget serializersTarget;
        private final WebTarget filesTarget;
        private final WebTarget schemaVersionsTarget;
        private final WebTarget schemaVersionsByIdTarget;
        private final WebTarget schemaVersionsStatesMachineTarget;

        SchemaRegistryTargets(WebTarget rootTarget) {
            this.rootTarget = rootTarget;
            this.schemaProvidersTarget = rootTarget.path(SchemaRegistryClient.SCHEMA_PROVIDERS_PATH);
            this.schemasTarget = rootTarget.path(SchemaRegistryClient.SCHEMAS_PATH);
            this.schemasByIdTarget = rootTarget.path(SchemaRegistryClient.SCHEMAS_BY_ID_PATH);
            this.schemaVersionsByIdTarget = this.schemasTarget.path("versionsById");
            this.schemaVersionsTarget = rootTarget.path(SchemaRegistryClient.SCHEMA_VERSIONS_PATH);
            this.schemaVersionsStatesMachineTarget = this.schemaVersionsTarget.path("statemachine");
            this.searchFieldsTarget = rootTarget.path(SchemaRegistryClient.SEARCH_FIELDS);
            this.serializersTarget = rootTarget.path(SchemaRegistryClient.SERIALIZERS_PATH);
            this.filesTarget = rootTarget.path(SchemaRegistryClient.FILES_PATH);
        }
    }
}

