/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class CompatibilityResult
implements Serializable {
    public static final CompatibilityResult SUCCESS = new CompatibilityResult(true, null);
    private static final long serialVersionUID = 6611482356634821602L;
    private boolean compatible;
    private String errorMessage;
    private String errorLocation;
    private String schema;

    private CompatibilityResult() {
    }

    private CompatibilityResult(boolean compatible, String schema) {
        this.compatible = compatible;
        this.schema = schema;
    }

    private CompatibilityResult(boolean compatible, String errorMessage, String errorLocation, String schema) {
        this.compatible = compatible;
        this.errorMessage = errorMessage;
        this.errorLocation = errorLocation;
        this.schema = schema;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getErrorLocation() {
        return this.errorLocation;
    }

    public String toString() {
        return "CompatibilityResult{compatible=" + this.compatible + ", errorMessage='" + this.errorMessage + '\'' + ", errorLocation='" + this.errorLocation + '\'' + ", schema='" + this.schema + '\'' + '}';
    }

    public static CompatibilityResult createIncompatibleResult(String errorMessage, String errorLocation, String schema) {
        return new CompatibilityResult(false, errorMessage, errorLocation, schema);
    }

    public static CompatibilityResult createCompatibleResult(String schema) {
        return new CompatibilityResult(true, schema);
    }
}

