/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class SchemaVersionKey
implements Serializable {
    private static final long serialVersionUID = 1779747592974345866L;
    public static final Integer LATEST_VERSION = -1;
    private String schemaName;
    private Integer version;

    private SchemaVersionKey() {
    }

    public SchemaVersionKey(String schemaName, Integer version) {
        Preconditions.checkNotNull((Object)schemaName, (Object)"schemaName can not be null");
        Preconditions.checkNotNull((Object)version, (Object)"version can not be null");
        this.schemaName = schemaName;
        this.version = version;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaVersionKey that = (SchemaVersionKey)o;
        if (this.schemaName != null ? !this.schemaName.equals(that.schemaName) : that.schemaName != null) {
            return false;
        }
        return this.version != null ? this.version.equals(that.version) : that.version == null;
    }

    public int hashCode() {
        int result = this.schemaName != null ? this.schemaName.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SchemaVersionKey{schemaName='" + this.schemaName + '\'' + ", version=" + this.version + '}';
    }
}

