/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serde;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.SchemaMetadata;
import com.hortonworks.registries.schemaregistry.SchemaVersionInfo;
import com.hortonworks.registries.schemaregistry.SchemaVersionKey;
import com.hortonworks.registries.schemaregistry.client.ISchemaRegistryClient;
import com.hortonworks.registries.schemaregistry.errors.InvalidSchemaException;
import com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException;
import com.hortonworks.registries.schemaregistry.exceptions.RegistryException;
import com.hortonworks.registries.schemaregistry.serde.AbstractSerDes;
import com.hortonworks.registries.schemaregistry.serde.SerDesException;
import com.hortonworks.registries.schemaregistry.serde.SnapshotDeserializer;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class AbstractSnapshotDeserializer<I, O, S>
extends AbstractSerDes
implements SnapshotDeserializer<I, O, Integer> {
    public static final String DESERIALIZER_SCHEMA_CACHE_MAX_SIZE = "schemaregistry.deserializer.schema.cache.size";
    public static final Integer DEFAULT_SCHEMA_CACHE_SIZE = 1024;
    public static final String DESERIALIZER_SCHEMA_CACHE_EXPIRY_IN_SECS = "schemaregistry.deserializer.schema.cache.expiry.secs";
    public static final Long DEFAULT_DESERIALIZER_SCHEMA_CACHE_EXPIRY_IN_SECS = 300L;
    private LoadingCache<SchemaVersionKey, S> schemaCache;

    public AbstractSnapshotDeserializer() {
    }

    public AbstractSnapshotDeserializer(ISchemaRegistryClient schemaRegistryClient) {
        super(schemaRegistryClient);
    }

    @Override
    protected void doInit(Map<String, ?> config) {
        this.schemaCache = CacheBuilder.newBuilder().maximumSize((long)this.getCacheMaxSize(config).intValue()).expireAfterAccess(this.getCacheExpiryInSecs(config).longValue(), TimeUnit.SECONDS).build(new CacheLoader<SchemaVersionKey, S>(){

            public S load(SchemaVersionKey schemaVersionKey) {
                try {
                    return AbstractSnapshotDeserializer.this.getParsedSchema(schemaVersionKey);
                }
                catch (InvalidSchemaException | SchemaNotFoundException e) {
                    throw new RegistryException(e);
                }
            }
        });
    }

    private Long getCacheExpiryInSecs(Map<String, ?> config) {
        Long value = (Long)this.getValue(config, DESERIALIZER_SCHEMA_CACHE_EXPIRY_IN_SECS, DEFAULT_DESERIALIZER_SCHEMA_CACHE_EXPIRY_IN_SECS);
        if (value < 0L) {
            throw new IllegalArgumentException("Property: schemaregistry.deserializer.schema.cache.expiry.secs must be non negative.");
        }
        return value;
    }

    private Integer getCacheMaxSize(Map<String, ?> config) {
        Integer value = (Integer)this.getValue(config, DESERIALIZER_SCHEMA_CACHE_MAX_SIZE, DEFAULT_SCHEMA_CACHE_SIZE);
        if (value < 0) {
            throw new IllegalArgumentException("Property: schemaregistry.deserializer.schema.cache.size must be non negative.");
        }
        return value;
    }

    protected Object getValue(Map<String, ?> config, String key, Object defaultValue) {
        Object value = config.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected abstract S getParsedSchema(SchemaVersionKey var1) throws InvalidSchemaException, SchemaNotFoundException;

    public O deserialize(I input, Integer readerSchemaVersion) throws SerDesException {
        SchemaMetadata schemaMetadata;
        SchemaVersionInfo schemaVersionInfo;
        this.ensureInitialized();
        byte protocolId = this.retrieveProtocolId(input);
        SchemaIdVersion schemaIdVersion = this.retrieveSchemaIdVersion(protocolId, input);
        try {
            schemaVersionInfo = this.schemaRegistryClient.getSchemaVersionInfo(schemaIdVersion);
            schemaMetadata = this.schemaRegistryClient.getSchemaMetadataInfo(schemaVersionInfo.getName()).getSchemaMetadata();
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        return this.doDeserialize(input, protocolId, schemaMetadata, schemaVersionInfo.getVersion(), readerSchemaVersion);
    }

    protected abstract O doDeserialize(I var1, byte var2, SchemaMetadata var3, Integer var4, Integer var5) throws SerDesException;

    protected abstract byte retrieveProtocolId(I var1) throws SerDesException;

    protected abstract SchemaIdVersion retrieveSchemaIdVersion(byte var1, I var2) throws SerDesException;

    protected S getSchema(SchemaVersionKey schemaVersionKey) {
        try {
            return (S)this.schemaCache.get((Object)schemaVersionKey);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RegistryException) {
                throw (RegistryException)e.getCause();
            }
            throw new RegistryException((Throwable)e);
        }
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("init should be invoked before invoking deserialize operation");
        }
        if (this.closed) {
            throw new IllegalStateException("This deserializer is already closed");
        }
    }
}

