/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro;

import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.client.ISchemaRegistryClient;
import com.hortonworks.registries.schemaregistry.serde.AbstractSnapshotSerializer;
import com.hortonworks.registries.schemaregistry.serde.SerDesException;
import com.hortonworks.registries.schemaregistry.serdes.SerDesProtocolHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.AvroUtils;
import com.hortonworks.registries.schemaregistry.serdes.avro.SerDesProtocolHandlerRegistry;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avro.Schema;

public abstract class AbstractAvroSnapshotSerializer<O>
extends AbstractSnapshotSerializer<Object, O> {
    public static final String SERDES_PROTOCOL_VERSION = "serdes.protocol.version";
    protected SerDesProtocolHandler serDesProtocolHandler;

    public AbstractAvroSnapshotSerializer() {
    }

    public AbstractAvroSnapshotSerializer(ISchemaRegistryClient schemaRegistryClient) {
        super(schemaRegistryClient);
    }

    @Override
    public void doInit(Map<String, ?> config) {
        Number number = config.getOrDefault(SERDES_PROTOCOL_VERSION, (byte)3);
        this.validateSerdesProtocolVersion(number);
        Byte protocolVersion = number.byteValue();
        SerDesProtocolHandler serDesProtocolHandler = SerDesProtocolHandlerRegistry.get().getSerDesProtocolHandler(protocolVersion);
        if (serDesProtocolHandler == null) {
            throw new AvroException("SerDesProtocolHandler with protocol version " + protocolVersion + " does not exist");
        }
        this.serDesProtocolHandler = serDesProtocolHandler;
    }

    private void validateSerdesProtocolVersion(Number number) {
        long x = number.longValue();
        if ((double)x != number.doubleValue() || x < 0L || x > 127L) {
            throw new AvroException("serdes.protocol.version value should be in [0, 127]");
        }
    }

    @Override
    protected String getSchemaText(Object input) {
        Schema schema = AvroUtils.computeSchema(input);
        return schema.toString();
    }

    protected void serializeSchemaVersion(OutputStream os, SchemaIdVersion schemaIdVersion) throws SerDesException {
        this.serDesProtocolHandler.handleSchemaVersionSerialization(os, schemaIdVersion);
    }

    protected void serializePayload(OutputStream os, Object input) throws SerDesException {
        this.serDesProtocolHandler.handlePayloadSerialization(os, input);
    }

    protected Byte getProtocolId() {
        return this.serDesProtocolHandler.getProtocolId();
    }
}

