/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro;

import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.client.ISchemaRegistryClient;
import com.hortonworks.registries.schemaregistry.serde.SerDesException;
import com.hortonworks.registries.schemaregistry.serdes.avro.AbstractAvroSnapshotSerializer;
import com.hortonworks.registries.schemaregistry.serdes.avro.MessageAndMetadata;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroRetryableException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class MessageAndMetadataAvroSerializer
extends AbstractAvroSnapshotSerializer<MessageAndMetadata> {
    public MessageAndMetadataAvroSerializer() {
    }

    public MessageAndMetadataAvroSerializer(ISchemaRegistryClient schemaRegistryClient) {
        super(schemaRegistryClient);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected MessageAndMetadata doSerialize(Object input, SchemaIdVersion schemaIdVersion) throws SerDesException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.serializeSchemaVersion(baos, schemaIdVersion);
            byte[] serializedSchemaVersion = baos.toByteArray();
            baos.reset();
            this.serializePayload(baos, input);
            byte[] payload = baos.toByteArray();
            MessageAndMetadata messageAndMetadata = new MessageAndMetadata(serializedSchemaVersion, payload);
            return messageAndMetadata;
        }
        catch (IOException ex) {
            throw new AvroRetryableException(ex);
        }
    }
}

