/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro;

import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.serde.SerDesException;
import com.hortonworks.registries.schemaregistry.serdes.avro.AbstractAvroSerDesProtocolHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.DefaultAvroSerDesHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroRetryableException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class SchemaMetadataIdProtocolHandler
extends AbstractAvroSerDesProtocolHandler {
    public SchemaMetadataIdProtocolHandler() {
        super((byte)1, new DefaultAvroSerDesHandler());
    }

    @Override
    protected void doHandleSchemaVersionSerialization(OutputStream outputStream, SchemaIdVersion schemaIdVersion) throws SerDesException {
        try {
            outputStream.write(ByteBuffer.allocate(12).putLong(schemaIdVersion.getSchemaMetadataId()).putInt(schemaIdVersion.getVersion()).array());
        }
        catch (IOException e) {
            throw new AvroRetryableException(e);
        }
    }

    @Override
    public SchemaIdVersion handleSchemaVersionDeserialization(InputStream inputStream) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(12);
        try {
            inputStream.read(byteBuffer.array());
        }
        catch (IOException e) {
            throw new AvroRetryableException(e);
        }
        long schemaMetadataId = byteBuffer.getLong();
        int schemaVersion = byteBuffer.getInt();
        return new SchemaIdVersion(Long.valueOf(schemaMetadataId), Integer.valueOf(schemaVersion));
    }
}

