/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro;

import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.serdes.avro.AbstractAvroSerDesProtocolHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.DefaultAvroSerDesHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.SchemaVersionIdAsLongProtocolHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroException;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroRetryableException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaVersionIdAsIntProtocolHandler
extends AbstractAvroSerDesProtocolHandler {
    public static final Logger LOG = LoggerFactory.getLogger(SchemaVersionIdAsIntProtocolHandler.class);
    private final SchemaVersionIdAsLongProtocolHandler delegate = new SchemaVersionIdAsLongProtocolHandler();

    public SchemaVersionIdAsIntProtocolHandler() {
        super((byte)3, new DefaultAvroSerDesHandler());
    }

    @Override
    public void handleSchemaVersionSerialization(OutputStream outputStream, SchemaIdVersion schemaIdVersion) {
        Long versionId = schemaIdVersion.getSchemaVersionId();
        if (versionId > Integer.MAX_VALUE) {
            LOG.debug("Upgraded to " + this.delegate + " as versionId is more than max integer");
            this.delegate.handleSchemaVersionSerialization(outputStream, schemaIdVersion);
        } else {
            try {
                outputStream.write(new byte[]{this.protocolId});
                outputStream.write(ByteBuffer.allocate(4).putInt(versionId.intValue()).array());
            }
            catch (IOException e) {
                throw new AvroException(e);
            }
        }
    }

    @Override
    protected void doHandleSchemaVersionSerialization(OutputStream outputStream, SchemaIdVersion schemaIdVersion) throws IOException {
    }

    @Override
    public SchemaIdVersion handleSchemaVersionDeserialization(InputStream inputStream) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            inputStream.read(byteBuffer.array());
        }
        catch (IOException e) {
            throw new AvroRetryableException(e);
        }
        int schemaVersionId = byteBuffer.getInt();
        return new SchemaIdVersion(Long.valueOf(schemaVersionId));
    }
}

