/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro;

import com.hortonworks.registries.schemaregistry.serdes.SerDesProtocolHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.ConfluentProtocolHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.SchemaMetadataIdProtocolHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.SchemaVersionIdAsIntProtocolHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.SchemaVersionIdAsLongProtocolHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SerDesProtocolHandlerRegistry {
    public static final byte CONFLUENT_VERSION_PROTOCOL = 0;
    public static final byte METADATA_ID_VERSION_PROTOCOL = 1;
    public static final byte VERSION_ID_AS_LONG_PROTOCOL = 2;
    public static final byte VERSION_ID_AS_INT_PROTOCOL = 3;
    public static final byte CURRENT_PROTOCOL = 3;
    private static final SerDesProtocolHandlerRegistry instance = new SerDesProtocolHandlerRegistry();
    private final Map<Byte, SerDesProtocolHandler> protocolWithHandlers = new ConcurrentHashMap<Byte, SerDesProtocolHandler>();

    public static SerDesProtocolHandlerRegistry get() {
        return instance;
    }

    public SerDesProtocolHandler getSerDesProtocolHandler(Byte protocolId) {
        return this.protocolWithHandlers.get(protocolId);
    }

    public Map<Byte, SerDesProtocolHandler> getRegisteredSerDesProtocolHandlers() {
        return Collections.unmodifiableMap(this.protocolWithHandlers);
    }

    private SerDesProtocolHandlerRegistry() {
        List<SerDesProtocolHandler> inbuiltHandlers = Arrays.asList(new ConfluentProtocolHandler(), new SchemaMetadataIdProtocolHandler(), new SchemaVersionIdAsIntProtocolHandler(), new SchemaVersionIdAsLongProtocolHandler());
        for (SerDesProtocolHandler inbuiltHandler : inbuiltHandlers) {
            this.registerSerDesProtocolHandler(inbuiltHandler);
        }
    }

    public void registerSerDesProtocolHandler(SerDesProtocolHandler serDesProtocolHandler) {
        SerDesProtocolHandler existingHandler = this.protocolWithHandlers.putIfAbsent(serDesProtocolHandler.getProtocolId(), serDesProtocolHandler);
        if (existingHandler != null) {
            throw new IllegalArgumentException("SerDesProtocolHandler is already registered with the given protocol id: " + serDesProtocolHandler.getProtocolId());
        }
    }
}

