/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro.kafka;

import com.hortonworks.registries.schemaregistry.SchemaCompatibility;
import com.hortonworks.registries.schemaregistry.SchemaMetadata;
import com.hortonworks.registries.schemaregistry.client.ISchemaRegistryClient;
import com.hortonworks.registries.schemaregistry.serdes.Utils;
import com.hortonworks.registries.schemaregistry.serdes.avro.AvroSnapshotSerializer;
import com.hortonworks.registries.schemaregistry.serdes.avro.MessageAndMetadata;
import com.hortonworks.registries.schemaregistry.serdes.avro.MessageAndMetadataAvroSerializer;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaAvroSerializer
implements Serializer<Object> {
    public static final String SCHEMA_COMPATIBILITY = "schema.compatibility";
    public static final String SCHEMA_GROUP = "schema.group";
    public static final String SCHEMA_NAME_KEY_SUFFIX_ = "schema.name.key.suffix";
    public static final String SCHEMA_NAME_VALUE_SUFFIX_ = "schema.name.value.suffix";
    public static final String STORE_SCHEMA_VERSION_ID_IN_HEADER = "store.schema.version.id.in.header";
    public static final String DEFAULT_SCHEMA_GROUP = "kafka";
    public static final String DEFAULT_SCHEMA_NAME_KEY_SUFFIX = ":k";
    public static final String DEFAULT_SCHEMA_NAME_VALUE_SUFFIX = null;
    public static final String DEFAULT_STORE_SCHEMA_VERSION_ID_IN_HEADER = "false";
    private boolean isKey;
    private final AvroSnapshotSerializer avroSnapshotSerializer;
    private final MessageAndMetadataAvroSerializer messageAndMetadataAvroSerializer;
    private String keySchemaVersionIdHeaderName;
    private String valueSchemaVersionIdHeaderName;
    private boolean useRecordHeader;
    private SchemaCompatibility compatibility;
    private String schemaGroup;
    private String schemaNameKeySuffix;
    private String schemaNameValueSuffix;

    public KafkaAvroSerializer() {
        this.avroSnapshotSerializer = new AvroSnapshotSerializer();
        this.messageAndMetadataAvroSerializer = new MessageAndMetadataAvroSerializer();
    }

    public KafkaAvroSerializer(ISchemaRegistryClient schemaRegistryClient) {
        this.avroSnapshotSerializer = new AvroSnapshotSerializer(schemaRegistryClient);
        this.messageAndMetadataAvroSerializer = new MessageAndMetadataAvroSerializer(schemaRegistryClient);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.compatibility = SchemaCompatibility.valueOf((String)Utils.getOrDefaultAsString(configs, SCHEMA_COMPATIBILITY, SchemaCompatibility.DEFAULT_COMPATIBILITY.name()).toUpperCase());
        this.schemaGroup = Utils.getOrDefaultAsString(configs, SCHEMA_GROUP, DEFAULT_SCHEMA_GROUP);
        this.schemaNameKeySuffix = Utils.getOrDefaultAsString(configs, SCHEMA_NAME_KEY_SUFFIX_, DEFAULT_SCHEMA_NAME_KEY_SUFFIX);
        this.schemaNameValueSuffix = Utils.getOrDefaultAsString(configs, SCHEMA_NAME_VALUE_SUFFIX_, DEFAULT_SCHEMA_NAME_VALUE_SUFFIX);
        this.isKey = isKey;
        this.keySchemaVersionIdHeaderName = Utils.getOrDefaultAsString(configs, "key_schema_version_id_header_name", "key.schema.version.id");
        if (this.keySchemaVersionIdHeaderName == null || this.keySchemaVersionIdHeaderName.isEmpty()) {
            throw new IllegalArgumentException("keySchemaVersionIdHeaderName should not be null or empty");
        }
        this.valueSchemaVersionIdHeaderName = Utils.getOrDefaultAsString(configs, "value_schema_version_id_header_name", "value.schema.version.id");
        if (this.valueSchemaVersionIdHeaderName == null || this.valueSchemaVersionIdHeaderName.isEmpty()) {
            throw new IllegalArgumentException("valueSchemaVersionIdHeaderName should not be null or empty");
        }
        this.useRecordHeader = Boolean.valueOf(Utils.getOrDefaultAsString(configs, STORE_SCHEMA_VERSION_ID_IN_HEADER, DEFAULT_STORE_SCHEMA_VERSION_ID_IN_HEADER));
        this.avroSnapshotSerializer.init(configs);
        this.messageAndMetadataAvroSerializer.init(configs);
    }

    public byte[] serialize(String topic, Object data) {
        return (byte[])this.avroSnapshotSerializer.serialize(data, this.createSchemaMetadata(topic));
    }

    public byte[] serialize(String topic, Headers headers, Object data) {
        if (this.useRecordHeader) {
            MessageAndMetadata context = (MessageAndMetadata)this.messageAndMetadataAvroSerializer.serialize(data, this.createSchemaMetadata(topic));
            headers.add(this.isKey ? this.keySchemaVersionIdHeaderName : this.valueSchemaVersionIdHeaderName, context.metadata());
            return context.payload();
        }
        return this.serialize(topic, data);
    }

    private SchemaMetadata createSchemaMetadata(String topic) {
        SchemaMetadata schemaMetadata = this.getSchemaKey(topic, this.isKey);
        String description = "Schema registered by KafkaAvroSerializer for topic: [" + topic + "] iskey: [" + this.isKey + "]";
        return new SchemaMetadata.Builder(schemaMetadata).description(description).compatibility(this.compatibility).build();
    }

    public SchemaMetadata getSchemaKey(String topic, boolean isKey) {
        String name = topic;
        if (isKey) {
            if (this.schemaNameKeySuffix != null) {
                name = name + this.schemaNameKeySuffix;
            }
        } else if (this.schemaNameValueSuffix != null) {
            name = name + this.schemaNameValueSuffix;
        }
        return new SchemaMetadata.Builder(name).type("avro").schemaGroup(this.schemaGroup).build();
    }

    public void close() {
        try {
            Utils.closeAll(new AutoCloseable[]{this.avroSnapshotSerializer, this.messageAndMetadataAvroSerializer});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

