/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.webservice;

import com.google.common.base.Preconditions;
import com.hortonworks.registries.common.ha.LeadershipParticipant;
import com.hortonworks.registries.schemaregistry.ISchemaRegistry;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseRegistryResource {
    private static final Logger LOG = LoggerFactory.getLogger(BaseRegistryResource.class);
    final AtomicReference<LeadershipParticipant> leadershipParticipant;
    final ISchemaRegistry schemaRegistry;
    static final String OPERATION_GROUP_SCHEMA = "1. Schema";
    static final String OPERATION_GROUP_SERDE = "2. Serializer/Deserializer";
    static final String OPERATION_GROUP_OTHER = "3. Other";

    BaseRegistryResource(ISchemaRegistry schemaRegistry, AtomicReference<LeadershipParticipant> leadershipParticipant) {
        Preconditions.checkNotNull((Object)schemaRegistry, (Object)"SchemaRegistry can not be null");
        Preconditions.checkNotNull(leadershipParticipant, (Object)"LeadershipParticipant can not be null");
        this.schemaRegistry = schemaRegistry;
        this.leadershipParticipant = leadershipParticipant;
    }

    Response handleLeaderAction(UriInfo uriInfo, Supplier<Response> supplier) {
        LOG.info("URI info [{}]", (Object)uriInfo.getRequestUri());
        if (!this.leadershipParticipant.get().isLeader()) {
            URI location = null;
            try {
                String currentLeaderLoc = this.leadershipParticipant.get().getCurrentLeader();
                URI leaderServerUrl = new URI(currentLeaderLoc);
                URI requestUri = uriInfo.getRequestUri();
                location = new URI(leaderServerUrl.getScheme(), leaderServerUrl.getAuthority(), requestUri.getPath(), requestUri.getQuery(), requestUri.getFragment());
                LOG.info("Redirecting to URI [{}] as this instance is not the leader", (Object)location);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return Response.temporaryRedirect((URI)location).build();
        }
        LOG.info("Invoking here as this instance is the leader");
        return supplier.get();
    }

    static void checkValueAsNullOrEmpty(String name, String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Parameter " + name + " is null");
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Parameter " + name + " is empty");
        }
    }
}

