/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.webservice;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hortonworks.registries.common.catalog.CatalogResponse;
import com.hortonworks.registries.common.ha.LeadershipParticipant;
import com.hortonworks.registries.common.util.WSUtils;
import com.hortonworks.registries.schemaregistry.ISchemaRegistry;
import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.SchemaMetadata;
import com.hortonworks.registries.schemaregistry.SchemaMetadataInfo;
import com.hortonworks.registries.schemaregistry.SchemaVersion;
import com.hortonworks.registries.schemaregistry.SchemaVersionInfo;
import com.hortonworks.registries.schemaregistry.SchemaVersionKey;
import com.hortonworks.registries.schemaregistry.authorizer.agent.AuthorizationAgent;
import com.hortonworks.registries.schemaregistry.authorizer.core.Authorizer;
import com.hortonworks.registries.schemaregistry.authorizer.core.util.AuthorizationUtils;
import com.hortonworks.registries.schemaregistry.authorizer.exception.AuthorizationException;
import com.hortonworks.registries.schemaregistry.errors.IncompatibleSchemaException;
import com.hortonworks.registries.schemaregistry.errors.InvalidSchemaException;
import com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException;
import com.hortonworks.registries.schemaregistry.errors.UnsupportedSchemaTypeException;
import com.hortonworks.registries.schemaregistry.webservice.BaseRegistryResource;
import com.hortonworks.registries.storage.transaction.UnitOfWork;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/v1/confluent")
@Api(value="/api/v1/confluent", description="Endpoint for Confluent Schema Registry API compatible service")
@Produces(value={"application/json", "application/vnd.schemaregistry.v1+json"})
public class ConfluentSchemaRegistryCompatibleResource
extends BaseRegistryResource {
    private static final Logger LOG = LoggerFactory.getLogger(ConfluentSchemaRegistryCompatibleResource.class);
    private static final String OPERATION_GROUP_CONFLUENT_SR = "4. Confluent Schema Registry compatible API";
    private final AuthorizationAgent authorizationAgent;

    public ConfluentSchemaRegistryCompatibleResource(ISchemaRegistry schemaRegistry, AtomicReference<LeadershipParticipant> leadershipParticipant, AuthorizationAgent authorizationAgent) {
        super(schemaRegistry, leadershipParticipant);
        this.authorizationAgent = authorizationAgent;
    }

    @GET
    @Path(value="/schemas/ids/{id}")
    @ApiOperation(value="Get schema version by id", response=Schema.class, tags={"4. Confluent Schema Registry compatible API"})
    @Timed
    @UnitOfWork
    public Response getSchemaById(@ApiParam(value="schema version id", required=true) @PathParam(value="id") Long id, @Context SecurityContext securityContext) {
        Response response;
        try {
            SchemaVersionInfo schemaVersionInfo = this.schemaRegistry.getSchemaVersionInfo(new SchemaIdVersion(id));
            this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaVersionInfo, Authorizer.AccessType.READ);
            SchemaString schema = new SchemaString();
            schema.setSchema(schemaVersionInfo.getSchemaText());
            response = WSUtils.respondEntity((Object)schema, (Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException ex) {
            LOG.error("No schema version found with id [{}]", (Object)id, (Object)ex);
            response = ConfluentSchemaRegistryCompatibleResource.schemaNotFoundError();
        }
        catch (Exception ex) {
            LOG.error("Encountered error while retrieving Schema with id: [{}]", (Object)id, (Object)ex);
            response = ConfluentSchemaRegistryCompatibleResource.serverError();
        }
        return response;
    }

    @GET
    @Path(value="/subjects")
    @ApiOperation(value="Get all registered subjects", response=String.class, responseContainer="List", tags={"4. Confluent Schema Registry compatible API"})
    @Timed
    @UnitOfWork
    public Response getSubjects(@Context SecurityContext securityContext) {
        Response response;
        try {
            List registeredSubjects = this.authorizationAgent.authorizeFindSchemas(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry.findSchemaMetadata(Collections.emptyMap())).stream().map(x -> x.getSchemaMetadata().getName()).collect(Collectors.toList());
            response = WSUtils.respondEntity(registeredSubjects, (Response.Status)Response.Status.OK);
        }
        catch (Exception ex) {
            LOG.error("Encountered error while retrieving all subjects", (Throwable)ex);
            response = ConfluentSchemaRegistryCompatibleResource.serverError();
        }
        return response;
    }

    @GET
    @Path(value="/subjects/{subject}/versions")
    @ApiOperation(value="Get all schema versions of given subject", response=Integer.class, responseContainer="List", tags={"4. Confluent Schema Registry compatible API"})
    @Timed
    @UnitOfWork
    public Response getAllVersions(@ApiParam(value="subject", required=true) @PathParam(value="subject") String subject, @Context SecurityContext securityContext) {
        Response response;
        try {
            List registeredSubjects = this.authorizationAgent.authorizeGetAllVersions(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, this.schemaRegistry.getAllVersions(subject)).stream().map(SchemaVersionInfo::getVersion).collect(Collectors.toList());
            response = WSUtils.respondEntity(registeredSubjects, (Response.Status)Response.Status.OK);
        }
        catch (SchemaNotFoundException ex) {
            LOG.error("No schema found with subject [{}]", (Object)subject, (Object)ex);
            response = ConfluentSchemaRegistryCompatibleResource.subjectNotFoundError();
        }
        catch (Exception ex) {
            LOG.error("Encountered error while retrieving all subjects", (Throwable)ex);
            response = ConfluentSchemaRegistryCompatibleResource.serverError();
        }
        return response;
    }

    @GET
    @Path(value="/subjects/{subject}/versions/{versionId}")
    @ApiOperation(value="Get the schema information for given subject and versionId", response=Integer.class, responseContainer="List", tags={"4. Confluent Schema Registry compatible API"})
    @Timed
    @UnitOfWork
    public Response getSchemaVersion(@ApiParam(value="subject", required=true) @PathParam(value="subject") String subject, @ApiParam(value="versionId", required=true) @PathParam(value="versionId") String versionId, @Context SecurityContext securityContext) {
        Response response;
        try {
            SchemaVersionInfo schemaVersionInfo = null;
            SchemaMetadataInfo schemaMetadataInfo = this.schemaRegistry.getSchemaMetadataInfo(subject);
            if ("latest".equals(versionId)) {
                schemaVersionInfo = this.schemaRegistry.getLatestSchemaVersionInfo(subject);
            } else {
                if (schemaMetadataInfo == null) {
                    throw new SchemaNotFoundException();
                }
                SchemaVersionInfo fetchedSchemaVersionInfo = null;
                try {
                    Integer version = Integer.valueOf(versionId);
                    if (version > 0 && version <= Integer.MAX_VALUE) {
                        fetchedSchemaVersionInfo = this.schemaRegistry.getSchemaVersionInfo(new SchemaVersionKey(subject, version));
                    } else {
                        LOG.error("versionId is not in valid range [{}, {}] ", (Object)1, (Object)Integer.MAX_VALUE);
                    }
                }
                catch (NumberFormatException e) {
                    LOG.error("Invalid version id string ", (Object)versionId, (Object)e);
                }
                catch (SchemaNotFoundException e) {
                    LOG.error("Schema version not found with version id [{}]", (Object)versionId, (Object)e);
                }
                if (fetchedSchemaVersionInfo != null) {
                    if (subject.equals(fetchedSchemaVersionInfo.getName())) {
                        schemaVersionInfo = fetchedSchemaVersionInfo;
                    } else {
                        LOG.error("Received schema version for id [{}] belongs to subject [{}] which is different from requested subject [{}]", new Object[]{versionId, fetchedSchemaVersionInfo.getName(), subject});
                    }
                }
            }
            if (schemaVersionInfo == null) {
                response = ConfluentSchemaRegistryCompatibleResource.versionNotFoundError();
            } else {
                this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaVersionInfo, Authorizer.AccessType.READ);
                Schema schema = new Schema(schemaVersionInfo.getName(), schemaVersionInfo.getVersion(), schemaVersionInfo.getId(), schemaVersionInfo.getSchemaText());
                response = WSUtils.respondEntity((Object)schema, (Response.Status)Response.Status.OK);
            }
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException ex) {
            LOG.error("No schema found with subject [{}]", (Object)subject, (Object)ex);
            response = ConfluentSchemaRegistryCompatibleResource.subjectNotFoundError();
        }
        catch (Exception ex) {
            LOG.error("Encountered error while retrieving all subjects", (Throwable)ex);
            response = ConfluentSchemaRegistryCompatibleResource.serverError();
        }
        return response;
    }

    @POST
    @Path(value="/subjects/{subject}")
    @ApiOperation(value="Get schema information for the given schema subject and schema text", response=Schema.class, tags={"4. Confluent Schema Registry compatible API"})
    @Timed
    @UnitOfWork
    public Response lookupSubjectVersion(@ApiParam(value="Schema subject", required=true) @PathParam(value="subject") String subject, @ApiParam(value="The schema ", required=true) String schema, @Context SecurityContext securityContext) {
        Response response;
        try {
            SchemaVersionInfo schemaVersionInfo = this.schemaRegistry.getSchemaVersionInfo(subject, this.schemaStringFromJson(schema).getSchema());
            if (schemaVersionInfo != null) {
                this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaVersionInfo, Authorizer.AccessType.READ);
                response = WSUtils.respondEntity((Object)new Schema(schemaVersionInfo.getName(), schemaVersionInfo.getVersion(), schemaVersionInfo.getId(), schemaVersionInfo.getSchemaText()), (Response.Status)Response.Status.OK);
            } else {
                response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{subject});
            }
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (InvalidSchemaException ex) {
            LOG.error("Given schema is invalid", (Throwable)ex);
            response = ConfluentSchemaRegistryCompatibleResource.invalidSchemaError();
        }
        catch (SchemaNotFoundException ex) {
            LOG.error("No schema found with subject [{}]", (Object)subject, (Object)ex);
            response = ConfluentSchemaRegistryCompatibleResource.subjectNotFoundError();
        }
        catch (Exception ex) {
            LOG.error("Encountered error while retrieving schema version with subject: [{}]", (Object)subject, (Object)ex);
            response = ConfluentSchemaRegistryCompatibleResource.serverError();
        }
        return response;
    }

    @POST
    @Path(value="/subjects/{subject}/versions")
    @ApiOperation(value="Register a new version of the schema", notes="Registers the given schema version to schema with subject if the given schemaText is not registered as a version for this schema, and returns respective unique id.In case of incompatible schema errors, it throws error message like 'Unable to read schema: <> using schema <>' ", response=Id.class, tags={"4. Confluent Schema Registry compatible API"})
    @Timed
    @UnitOfWork
    public Response registerSchemaVersion(@ApiParam(value="subject", required=true) @PathParam(value="subject") String subject, @ApiParam(value="Details about the schema", required=true) String schema, @Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        LOG.info("registerSchema for [{}] is [{}]", (Object)subject);
        return this.handleLeaderAction(uriInfo, () -> {
            Response response;
            try {
                LOG.info("registerSchema for [{}] is [{}]", (Object)subject);
                SchemaMetadataInfo schemaMetadataInfo = this.schemaRegistry.getSchemaMetadataInfo(subject);
                if (schemaMetadataInfo == null) {
                    SchemaMetadata schemaMetadata = new SchemaMetadata.Builder(subject).type("avro").schemaGroup("Kafka").build();
                    this.authorizationAgent.authorizeSchemaMetadata(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), schemaMetadata, Authorizer.AccessType.CREATE);
                    this.schemaRegistry.addSchemaMetadata(schemaMetadata);
                    schemaMetadataInfo = this.schemaRegistry.getSchemaMetadataInfo(subject);
                }
                this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, subject, "MASTER", Authorizer.AccessType.CREATE);
                SchemaIdVersion schemaVersionInfo = this.schemaRegistry.addSchemaVersion(schemaMetadataInfo.getSchemaMetadata(), new SchemaVersion(this.schemaStringFromJson(schema).getSchema(), null));
                Id id = new Id();
                id.setId(schemaVersionInfo.getSchemaVersionId());
                response = WSUtils.respondEntity((Object)id, (Response.Status)Response.Status.OK);
            }
            catch (AuthorizationException e) {
                LOG.debug("Access denied. ", (Throwable)e);
                return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
            }
            catch (InvalidSchemaException ex) {
                LOG.error("Invalid schema error encountered while adding subject [{}]", (Object)subject, (Object)ex);
                response = ConfluentSchemaRegistryCompatibleResource.invalidSchemaError();
            }
            catch (IncompatibleSchemaException ex) {
                LOG.error("Incompatible schema error encountered while adding subject [{}]", (Object)subject, (Object)ex);
                response = ConfluentSchemaRegistryCompatibleResource.incompatibleSchemaError();
            }
            catch (UnsupportedSchemaTypeException ex) {
                LOG.error("Unsupported schema type encountered while adding subject [{}]", (Object)subject, (Object)ex);
                response = ConfluentSchemaRegistryCompatibleResource.incompatibleSchemaError();
            }
            catch (Exception ex) {
                LOG.error("Encountered error while adding subject [{}]", (Object)subject, (Object)ex);
                response = ConfluentSchemaRegistryCompatibleResource.serverError();
            }
            return response;
        });
    }

    public static Response serverError() {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorMessage(50001, "Error in the backend data store")).build();
    }

    public static Response subjectNotFoundError() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorMessage(40401, "Subject not found")).build();
    }

    public static Response versionNotFoundError() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorMessage(40402, "Version not found")).build();
    }

    public static Response schemaNotFoundError() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorMessage(40403, "Schema not found")).build();
    }

    public static Response invalidSchemaError() {
        return Response.status((int)422).entity((Object)new ErrorMessage(42201, "Invalid Avro schema")).build();
    }

    public static Response incompatibleSchemaError() {
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ErrorMessage(40901, "Incompatible Avro schema")).build();
    }

    private SchemaString schemaStringFromJson(String json) throws IOException {
        return (SchemaString)new ObjectMapper().readValue(json, SchemaString.class);
    }

    public static class Schema
    implements Comparable<Schema> {
        private String subject;
        private Integer version;
        private Long id;
        private String schema;

        public Schema(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version, @JsonProperty(value="id") Long id, @JsonProperty(value="schema") String schema) {
            this.subject = subject;
            this.version = version;
            this.id = id;
            this.schema = schema;
        }

        @JsonProperty(value="subject")
        public String getSubject() {
            return this.subject;
        }

        @JsonProperty(value="subject")
        public void setSubject(String subject) {
            this.subject = subject;
        }

        @JsonProperty(value="version")
        public Integer getVersion() {
            return this.version;
        }

        @JsonProperty(value="version")
        public void setVersion(Integer version) {
            this.version = version;
        }

        @JsonProperty(value="id")
        public Long getId() {
            return this.id;
        }

        @JsonProperty(value="id")
        public void setId(Long id) {
            this.id = id;
        }

        @JsonProperty(value="schema")
        public String getSchema() {
            return this.schema;
        }

        @JsonProperty(value="schema")
        public void setSchema(String schema) {
            this.schema = schema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                Schema that = (Schema)o;
                return this.subject.equals(that.subject) && this.version.equals(that.version) && this.id.equals(that.getId()) && this.schema.equals(that.schema);
            }
            return false;
        }

        public int hashCode() {
            int result = this.subject.hashCode();
            result = 31 * result + this.version;
            result = 31 * result + this.id.intValue();
            result = 31 * result + this.schema.hashCode();
            return result;
        }

        public String toString() {
            return "{subject=" + this.subject + "," + "version=" + this.version + ",id=" + this.id + ",schema=" + this.schema + "}";
        }

        @Override
        public int compareTo(Schema that) {
            int result = this.subject.compareTo(that.subject);
            if (result != 0) {
                return result;
            }
            result = this.version - that.version;
            return result;
        }
    }

    public static class Id {
        private long id;

        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @JsonProperty(value="id")
        public void setId(long id) {
            this.id = id;
        }
    }

    public static class SchemaString {
        private String schema;

        @JsonProperty(value="schema")
        public String getSchema() {
            return this.schema;
        }

        @JsonProperty(value="schema")
        public void setSchema(String schema) {
            this.schema = schema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                if (!super.equals(o)) {
                    return false;
                }
                SchemaString that = (SchemaString)o;
                return !(this.schema != null ? !this.schema.equals(that.schema) : that.schema != null);
            }
            return false;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "{schema=" + this.schema + "}";
        }
    }

    public static class ErrorMessage {
        private int errorCode;
        private String message;

        public ErrorMessage() {
        }

        public ErrorMessage(int errorCode, String message) {
            this.errorCode = errorCode;
            this.message = message;
        }

        @JsonProperty(value="error_code")
        public int getErrorCode() {
            return this.errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "ErrorMessage{errorCode=" + this.errorCode + ", message='" + this.message + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ErrorMessage that = (ErrorMessage)o;
            if (this.errorCode != that.errorCode) {
                return false;
            }
            return this.message != null ? this.message.equals(that.message) : that.message == null;
        }

        public int hashCode() {
            int result = this.errorCode;
            result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
            return result;
        }
    }
}

