/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.webservice;

import com.hortonworks.registries.common.ha.LeadershipParticipant;
import com.hortonworks.registries.webservice.RegistryApplication;
import com.hortonworks.registries.webservice.RegistryConfiguration;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import io.dropwizard.setup.Environment;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSchemaRegistryServer {
    private final LocalRegistryApplication registryApplication;

    public LocalSchemaRegistryServer(String configFilePath) {
        this.registryApplication = new LocalRegistryApplication(configFilePath);
    }

    public void start() throws Exception {
        this.registryApplication.start();
    }

    public void stop() throws Exception {
        this.registryApplication.stop();
    }

    public int getLocalPort() {
        return this.registryApplication.getLocalPort();
    }

    public int getAdminPort() {
        return this.registryApplication.getAdminPort();
    }

    public String getLocalURL() {
        return this.registryApplication.localServer.getURI().toString();
    }

    public boolean hasLeadership() {
        return this.registryApplication.hasLeadership();
    }

    private static final class LocalRegistryApplication
    extends RegistryApplication {
        private static final Logger LOG = LoggerFactory.getLogger(LocalRegistryApplication.class);
        private final String configFilePath;
        private volatile Server localServer;

        public LocalRegistryApplication(String configFilePath) {
            this.configFilePath = configFilePath;
        }

        public void run(RegistryConfiguration registryConfiguration, Environment environment) throws Exception {
            super.run(registryConfiguration, environment);
            environment.lifecycle().addServerLifecycleListener(new ServerLifecycleListener(){

                public void serverStarted(Server server) {
                    localServer = server;
                    LOG.info("Received callback as server is started :[{}]", (Object)server);
                }
            });
        }

        void start() throws Exception {
            if (this.localServer == null) {
                LOG.info("Local schema registry instance is getting started.");
                this.run(new String[]{"server", this.configFilePath});
                LOG.info("Local schema registry instance is started at port [{}]", (Object)this.getLocalPort());
            } else {
                LOG.info("Local schema registry instance is already started at port [{}]", (Object)this.getLocalPort());
            }
        }

        void stop() throws Exception {
            if (this.localServer != null) {
                this.localServer.stop();
                ((LeadershipParticipant)this.leadershipParticipantRef.get()).close();
                this.localServer = null;
                LOG.info("Local schema registry instance is stopped.");
            } else {
                LOG.info("No local schema registry instance is running to be stopped.");
            }
        }

        int getLocalPort() {
            return ((ServerConnector)this.localServer.getConnectors()[0]).getLocalPort();
        }

        int getAdminPort() {
            return ((ServerConnector)this.localServer.getConnectors()[1]).getLocalPort();
        }

        boolean hasLeadership() {
            return ((LeadershipParticipant)this.leadershipParticipantRef.get()).isLeader();
        }
    }
}

