/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.webservice;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteUriFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(RewriteUriFilter.class);
    private FilterConfig filterConfig;
    private Map<String, String> forwardPaths;
    private Map<String, String> redirectPaths;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.forwardPaths = this.buildRewritePathsMap(filterConfig.getInitParameter("forwardPaths"));
        this.redirectPaths = this.buildRewritePathsMap(filterConfig.getInitParameter("redirectPaths"));
    }

    private Map<String, String> buildRewritePathsMap(String pathsStr) {
        if (pathsStr == null || pathsStr.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> pathsMapper = new LinkedHashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(pathsStr, "|");
        while (tokenizer.hasMoreTokens()) {
            StringTokenizer st = new StringTokenizer(tokenizer.nextToken(), ",");
            ArrayList<String> configPaths = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                configPaths.add(st.nextToken());
            }
            String targetPath = (String)configPaths.remove(0);
            configPaths.forEach(x -> pathsMapper.put((String)x, targetPath));
        }
        return pathsMapper;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.handleRewriteUris(servletRequest, servletResponse)) {
            LOG.debug("No rewrite or forward path found, ");
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private boolean handleRewriteUris(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        String reqPath = ((HttpServletRequest)servletRequest).getRequestURI();
        String redirectPath = this.findRewritePath(reqPath, this.redirectPaths);
        LOG.debug("request path [{}], redirectPath [{}]", (Object)reqPath, (Object)redirectPath);
        if (redirectPath != null) {
            LOG.info("Redirecting request [{}] to [{}]", (Object)servletRequest, (Object)redirectPath);
            ((HttpServletResponse)servletResponse).sendRedirect(redirectPath);
            return true;
        }
        String forwardPath = this.findRewritePath(reqPath, this.forwardPaths);
        LOG.debug("request path [{}], forwardPath [{}]", (Object)reqPath, (Object)forwardPath);
        if (forwardPath != null) {
            LOG.info("Forwarding request [{}] to [{}]", (Object)servletRequest, (Object)forwardPath);
            servletRequest.getRequestDispatcher(forwardPath + reqPath).forward(servletRequest, servletResponse);
            return true;
        }
        return false;
    }

    private String findRewritePath(String reqPath, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String path = entry.getKey();
            if (!this.matchesPath(reqPath, path)) continue;
            return entry.getValue();
        }
        return null;
    }

    private boolean matchesPath(String reqPath, String path) {
        char lastChar = path.charAt(path.length() - 1);
        if (lastChar == '*') {
            int lastIdx = path.length() - 1;
            if (path.length() > 2 && path.charAt(path.length() - 2) == '/') {
                lastIdx = path.length() - 2;
            }
            return reqPath.startsWith(path.substring(0, lastIdx));
        }
        return reqPath.equals(path);
    }

    public void destroy() {
    }
}

