/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.webservice;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.hortonworks.registries.common.ModuleRegistration;
import com.hortonworks.registries.common.SchemaRegistryServiceInfo;
import com.hortonworks.registries.common.SchemaRegistryVersion;
import com.hortonworks.registries.common.ha.LeadershipAware;
import com.hortonworks.registries.common.ha.LeadershipParticipant;
import com.hortonworks.registries.common.util.FileStorage;
import com.hortonworks.registries.schemaregistry.DefaultSchemaRegistry;
import com.hortonworks.registries.schemaregistry.HAServerNotificationManager;
import com.hortonworks.registries.schemaregistry.HAServersAware;
import com.hortonworks.registries.schemaregistry.ISchemaRegistry;
import com.hortonworks.registries.schemaregistry.SchemaProvider;
import com.hortonworks.registries.schemaregistry.authorizer.agent.AuthorizationAgent;
import com.hortonworks.registries.schemaregistry.authorizer.agent.AuthorizationAgentFactory;
import com.hortonworks.registries.schemaregistry.locks.SchemaLockManager;
import com.hortonworks.registries.schemaregistry.webservice.ConfluentSchemaRegistryCompatibleResource;
import com.hortonworks.registries.schemaregistry.webservice.SchemaRegistryResource;
import com.hortonworks.registries.schemaregistry.webservice.validator.JarInputStreamValidator;
import com.hortonworks.registries.storage.StorageManager;
import com.hortonworks.registries.storage.StorageManagerAware;
import com.hortonworks.registries.storage.TransactionManager;
import com.hortonworks.registries.storage.TransactionManagerAware;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryModule
implements ModuleRegistration,
StorageManagerAware,
LeadershipAware,
HAServersAware,
TransactionManagerAware {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaRegistryModule.class);
    private Map<String, Object> config;
    private FileStorage fileStorage;
    private StorageManager storageManager;
    private TransactionManager transactionManager;
    private HAServerNotificationManager haServerNotificationManager;
    private AtomicReference<LeadershipParticipant> leadershipParticipant;

    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    public void init(Map<String, Object> config, FileStorage fileStorage) {
        this.config = config;
        this.fileStorage = fileStorage;
    }

    public List<Object> getResources() {
        Collection schemaProviders = (Collection)this.config.get("schemaProviders");
        DefaultSchemaRegistry schemaRegistry = new DefaultSchemaRegistry(this.storageManager, this.fileStorage, schemaProviders, this.haServerNotificationManager, new SchemaLockManager(this.transactionManager));
        schemaRegistry.init(this.config);
        SchemaRegistryVersion schemaRegistryVersion = SchemaRegistryServiceInfo.get().version();
        LOG.info("SchemaRegistry is starting with {}", (Object)schemaRegistryVersion);
        Map authorizationProps = (Map)this.config.get("authorization");
        AuthorizationAgent authorizationAgent = AuthorizationAgentFactory.getAuthorizationAgent((Map)authorizationProps);
        SchemaRegistryResource schemaRegistryResource = new SchemaRegistryResource((ISchemaRegistry)schemaRegistry, this.leadershipParticipant, schemaRegistryVersion, authorizationAgent, new JarInputStreamValidator());
        ConfluentSchemaRegistryCompatibleResource confluentSchemaRegistryResource = new ConfluentSchemaRegistryCompatibleResource((ISchemaRegistry)schemaRegistry, this.leadershipParticipant, authorizationAgent);
        return Arrays.asList(schemaRegistryResource, confluentSchemaRegistryResource);
    }

    private Collection<? extends SchemaProvider> getSchemaProviders() {
        Collection schemaProviders = (Collection)this.config.get("schemaProviders");
        if (schemaProviders == null || schemaProviders.isEmpty()) {
            throw new IllegalArgumentException("No [schemaProviders] property is configured in schema registry configuration file.");
        }
        return Collections2.transform((Collection)schemaProviders, (Function)new Function<Map<String, Object>, SchemaProvider>(){

            @Nullable
            public SchemaProvider apply(@Nullable Map<String, Object> schemaProviderConfig) {
                String className = (String)schemaProviderConfig.get("providerClass");
                if (className == null || className.isEmpty()) {
                    throw new IllegalArgumentException("Schema provider class name must be non empty, Invalid provider class name [" + className + "]");
                }
                try {
                    SchemaProvider schemaProvider = (SchemaProvider)Class.forName(className, true, Thread.currentThread().getContextClassLoader()).newInstance();
                    schemaProvider.init(schemaProviderConfig);
                    return schemaProvider;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    LOG.error("Error encountered while loading SchemaProvider [{}] ", (Object)className, (Object)e);
                    throw new IllegalArgumentException(e);
                }
            }
        });
    }

    public void setLeadershipParticipant(AtomicReference<LeadershipParticipant> leadershipParticipant) {
        Preconditions.checkState((this.leadershipParticipant == null ? 1 : 0) != 0, (Object)("leadershipParticipant " + leadershipParticipant + " is already set!!"));
        this.leadershipParticipant = leadershipParticipant;
    }

    public void setHAServerConfigManager(HAServerNotificationManager haServerNotificationManager) {
        this.haServerNotificationManager = haServerNotificationManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

