/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.webservice;

import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.hortonworks.registries.common.SchemaRegistryVersion;
import com.hortonworks.registries.common.catalog.CatalogResponse;
import com.hortonworks.registries.common.ha.LeadershipParticipant;
import com.hortonworks.registries.common.util.WSUtils;
import com.hortonworks.registries.schemaregistry.AggregatedSchemaMetadataInfo;
import com.hortonworks.registries.schemaregistry.CompatibilityResult;
import com.hortonworks.registries.schemaregistry.ISchemaRegistry;
import com.hortonworks.registries.schemaregistry.SchemaBranch;
import com.hortonworks.registries.schemaregistry.SchemaFieldQuery;
import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.SchemaMetadata;
import com.hortonworks.registries.schemaregistry.SchemaMetadataInfo;
import com.hortonworks.registries.schemaregistry.SchemaProviderInfo;
import com.hortonworks.registries.schemaregistry.SchemaVersion;
import com.hortonworks.registries.schemaregistry.SchemaVersionInfo;
import com.hortonworks.registries.schemaregistry.SchemaVersionKey;
import com.hortonworks.registries.schemaregistry.SchemaVersionMergeResult;
import com.hortonworks.registries.schemaregistry.SerDesInfo;
import com.hortonworks.registries.schemaregistry.SerDesPair;
import com.hortonworks.registries.schemaregistry.authorizer.agent.AuthorizationAgent;
import com.hortonworks.registries.schemaregistry.authorizer.core.Authorizer;
import com.hortonworks.registries.schemaregistry.authorizer.core.util.AuthorizationUtils;
import com.hortonworks.registries.schemaregistry.authorizer.exception.AuthorizationException;
import com.hortonworks.registries.schemaregistry.cache.SchemaRegistryCacheType;
import com.hortonworks.registries.schemaregistry.errors.IncompatibleSchemaException;
import com.hortonworks.registries.schemaregistry.errors.InvalidSchemaBranchDeletionException;
import com.hortonworks.registries.schemaregistry.errors.InvalidSchemaException;
import com.hortonworks.registries.schemaregistry.errors.SchemaBranchAlreadyExistsException;
import com.hortonworks.registries.schemaregistry.errors.SchemaBranchNotFoundException;
import com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException;
import com.hortonworks.registries.schemaregistry.errors.UnsupportedSchemaTypeException;
import com.hortonworks.registries.schemaregistry.state.SchemaLifecycleException;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStateMachineInfo;
import com.hortonworks.registries.schemaregistry.webservice.BaseRegistryResource;
import com.hortonworks.registries.schemaregistry.webservice.validator.JarInputStreamValidator;
import com.hortonworks.registries.schemaregistry.webservice.validator.exception.InvalidJarFileException;
import com.hortonworks.registries.storage.exception.StorageException;
import com.hortonworks.registries.storage.search.OrderBy;
import com.hortonworks.registries.storage.search.WhereClause;
import com.hortonworks.registries.storage.search.WhereClauseCombiner;
import com.hortonworks.registries.storage.transaction.UnitOfWork;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/v1/schemaregistry")
@Api(value="/api/v1/schemaregistry", description="Endpoint for Schema Registry service")
@Produces(value={"application/json"})
public class SchemaRegistryResource
extends BaseRegistryResource {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaRegistryResource.class);
    public static final String THROW_ERROR_IF_EXISTS = "_throwErrorIfExists";
    public static final String THROW_ERROR_IF_EXISTS_LOWER_CASE = "_throwErrorIfExists".toLowerCase();
    private static final String[] reservedNames = new String[]{"aggregate", "versions", "compatibility"};
    private final SchemaRegistryVersion schemaRegistryVersion;
    private final AuthorizationAgent authorizationAgent;
    private final JarInputStreamValidator jarInputStreamValidator;

    public SchemaRegistryResource(ISchemaRegistry schemaRegistry, AtomicReference<LeadershipParticipant> leadershipParticipant, SchemaRegistryVersion schemaRegistryVersion, AuthorizationAgent authorizationAgent, JarInputStreamValidator jarInputStreamValidator) {
        super(schemaRegistry, leadershipParticipant);
        this.schemaRegistryVersion = schemaRegistryVersion;
        this.authorizationAgent = authorizationAgent;
        this.jarInputStreamValidator = jarInputStreamValidator;
    }

    @GET
    @Path(value="/version")
    @ApiOperation(value="Get the version information of this Schema Registry instance", response=SchemaRegistryVersion.class, tags={"3. Other"})
    @Timed
    public Response getVersion(@Context UriInfo uriInfo) {
        return WSUtils.respondEntity((Object)this.schemaRegistryVersion, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="/schemaproviders")
    @ApiOperation(value="Get list of registered Schema Providers", notes="The Schema Registry supports different types of schemas, such as Avro, JSON etc. A Schema Provider is needed for each type of schema supported by the Schema Registry. Schema Provider supports defining schema, serializing and deserializing data using the schema,  and checking compatibility between different versions of the schema.", response=SchemaProviderInfo.class, responseContainer="List", tags={"3. Other"})
    @Timed
    public Response getRegisteredSchemaProviderInfos(@Context UriInfo uriInfo) {
        try {
            Collection schemaProviderInfos = this.schemaRegistry.getSupportedSchemaProviders();
            return WSUtils.respondEntities((Collection)schemaProviderInfos, (Response.Status)Response.Status.OK);
        }
        catch (Exception ex) {
            LOG.error("Encountered error while listing schemas", (Throwable)ex);
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
    }

    @GET
    @Path(value="/schemas/aggregated")
    @ApiOperation(value="Get list of schemas by filtering with the given query parameters", response=AggregatedSchemaMetadataInfo.class, responseContainer="List", tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response listAggregatedSchemas(@QueryParam(value="name") String schemaName, @QueryParam(value="description") String schemaDescription, @ApiParam(value="_orderByFields=[<field-name>,<a/d>,]*\na = ascending, d = descending\nOrdering can be by id, type, schemaGroup, name, compatibility, validationLevel, timestamp, description, evolve") @QueryParam(value="_orderByFields") @DefaultValue(value="timestamp,d") String orderByFields, @QueryParam(value="id") String id, @QueryParam(value="type") String type, @QueryParam(value="schemaGroup") String schemaGroup, @QueryParam(value="validationLevel") String validationLevel, @QueryParam(value="compatibility") String compatibility, @QueryParam(value="evolve") String evolve, @Context SecurityContext securityContext) {
        try {
            Map<String, String> filters = this.createFilterForSchema(Optional.ofNullable(schemaName), Optional.ofNullable(schemaDescription), Optional.ofNullable(orderByFields), Optional.ofNullable(id), Optional.ofNullable(type), Optional.ofNullable(schemaGroup), Optional.ofNullable(validationLevel), Optional.ofNullable(compatibility), Optional.ofNullable(evolve));
            Collection schemaMetadatas = this.authorizationAgent.authorizeGetAggregatedSchemaList(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry.findAggregatedSchemaMetadata(filters));
            return WSUtils.respondEntities((Collection)schemaMetadatas, (Response.Status)Response.Status.OK);
        }
        catch (SchemaBranchNotFoundException e) {
            return WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while listing schemas", (Throwable)ex);
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
    }

    @GET
    @Path(value="/schemas/{name}/aggregated")
    @ApiOperation(value="Get aggregated schema information for the given schema name", response=SchemaMetadataInfo.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response getAggregatedSchemaInfo(@ApiParam(value="Schema name", required=true) @PathParam(value="name") String schemaName, @Context SecurityContext securityContext) {
        Response response;
        try {
            AggregatedSchemaMetadataInfo schemaMetadataInfo = this.schemaRegistry.getAggregatedSchemaMetadataInfo(schemaName);
            if (schemaMetadataInfo != null) {
                schemaMetadataInfo = this.authorizationAgent.authorizeGetAggregatedSchemaInfo(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), schemaMetadataInfo);
                response = WSUtils.respondEntity((Object)schemaMetadataInfo, (Response.Status)Response.Status.OK);
            } else {
                response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaName});
            }
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaBranchNotFoundException e) {
            return WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while retrieving SchemaInfo with name: [{}]", (Object)schemaName, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @GET
    @Path(value="/schemas")
    @ApiOperation(value="Get list of schemas by filtering with the given query parameters", response=SchemaMetadataInfo.class, responseContainer="List", tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response listSchemas(@QueryParam(value="name") String schemaName, @QueryParam(value="description") String schemaDescription, @ApiParam(value="_orderByFields=[<field-name>,<a/d>,]*\na = ascending, d = descending\nOrdering can be by id, type, schemaGroup, name, compatibility, validationLevel, timestamp, description, evolve") @QueryParam(value="_orderByFields") @DefaultValue(value="timestamp,d") String orderByFields, @QueryParam(value="id") String id, @QueryParam(value="type") String type, @QueryParam(value="schemaGroup") String schemaGroup, @QueryParam(value="validationLevel") String validationLevel, @QueryParam(value="compatibility") String compatibility, @QueryParam(value="evolve") String evolve, @Context SecurityContext securityContext) {
        try {
            Map<String, String> filters = this.createFilterForSchema(Optional.ofNullable(schemaName), Optional.ofNullable(schemaDescription), Optional.ofNullable(orderByFields), Optional.ofNullable(id), Optional.ofNullable(type), Optional.ofNullable(schemaGroup), Optional.ofNullable(validationLevel), Optional.ofNullable(compatibility), Optional.ofNullable(evolve));
            Collection schemaMetadatas = this.authorizationAgent.authorizeFindSchemas(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry.findSchemaMetadata(filters));
            return WSUtils.respondEntities((Collection)schemaMetadatas, (Response.Status)Response.Status.OK);
        }
        catch (Exception ex) {
            LOG.error("Encountered error while listing schemas", (Throwable)ex);
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
    }

    @VisibleForTesting
    Map<String, String> createFilterForSchema(Optional<String> name, Optional<String> description, Optional<String> orderByFields, Optional<String> id, Optional<String> type, Optional<String> schemaGroup, Optional<String> validationLevel, Optional<String> compatibility, Optional<String> evolve) {
        HashMap<String, String> filters = new HashMap<String, String>();
        name.ifPresent(n -> filters.put("name", (String)n));
        description.ifPresent(d -> filters.put("description", (String)d));
        orderByFields.ifPresent(o -> filters.put("_orderByFields", (String)o));
        id.ifPresent(i -> filters.put("id", (String)i));
        type.ifPresent(t -> filters.put("type", (String)t));
        schemaGroup.ifPresent(s -> filters.put("schemaGroup", (String)s));
        validationLevel.ifPresent(v -> filters.put("validationLevel", (String)v));
        compatibility.ifPresent(c -> filters.put("compatibility", (String)c));
        evolve.ifPresent(e -> filters.put("evolve", (String)e));
        return filters;
    }

    @VisibleForTesting
    Map<String, String> createFilterForNamespace(Optional<String> name, Optional<String> fieldNamespace, Optional<String> type) {
        HashMap<String, String> filters = new HashMap<String, String>();
        name.ifPresent(n -> filters.put("name", (String)n));
        fieldNamespace.ifPresent(f -> filters.put("fieldNamespace", (String)f));
        type.ifPresent(t -> filters.put("type", (String)t));
        return filters;
    }

    @GET
    @Path(value="/search/schemas")
    @ApiOperation(value="Search for schemas containing the given name and description", notes="Search the schemas for given name and description, return a list of schemas that contain the field.", response=SchemaMetadataInfo.class, responseContainer="List", tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response findSchemas(@ApiParam(required=true) @NotNull @QueryParam(value="name") String schemaName, @QueryParam(value="description") String schemaDescription, @ApiParam(value="_orderByFields=[<field-name>,<a/d>,]*\na = ascending, d = descending\nOrdering can be by id, type, schemaGroup, name, compatibility, validationLevel, timestamp, description, evolve\nRecommended value is: timestamp,d", required=true) @NotNull @QueryParam(value="_orderByFields") String orderByFields, @Context SecurityContext securityContext) {
        MultivaluedHashMap queryParameters = new MultivaluedHashMap();
        for (Map.Entry<String, String> entry : this.createFilterForSchema(Optional.ofNullable(schemaName), Optional.ofNullable(schemaDescription), Optional.ofNullable(orderByFields), Optional.ofNullable(null), Optional.ofNullable(null), Optional.ofNullable(null), Optional.ofNullable(null), Optional.ofNullable(null), Optional.ofNullable(null)).entrySet()) {
            queryParameters.add((Object)entry.getKey(), (Object)entry.getValue());
        }
        try {
            Collection schemaMetadataInfos = this.authorizationAgent.authorizeFindSchemas(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.findSchemaMetadataInfos((MultivaluedMap<String, String>)queryParameters));
            return WSUtils.respondEntities((Collection)schemaMetadataInfos, (Response.Status)Response.Status.OK);
        }
        catch (Exception ex) {
            LOG.error("Encountered error while finding schemas for given fields [{}]", (Object)queryParameters, (Object)ex);
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
    }

    @VisibleForTesting
    Collection<SchemaMetadataInfo> findSchemaMetadataInfos(MultivaluedMap<String, String> queryParameters) {
        Collection<Object> schemaMetadataInfos;
        if (queryParameters.containsKey((Object)"name") || queryParameters.containsKey((Object)"description")) {
            WhereClause whereClause = this.getWhereClause(queryParameters);
            String orderByFieldStr = (String)queryParameters.getFirst((Object)"_orderByFields");
            schemaMetadataInfos = this.schemaRegistry.searchSchemas(whereClause, this.getOrderByFields(orderByFieldStr));
        } else {
            schemaMetadataInfos = Collections.emptyList();
        }
        return schemaMetadataInfos;
    }

    @VisibleForTesting
    WhereClause getWhereClause(MultivaluedMap<String, String> queryParameters) {
        String name = (String)queryParameters.getFirst((Object)"name");
        WhereClauseCombiner whereClauseCombiner = WhereClause.begin().contains("name", (Object)name);
        String description = (String)queryParameters.getFirst((Object)"description");
        if (StringUtils.isNotBlank((CharSequence)description)) {
            whereClauseCombiner = whereClauseCombiner.or().contains("description", (Object)description);
        }
        return whereClauseCombiner.combine();
    }

    private List<OrderBy> getOrderByFields(String value) {
        ArrayList<OrderBy> orderByList = new ArrayList<OrderBy>();
        String[] splitStrings = value.split(",");
        for (int i = 0; i < splitStrings.length; i += 2) {
            boolean descending;
            String ascStr = splitStrings[i + 1];
            if ("a".equals(ascStr)) {
                descending = false;
            } else if ("d".equals(ascStr)) {
                descending = true;
            } else {
                throw new IllegalArgumentException("Ascending or Descending identifier can only be 'a' or 'd' respectively.");
            }
            String fieldName = splitStrings[i];
            orderByList.add(descending ? OrderBy.desc((String)fieldName) : OrderBy.asc((String)fieldName));
        }
        return orderByList;
    }

    @GET
    @Path(value="/search/schemas/aggregated")
    @ApiOperation(value="Search for schemas containing the given name and description", notes="Search the schemas for given name and description, return a list of schemas that contain the field.", response=AggregatedSchemaMetadataInfo.class, responseContainer="List", tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response findAggregatedSchemas(@ApiParam(value="name of the schema", required=true) @NotNull @QueryParam(value="name") @DefaultValue(value="") String schemaName, @QueryParam(value="description") String schemaDescription, @QueryParam(value="_orderByFields") @ApiParam(required=true) @NotNull @DefaultValue(value="timestamp,d") String orderByFields, @Context SecurityContext securityContext) {
        MultivaluedHashMap queryParameters = new MultivaluedHashMap();
        for (Map.Entry<String, String> entry : this.createFilterForSchema(Optional.ofNullable(schemaName), Optional.ofNullable(schemaDescription), Optional.ofNullable(orderByFields), Optional.ofNullable(null), Optional.ofNullable(null), Optional.ofNullable(null), Optional.ofNullable(null), Optional.ofNullable(null), Optional.ofNullable(null)).entrySet()) {
            queryParameters.add((Object)entry.getKey(), (Object)entry.getValue());
        }
        try {
            Collection<SchemaMetadataInfo> schemaMetadataInfos = this.findSchemaMetadataInfos((MultivaluedMap<String, String>)queryParameters);
            ArrayList<AggregatedSchemaMetadataInfo> aggregatedSchemaMetadataInfos = new ArrayList<AggregatedSchemaMetadataInfo>();
            for (SchemaMetadataInfo schemaMetadataInfo : schemaMetadataInfos) {
                SchemaMetadata schemaMetadata = schemaMetadataInfo.getSchemaMetadata();
                ArrayList serDesInfos = new ArrayList(this.schemaRegistry.getSerDes(schemaMetadataInfo.getSchemaMetadata().getName()));
                aggregatedSchemaMetadataInfos.add(new AggregatedSchemaMetadataInfo(schemaMetadata, schemaMetadataInfo.getId(), schemaMetadataInfo.getTimestamp(), this.schemaRegistry.getAggregatedSchemaBranch(schemaMetadata.getName()), serDesInfos));
            }
            return WSUtils.respondEntities((Collection)this.authorizationAgent.authorizeGetAggregatedSchemaList(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), aggregatedSchemaMetadataInfos), (Response.Status)Response.Status.OK);
        }
        catch (SchemaBranchNotFoundException e) {
            return WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while finding schemas for given fields [{}]", (Object)queryParameters, (Object)ex);
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
    }

    @GET
    @Path(value="/search/schemas/fields")
    @ApiOperation(value="Search for schemas containing the given field names", notes="Search the schemas for given field names and return a list of schemas that contain the field.\nIf no parameter added, returns all schemas as many times as they have fields.", response=SchemaVersionKey.class, responseContainer="List", tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response findSchemasByFields(@QueryParam(value="name") String name, @QueryParam(value="fieldNamespace") String nameSpace, @QueryParam(value="type") String type, @Context SecurityContext securityContext) {
        MultivaluedHashMap queryParameters = new MultivaluedHashMap();
        for (Map.Entry<String, String> entry : this.createFilterForNamespace(Optional.ofNullable(name), Optional.ofNullable(nameSpace), Optional.ofNullable(type)).entrySet()) {
            queryParameters.add((Object)entry.getKey(), (Object)entry.getValue());
        }
        try {
            Collection schemaVersionKeys = this.authorizationAgent.authorizeFindSchemasByFields(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, this.schemaRegistry.findSchemasByFields(this.buildSchemaFieldQuery((MultivaluedMap<String, String>)queryParameters)));
            return WSUtils.respondEntities((Collection)schemaVersionKeys, (Response.Status)Response.Status.OK);
        }
        catch (Exception ex) {
            LOG.error("Encountered error while finding schemas for given fields [{}]", (Object)queryParameters, (Object)ex);
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
    }

    @VisibleForTesting
    SchemaFieldQuery buildSchemaFieldQuery(MultivaluedMap<String, String> queryParameters) {
        SchemaFieldQuery.Builder builder = new SchemaFieldQuery.Builder();
        for (Map.Entry entry : queryParameters.entrySet()) {
            List entryValue = (List)entry.getValue();
            String value = entryValue != null && !entryValue.isEmpty() ? (String)entryValue.get(0) : null;
            if (value == null) continue;
            if ("fieldNamespace".equals(entry.getKey())) {
                builder.namespace(value);
                continue;
            }
            if ("name".equals(entry.getKey())) {
                builder.name(value);
                continue;
            }
            if (!"type".equals(entry.getKey())) continue;
            builder.type(value);
        }
        return builder.build();
    }

    @POST
    @Path(value="/schemas")
    @ApiOperation(value="Create a schema if it does not already exist", notes="Creates a schema with the given schema information if it does not already exist. A unique schema identifier is returned.", response=Long.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response addSchemaInfo(@ApiParam(value="Schema to be added to the registry", required=true) SchemaMetadata schemaMetadata, @Context UriInfo uriInfo, @Context HttpHeaders httpHeaders, @Context SecurityContext securityContext) {
        return this.handleLeaderAction(uriInfo, () -> {
            Response response;
            try {
                schemaMetadata.trim();
                SchemaRegistryResource.checkValueAsNullOrEmpty("Schema name", schemaMetadata.getName());
                SchemaRegistryResource.checkValueAsNullOrEmpty("Schema type", schemaMetadata.getType());
                this.checkValidNames(schemaMetadata.getName());
                boolean throwErrorIfExists = this.isThrowErrorIfExists(httpHeaders);
                this.authorizationAgent.authorizeSchemaMetadata(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), schemaMetadata, Authorizer.AccessType.CREATE);
                Long schemaId = this.schemaRegistry.addSchemaMetadata(schemaMetadata, throwErrorIfExists);
                response = WSUtils.respondEntity((Object)schemaId, (Response.Status)Response.Status.CREATED);
            }
            catch (AuthorizationException e) {
                LOG.debug("Access denied. ", (Throwable)e);
                return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
            }
            catch (IllegalArgumentException ex) {
                LOG.error("Expected parameter is invalid", (Object)schemaMetadata, (Object)ex);
                response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.BAD_REQUEST_PARAM_MISSING, (String[])new String[]{ex.getMessage()});
            }
            catch (UnsupportedSchemaTypeException ex) {
                LOG.error("Unsupported schema type encountered while adding schema metadata [{}]", (Object)schemaMetadata, (Object)ex);
                response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.UNSUPPORTED_SCHEMA_TYPE, (String[])new String[]{ex.getMessage()});
            }
            catch (StorageException ex) {
                LOG.error("Unable to add schema metadata [{}]", (Object)schemaMetadata, (Object)ex);
                response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_CONFLICT, (String[])new String[]{ex.getMessage()});
            }
            catch (Exception ex) {
                LOG.error("Error encountered while adding schema info [{}] ", (Object)schemaMetadata, (Object)ex);
                response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{String.format("Storing the given SchemaMetadata [%s] is failed", schemaMetadata.toString())});
            }
            return response;
        });
    }

    @POST
    @Path(value="/schemas/{name}")
    @ApiOperation(value="Updates schema information for the given schema name", response=SchemaMetadataInfo.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response updateSchemaInfo(@ApiParam(value="Schema name", required=true) @PathParam(value="name") String schemaName, @ApiParam(value="Schema to be added to the registry\nType of schema can be e.g. AVRO, JSON\nName should be the same as in body\nGroup of schema can be e.g. kafka, hive", required=true) SchemaMetadata schemaMetadata, @Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        return this.handleLeaderAction(uriInfo, () -> {
            Response response;
            try {
                this.authorizationAgent.authorizeSchemaMetadata(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaName, Authorizer.AccessType.UPDATE);
                SchemaMetadataInfo schemaMetadataInfo = this.schemaRegistry.updateSchemaMetadata(schemaName, schemaMetadata);
                response = schemaMetadataInfo != null ? WSUtils.respondEntity((Object)schemaMetadataInfo, (Response.Status)Response.Status.OK) : WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaName});
            }
            catch (AuthorizationException e) {
                LOG.debug("Access denied. ", (Throwable)e);
                return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
            }
            catch (IllegalArgumentException ex) {
                LOG.error("Expected parameter is invalid", new Object[]{schemaName, schemaMetadata, ex});
                response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.BAD_REQUEST_PARAM_MISSING, (String[])new String[]{ex.getMessage()});
            }
            catch (Exception ex) {
                LOG.error("Encountered error while retrieving SchemaInfo with name: [{}]", (Object)schemaName, (Object)ex);
                response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
            }
            return response;
        });
    }

    private void checkValidNames(String name) {
        for (String reservedName : reservedNames) {
            if (!reservedName.equalsIgnoreCase(name)) continue;
            throw new IllegalArgumentException("schema name [" + reservedName + "] is reserved");
        }
    }

    private boolean isThrowErrorIfExists(HttpHeaders httpHeaders) {
        List values = httpHeaders.getRequestHeader(THROW_ERROR_IF_EXISTS);
        if (values != null) {
            values = httpHeaders.getRequestHeader(THROW_ERROR_IF_EXISTS_LOWER_CASE);
        }
        return values != null && !values.isEmpty() && Boolean.parseBoolean((String)values.get(0));
    }

    @GET
    @Path(value="/schemas/{name}")
    @ApiOperation(value="Get schema information for the given schema name", response=SchemaMetadataInfo.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response getSchemaInfo(@ApiParam(value="Schema name", required=true) @PathParam(value="name") String schemaName, @Context SecurityContext securityContext) {
        Response response;
        try {
            SchemaMetadataInfo schemaMetadataInfo = this.schemaRegistry.getSchemaMetadataInfo(schemaName);
            if (schemaMetadataInfo != null) {
                this.authorizationAgent.authorizeSchemaMetadata(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), schemaMetadataInfo, Authorizer.AccessType.READ);
                response = WSUtils.respondEntity((Object)schemaMetadataInfo, (Response.Status)Response.Status.OK);
            } else {
                response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaName});
            }
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while retrieving SchemaInfo with name: [{}]", (Object)schemaName, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @GET
    @Path(value="/schemasById/{schemaId}")
    @ApiOperation(value="Get schema information for a given schema identifier", response=SchemaMetadataInfo.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response getSchemaInfo(@ApiParam(value="Schema identifier", required=true) @PathParam(value="schemaId") Long schemaId, @Context SecurityContext securityContext) {
        Response response;
        try {
            SchemaMetadataInfo schemaMetadataInfo = this.schemaRegistry.getSchemaMetadataInfo(schemaId);
            if (schemaMetadataInfo != null) {
                this.authorizationAgent.authorizeSchemaMetadata(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), schemaMetadataInfo, Authorizer.AccessType.READ);
                response = WSUtils.respondEntity((Object)schemaMetadataInfo, (Response.Status)Response.Status.OK);
            } else {
                response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaId.toString()});
            }
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while retrieving SchemaInfo with schemaId: [{}]", (Object)schemaId, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @DELETE
    @Path(value="/schemas/{name}")
    @ApiOperation(value="Delete a schema metadata and all related data", tags={"1. Schema"})
    @UnitOfWork
    public Response deleteSchemaMetadata(@ApiParam(value="Schema name", required=true) @PathParam(value="name") String schemaName, @Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        try {
            this.authorizationAgent.authorizeDeleteSchemaMetadata(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaName);
            this.schemaRegistry.deleteSchema(schemaName);
            return WSUtils.respond((Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException e) {
            LOG.error("No schema metadata found with name: [{}]", (Object)schemaName);
            return WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaName});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while deleting schema with name: [{}]", (Object)schemaName, (Object)ex);
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
    }

    @POST
    @Path(value="/schemas/{name}/versions/upload")
    @Consumes(value={"multipart/form-data"})
    @ApiOperation(value="Register a new version of an existing schema by uploading schema version text", notes="Registers the given schema version to schema with name if the given file content is not registered as a version for this schema, and returns respective version number.In case of incompatible schema errors, it throws error message like 'Unable to read schema: <> using schema <>' ", response=Integer.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response uploadSchemaVersion(@ApiParam(value="Schema name", required=true) @PathParam(value="name") String schemaName, @QueryParam(value="branch") @DefaultValue(value="MASTER") String schemaBranchName, @ApiParam(value="Schema version text file to be uploaded", required=true) @FormDataParam(value="file") InputStream inputStream, @ApiParam(value="Description about the schema version to be uploaded", required=true) @FormDataParam(value="description") String description, @QueryParam(value="disableCanonicalCheck") @DefaultValue(value="false") Boolean disableCanonicalCheck, @Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        return this.handleLeaderAction(uriInfo, () -> {
            Response response;
            SchemaVersion schemaVersion = null;
            try {
                this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaName, schemaBranchName, Authorizer.AccessType.CREATE);
                schemaVersion = new SchemaVersion(IOUtils.toString((InputStream)inputStream, (String)"UTF-8"), description);
                response = this.addSchemaVersion(schemaBranchName, schemaName, schemaVersion, disableCanonicalCheck, uriInfo, securityContext);
            }
            catch (SchemaNotFoundException e) {
                LOG.error("No schemas found with schemakey: [{}]", (Object)schemaName, (Object)e);
                response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaName});
            }
            catch (AuthorizationException e) {
                LOG.debug("Access denied. ", (Throwable)e);
                return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
            }
            catch (IOException ex) {
                LOG.error("Encountered error while adding schema [{}] with key [{}]", new Object[]{schemaVersion, schemaName, ex, ex});
                response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
            }
            return response;
        });
    }

    @POST
    @Path(value="/schemas/{name}/versions")
    @ApiOperation(value="Register a new version of the schema", notes="Registers the given schema version to schema with name if the given schemaText is not registered as a version for this schema, and returns respective version number.In case of incompatible schema errors, it throws error message like 'Unable to read schema: <> using schema <>' ", response=Integer.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response addSchemaVersion(@ApiParam(required=true) @QueryParam(value="branch") @DefaultValue(value="MASTER") String schemaBranchName, @ApiParam(value="Schema name", required=true) @PathParam(value="name") String schemaName, @ApiParam(value="Details about the schema, schemaText in one line", required=true) SchemaVersion schemaVersion, @QueryParam(value="disableCanonicalCheck") @DefaultValue(value="false") Boolean disableCanonicalCheck, @Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        return this.handleLeaderAction(uriInfo, () -> {
            Response response;
            try {
                LOG.info("adding schema version for name [{}] with [{}]", (Object)schemaName, (Object)schemaVersion);
                this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaName, schemaBranchName, Authorizer.AccessType.CREATE);
                SchemaIdVersion version = this.schemaRegistry.addSchemaVersion(schemaBranchName, schemaName, schemaVersion, disableCanonicalCheck.booleanValue());
                response = WSUtils.respondEntity((Object)version.getVersion(), (Response.Status)Response.Status.CREATED);
            }
            catch (AuthorizationException e) {
                LOG.debug("Access denied. ", (Throwable)e);
                return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
            }
            catch (InvalidSchemaException ex) {
                LOG.error("Invalid schema error encountered while adding schema [{}] with key [{}]", new Object[]{schemaVersion, schemaName, ex});
                response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.INVALID_SCHEMA, (String[])new String[]{ex.getMessage()});
            }
            catch (IncompatibleSchemaException ex) {
                LOG.error("Incompatible schema error encountered while adding schema [{}] with key [{}]", new Object[]{schemaVersion, schemaName, ex});
                response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.INCOMPATIBLE_SCHEMA, (String[])new String[]{ex.getMessage()});
            }
            catch (UnsupportedSchemaTypeException ex) {
                LOG.error("Unsupported schema type encountered while adding schema [{}] with key [{}]", new Object[]{schemaVersion, schemaName, ex});
                response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.UNSUPPORTED_SCHEMA_TYPE, (String[])new String[]{ex.getMessage()});
            }
            catch (SchemaBranchNotFoundException e) {
                return WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{e.getMessage()});
            }
            catch (Exception ex) {
                LOG.error("Encountered error while adding schema [{}] with key [{}]", new Object[]{schemaVersion, schemaName, ex, ex});
                response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
            }
            return response;
        });
    }

    @GET
    @Path(value="/schemas/{name}/versions/latest")
    @ApiOperation(value="Get the latest version of the schema for the given schema name", response=SchemaVersionInfo.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response getLatestSchemaVersion(@ApiParam(value="Schema name", required=true) @PathParam(value="name") String schemaName, @QueryParam(value="branch") @DefaultValue(value="MASTER") String schemaBranchName, @Context SecurityContext securityContext) {
        Response response;
        try {
            SchemaVersionInfo schemaVersionInfo = this.schemaRegistry.getLatestEnabledSchemaVersionInfo(schemaBranchName, schemaName);
            if (schemaVersionInfo != null) {
                this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaName, schemaBranchName, Authorizer.AccessType.READ);
                response = WSUtils.respondEntity((Object)schemaVersionInfo, (Response.Status)Response.Status.OK);
            } else {
                LOG.info("No schemas found with schemakey: [{}]", (Object)schemaName);
                response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaName});
            }
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaBranchNotFoundException e) {
            return WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while getting latest schema version for schemakey [{}]", (Object)schemaName, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @GET
    @Path(value="/schemas/{name}/versions")
    @ApiOperation(value="Get all the versions of the schema for the given schema name)", response=SchemaVersionInfo.class, responseContainer="List", tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response getAllSchemaVersions(@ApiParam(value="Schema name", required=true) @PathParam(value="name") String schemaName, @QueryParam(value="branch") @DefaultValue(value="MASTER") String schemaBranchName, @QueryParam(value="states") List<Byte> stateIds, @Context SecurityContext securityContext) {
        Response response;
        try {
            Collection schemaVersionInfos = this.schemaRegistry.getAllVersions(schemaBranchName, schemaName, stateIds);
            if (schemaVersionInfos != null) {
                this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaName, schemaBranchName, Authorizer.AccessType.READ);
                response = WSUtils.respondEntities((Collection)schemaVersionInfos, (Response.Status)Response.Status.OK);
            } else {
                LOG.info("No schemas found with schemakey: [{}]", (Object)schemaName);
                response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaName});
            }
        }
        catch (SchemaBranchNotFoundException e) {
            return WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{e.getMessage()});
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while getting all schema versions for schemakey [{}]", (Object)schemaName, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @GET
    @Path(value="/schemas/{name}/versions/{version}")
    @ApiOperation(value="Get a version of the schema identified by the schema name", response=SchemaVersionInfo.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response getSchemaVersion(@ApiParam(value="Schema name", required=true) @PathParam(value="name") String schemaMetadata, @ApiParam(value="version of the schema", required=true) @PathParam(value="version") Integer versionNumber, @Context SecurityContext securityContext) {
        Response response;
        SchemaVersionKey schemaVersionKey = new SchemaVersionKey(schemaMetadata, versionNumber);
        try {
            SchemaVersionInfo schemaVersionInfo = this.schemaRegistry.getSchemaVersionInfo(schemaVersionKey);
            this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaVersionInfo, Authorizer.AccessType.READ);
            response = WSUtils.respondEntity((Object)schemaVersionInfo, (Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException e) {
            LOG.info("No schemas found with schemaVersionKey: [{}]", (Object)schemaVersionKey);
            response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaVersionKey.toString()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while getting all schema versions for schemakey [{}]", (Object)schemaMetadata, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @GET
    @Path(value="/schemas/versionsById/{id}")
    @ApiOperation(value="Get a version of the schema identified by the given version id", response=SchemaVersionInfo.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response getSchemaVersionById(@ApiParam(value="version identifier of the schema", required=true) @PathParam(value="id") Long versionId, @Context SecurityContext securityContext) {
        Response response;
        SchemaIdVersion schemaIdVersion = new SchemaIdVersion(versionId);
        try {
            SchemaVersionInfo schemaVersionInfo = this.schemaRegistry.getSchemaVersionInfo(schemaIdVersion);
            this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaIdVersion, Authorizer.AccessType.READ);
            response = WSUtils.respondEntity((Object)schemaVersionInfo, (Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException e) {
            LOG.info("No schema version is found with schema version id : [{}]", (Object)versionId);
            response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{versionId.toString()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while getting schema version with id [{}]", (Object)versionId, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @GET
    @Path(value="/schemas/versionsByFingerprint/{fingerprint}")
    @ApiOperation(value="Get a version of the schema with the given fingerprint", response=SchemaVersionInfo.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response getSchemaVersionByFingerprint(@ApiParam(value="fingerprint of the schema text", required=true) @PathParam(value="fingerprint") String fingerprint, @Context SecurityContext securityContext) {
        try {
            SchemaVersionInfo schemaVersionInfo = this.schemaRegistry.findSchemaVersionByFingerprint(fingerprint);
            this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaVersionInfo, Authorizer.AccessType.READ);
            return WSUtils.respondEntity((Object)schemaVersionInfo, (Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException e) {
            LOG.info("No schema version is found with fingerprint : [{}]", (Object)fingerprint);
            return WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{fingerprint});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while getting schema version with fingerprint [{}]", (Object)fingerprint, (Object)ex);
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
    }

    @GET
    @Path(value="/schemas/versions/statemachine")
    @ApiOperation(value="Get schema version life cycle states", response=SchemaVersionInfo.class, tags={"1. Schema"})
    @Timed
    public Response getSchemaVersionLifeCycleStates() {
        Response response;
        try {
            SchemaVersionLifecycleStateMachineInfo states = this.schemaRegistry.getSchemaVersionLifecycleStateMachineInfo();
            response = WSUtils.respondEntity((Object)states, (Response.Status)Response.Status.OK);
        }
        catch (Exception ex) {
            LOG.error("Encountered error while getting schema version lifecycle states", (Throwable)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @POST
    @Path(value="/schemas/versions/{id}/state/enable")
    @ApiOperation(value="Enables version of the schema identified by the given version id", response=Boolean.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response enableSchema(@ApiParam(value="version identifier of the schema", required=true) @PathParam(value="id") Long versionId, @Context SecurityContext securityContext) {
        Response response;
        try {
            this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, versionId, Authorizer.AccessType.UPDATE);
            this.schemaRegistry.enableSchemaVersion(versionId);
            response = WSUtils.respondEntity((Object)true, (Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException e) {
            LOG.info("No schema version is found with schema version id : [{}]", (Object)versionId);
            response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{versionId.toString()});
        }
        catch (IncompatibleSchemaException e) {
            LOG.error("Encountered error while enabling schema version with id [{}]", (Object)versionId, (Object)e);
            response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.INCOMPATIBLE_SCHEMA, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaLifecycleException e) {
            LOG.error("Encountered error while enabling schema version with id [{}]", (Object)versionId, (Object)e);
            response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.BAD_REQUEST, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while getting schema version with id [{}]", (Object)versionId, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @POST
    @Path(value="/schemas/versions/{id}/state/disable")
    @ApiOperation(value="Disables version of the schema identified by the given version id", response=Boolean.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response disableSchema(@ApiParam(value="version identifier of the schema", required=true) @PathParam(value="id") Long versionId, @Context SecurityContext securityContext) {
        Response response;
        try {
            this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, versionId, Authorizer.AccessType.UPDATE);
            this.schemaRegistry.disableSchemaVersion(versionId);
            response = WSUtils.respondEntity((Object)true, (Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException e) {
            LOG.info("No schema version is found with schema version id : [{}]", (Object)versionId);
            response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{versionId.toString()});
        }
        catch (SchemaLifecycleException e) {
            LOG.error("Encountered error while disabling schema version with id [{}]", (Object)versionId, (Object)e);
            response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.BAD_REQUEST, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while getting schema version with id [{}]", (Object)versionId, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @POST
    @Path(value="/schemas/versions/{id}/state/archive")
    @ApiOperation(value="Archives version of the schema identified by the given version id", response=Boolean.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response archiveSchema(@ApiParam(value="version identifier of the schema", required=true) @PathParam(value="id") Long versionId, @Context SecurityContext securityContext) {
        Response response;
        try {
            this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, versionId, Authorizer.AccessType.UPDATE);
            this.schemaRegistry.archiveSchemaVersion(versionId);
            response = WSUtils.respondEntity((Object)true, (Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException e) {
            LOG.info("No schema version is found with schema version id : [{}]", (Object)versionId);
            response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{versionId.toString()});
        }
        catch (SchemaLifecycleException e) {
            LOG.error("Encountered error while disabling schema version with id [{}]", (Object)versionId, (Object)e);
            response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.BAD_REQUEST, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while getting schema version with id [{}]", (Object)versionId, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @POST
    @Path(value="/schemas/versions/{id}/state/delete")
    @ApiOperation(value="Deletes version of the schema identified by the given version id", response=Boolean.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response deleteSchema(@ApiParam(value="version identifier of the schema", required=true) @PathParam(value="id") Long versionId, @Context SecurityContext securityContext) {
        Response response;
        try {
            this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, versionId, Authorizer.AccessType.DELETE);
            this.schemaRegistry.deleteSchemaVersion(versionId);
            response = WSUtils.respondEntity((Object)true, (Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException e) {
            LOG.info("No schema version is found with schema version id : [{}]", (Object)versionId);
            response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{versionId.toString()});
        }
        catch (SchemaLifecycleException e) {
            LOG.error("Encountered error while disabling schema version with id [{}]", (Object)versionId, (Object)e);
            response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.BAD_REQUEST_WITH_MESSAGE, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while getting schema version with id [{}]", (Object)versionId, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @POST
    @Path(value="/schemas/versions/{id}/state/startReview")
    @ApiOperation(value="Starts review version of the schema identified by the given version id", response=Boolean.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response startReviewSchema(@ApiParam(value="version identifier of the schema", required=true) @PathParam(value="id") Long versionId, @Context SecurityContext securityContext) {
        Response response;
        try {
            this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, versionId, Authorizer.AccessType.UPDATE);
            this.schemaRegistry.startSchemaVersionReview(versionId);
            response = WSUtils.respondEntity((Object)true, (Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException e) {
            LOG.info("No schema version is found with schema version id : [{}]", (Object)versionId);
            response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{versionId.toString()});
        }
        catch (SchemaLifecycleException e) {
            LOG.error("Encountered error while disabling schema version with id [{}]", (Object)versionId, (Object)e);
            response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.BAD_REQUEST, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while getting schema version with id [{}]", (Object)versionId, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @POST
    @Path(value="/schemas/versions/{id}/state/{stateId}")
    @ApiOperation(value="Runs the state execution for schema version identified by the given version id and executes action associated with target state id", response=Boolean.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response executeState(@ApiParam(value="version identifier of the schema", required=true) @PathParam(value="id") Long versionId, @ApiParam(value="stateId can be the name or id of the target state of the schema\nMore information about the states can be accessed at /api/v1/schemaregistry/schemas/versions/statemachine", required=true) @PathParam(value="stateId") Byte stateId, byte[] transitionDetails, @Context SecurityContext securityContext) {
        Response response;
        try {
            this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, versionId, Authorizer.AccessType.UPDATE);
            this.schemaRegistry.transitionState(versionId, stateId, transitionDetails);
            response = WSUtils.respondEntity((Object)true, (Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException e) {
            LOG.info("No schema version is found with schema version id : [{}]", (Object)versionId);
            response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{versionId.toString()});
        }
        catch (SchemaLifecycleException e) {
            LOG.error("Encountered error while disabling schema version with id [{}]", (Object)versionId, (Object)e);
            CatalogResponse.ResponseMessage badRequestResponse = e.getCause() != null && e.getCause() instanceof IncompatibleSchemaException ? CatalogResponse.ResponseMessage.INCOMPATIBLE_SCHEMA : CatalogResponse.ResponseMessage.BAD_REQUEST;
            response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)badRequestResponse, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while getting schema version with id [{}]", (Object)versionId, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @POST
    @Path(value="/schemas/{name}/compatibility")
    @ApiOperation(value="Checks if the given schema text is compatible with all the versions of the schema identified by the name", response=CompatibilityResult.class, tags={"1. Schema"})
    @Timed
    @UnitOfWork
    public Response checkCompatibilityWithSchema(@QueryParam(value="branch") @DefaultValue(value="MASTER") String schemaBranchName, @ApiParam(value="Schema name", required=true) @PathParam(value="name") String schemaName, @ApiParam(value="schema text to be checked for compatibility", required=true) String schemaText, @Context SecurityContext securityContext) {
        Response response;
        try {
            this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaName, schemaBranchName, Authorizer.AccessType.READ);
            CompatibilityResult compatibilityResult = this.schemaRegistry.checkCompatibility(schemaBranchName, schemaName, schemaText);
            response = WSUtils.respondEntity((Object)compatibilityResult, (Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException e) {
            LOG.error("No schemas found with schemakey: [{}]", (Object)schemaName, (Object)e);
            response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaName});
        }
        catch (SchemaBranchNotFoundException e) {
            return WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while checking compatibility with versions of schema with [{}] for given schema text [{}]", new Object[]{schemaName, schemaText, ex});
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @GET
    @Path(value="/schemas/{name}/serdes")
    @ApiOperation(value="Get list of Serializers registered for the given schema name", response=SerDesInfo.class, responseContainer="List", tags={"2. Serializer/Deserializer"})
    @Timed
    @UnitOfWork
    public Response getSerializers(@ApiParam(value="Schema name", required=true) @PathParam(value="name") String schemaName, @Context SecurityContext securityContext) {
        Response response;
        try {
            SchemaMetadataInfo schemaMetadataInfo = this.schemaRegistry.getSchemaMetadataInfo(schemaName);
            if (schemaMetadataInfo != null) {
                this.authorizationAgent.authorizeGetSerializers(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), schemaMetadataInfo);
                Collection schemaSerializers = this.schemaRegistry.getSerDes(schemaMetadataInfo.getSchemaMetadata().getName());
                response = WSUtils.respondEntities((Collection)schemaSerializers, (Response.Status)Response.Status.OK);
            } else {
                LOG.info("No schemas found with schemakey: [{}]", (Object)schemaName);
                response = WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaName});
            }
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while getting serializers for schemaKey [{}]", (Object)schemaName, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/files")
    @ApiOperation(value="Upload the given file and returns respective identifier.", response=String.class, tags={"3. Other"})
    @Timed
    public Response uploadFile(@FormDataParam(value="file") InputStream inputStream, @FormDataParam(value="file") FormDataContentDisposition contentDispositionHeader, @Context SecurityContext securityContext) {
        Response response;
        try {
            LOG.info("Received contentDispositionHeader: [{}]", (Object)contentDispositionHeader);
            this.authorizationAgent.authorizeSerDes(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), Authorizer.AccessType.UPDATE);
            InputStream validatedStream = this.jarInputStreamValidator.validate(inputStream);
            String uploadedFileId = this.schemaRegistry.uploadFile(validatedStream);
            response = WSUtils.respondEntity((Object)uploadedFileId, (Response.Status)Response.Status.OK);
        }
        catch (InvalidJarFileException e) {
            LOG.debug("Invalid JAR file. ", (Throwable)e);
            response = WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.BAD_REQUEST_WITH_MESSAGE, (String[])new String[]{e.getMessage()});
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            response = WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while uploading file", (Throwable)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @GET
    @Produces(value={"application/octet-stream", "application/json"})
    @Path(value="/files/download/{fileId}")
    @ApiOperation(value="Downloads the respective for the given fileId if it exists", response=StreamingOutput.class, tags={"3. Other"})
    @Timed
    public Response downloadFile(@ApiParam(value="Identifier of the file to be downloaded", required=true) @PathParam(value="fileId") String fileId, @Context SecurityContext securityContext) {
        Response response;
        try {
            this.authorizationAgent.authorizeSerDes(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), Authorizer.AccessType.READ);
            StreamingOutput streamOutput = WSUtils.wrapWithStreamingOutput((InputStream)this.schemaRegistry.downloadFile(fileId));
            Response response2 = Response.ok((Object)streamOutput).build();
            return response2;
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (FileNotFoundException e) {
            LOG.error("No file found for fileId [{}]", (Object)fileId, (Object)e);
            response = WSUtils.respondEntity((Object)fileId, (Response.Status)Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            LOG.error("Encountered error while downloading file [{}]", (Object)fileId, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @POST
    @Path(value="/serdes")
    @ApiOperation(value="Add a Serializer/Deserializer into the Schema Registry", response=Long.class, tags={"2. Serializer/Deserializer"})
    @Timed
    @UnitOfWork
    public Response addSerDes(@ApiParam(value="Serializer/Deserializer information to be registered", required=true) SerDesPair serDesPair, @Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        return this.handleLeaderAction(uriInfo, () -> this._addSerDesInfo(serDesPair, securityContext));
    }

    @GET
    @Path(value="/serdes/{id}")
    @ApiOperation(value="Get a Serializer for the given serializer id", response=SerDesInfo.class, tags={"2. Serializer/Deserializer"})
    @Timed
    @UnitOfWork
    public Response getSerDes(@ApiParam(value="Serializer identifier", required=true) @PathParam(value="id") Long serializerId, @Context SecurityContext securityContext) {
        return this._getSerDesInfo(serializerId, securityContext);
    }

    private Response _addSerDesInfo(SerDesPair serDesInfo, SecurityContext securityContext) {
        Response response;
        try {
            this.authorizationAgent.authorizeSerDes(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), Authorizer.AccessType.CREATE);
            Long serializerId = this.schemaRegistry.addSerDes(serDesInfo);
            response = WSUtils.respondEntity((Object)serializerId, (Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while adding serializer/deserializer  [{}]", (Object)serDesInfo, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    private Response _getSerDesInfo(Long serializerId, SecurityContext securityContext) {
        Response response;
        try {
            this.authorizationAgent.authorizeSerDes(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), Authorizer.AccessType.READ);
            SerDesInfo serializerInfo = this.schemaRegistry.getSerDes(serializerId);
            response = WSUtils.respondEntity((Object)serializerInfo, (Response.Status)Response.Status.OK);
        }
        catch (Exception ex) {
            LOG.error("Encountered error while getting serializer/deserializer [{}]", (Object)serializerId, (Object)ex);
            response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
        return response;
    }

    @POST
    @Path(value="/schemas/{name}/mapping/{serDesId}")
    @ApiOperation(value="Bind the given Serializer/Deserializer to the schema identified by the schema name", tags={"2. Serializer/Deserializer"})
    @Timed
    @UnitOfWork
    public Response mapSchemaWithSerDes(@ApiParam(value="Schema name", required=true) @PathParam(value="name") String schemaName, @ApiParam(value="Serializer/deserializer identifier", required=true) @PathParam(value="serDesId") Long serDesId, @Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        return this.handleLeaderAction(uriInfo, () -> {
            Response response;
            try {
                this.authorizationAgent.authorizeMapSchemaWithSerDes(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaName);
                this.schemaRegistry.mapSchemaWithSerDes(schemaName, serDesId);
                response = WSUtils.respondEntity((Object)true, (Response.Status)Response.Status.OK);
            }
            catch (AuthorizationException e) {
                LOG.debug("Access denied. ", (Throwable)e);
                return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
            }
            catch (Exception ex) {
                response = WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
            }
            return response;
        });
    }

    @DELETE
    @Path(value="/schemas/{name}/versions/{version}")
    @ApiOperation(value="Delete a schema version given its schema name and version id", tags={"1. Schema"})
    @UnitOfWork
    public Response deleteSchemaVersion(@ApiParam(value="Schema name", required=true) @PathParam(value="name") String schemaName, @ApiParam(value="version of the schema", required=true) @PathParam(value="version") Integer versionNumber, @Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        SchemaVersionKey schemaVersionKey = null;
        try {
            schemaVersionKey = new SchemaVersionKey(schemaName, versionNumber);
            this.authorizationAgent.authorizeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaVersionKey, Authorizer.AccessType.DELETE);
            this.schemaRegistry.deleteSchemaVersion(schemaVersionKey);
            return WSUtils.respond((Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException e) {
            LOG.error("No schemaVersion found with name: [{}], version : [{}]", (Object)schemaName, (Object)versionNumber);
            return WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaVersionKey.toString()});
        }
        catch (SchemaLifecycleException e) {
            LOG.error("Failed to delete schema name: [{}], version : [{}]", new Object[]{schemaName, versionNumber, e});
            return WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.BAD_REQUEST_WITH_MESSAGE, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while deleting schemaVersion with name: [{}], version : [{}]", new Object[]{schemaName, versionNumber, ex});
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
    }

    @GET
    @Path(value="/schemas/{name}/branches")
    @ApiOperation(value="Get list of registered schema branches", response=SchemaBranch.class, responseContainer="List", tags={"3. Other"})
    @Timed
    @UnitOfWork
    public Response getAllBranches(@ApiParam(value="Details about schema name", required=true) @PathParam(value="name") String schemaName, @Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        try {
            Collection schemaBranches = this.authorizationAgent.authorizeGetAllBranches(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaName, this.schemaRegistry.getSchemaBranches(schemaName));
            return WSUtils.respondEntities((Collection)schemaBranches, (Response.Status)Response.Status.OK);
        }
        catch (SchemaNotFoundException e) {
            return WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaName});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while listing schema branches", (Throwable)ex);
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
    }

    @POST
    @Path(value="/schemas/versionsById/{versionId}/branch")
    @ApiOperation(value="Fork a new schema branch given its schema name and version id", response=SchemaBranch.class, tags={"1. Schema"})
    @UnitOfWork
    public Response createSchemaBranch(@ApiParam(value="Details about schema version", required=true) @PathParam(value="versionId") Long schemaVersionId, @ApiParam(value="Schema Branch Name", required=true) SchemaBranch schemaBranch, @Context SecurityContext securityContext) {
        try {
            this.authorizationAgent.authorizeCreateSchemaBranch(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaBranch.getSchemaMetadataName(), schemaVersionId, schemaBranch.getName());
            SchemaBranch createdSchemaBranch = this.schemaRegistry.createSchemaBranch(schemaVersionId, schemaBranch);
            return WSUtils.respondEntity((Object)createdSchemaBranch, (Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaBranchAlreadyExistsException e) {
            return WSUtils.respond((Response.Status)Response.Status.CONFLICT, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_CONFLICT, (String[])new String[]{schemaBranch.getName()});
        }
        catch (SchemaNotFoundException e) {
            return WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaVersionId.toString()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while creating a new branch with name: [{}], version : [{}]", new Object[]{schemaBranch.getName(), schemaVersionId, ex});
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
    }

    @POST
    @Path(value="/schemas/{versionId}/merge")
    @ApiOperation(value="Merge a schema version to master given its version id", response=SchemaVersionMergeResult.class, tags={"1. Schema"})
    @UnitOfWork
    public Response mergeSchemaVersion(@ApiParam(value="Details about schema version", required=true) @PathParam(value="versionId") Long schemaVersionId, @QueryParam(value="disableCanonicalCheck") @DefaultValue(value="false") Boolean disableCanonicalCheck, @Context SecurityContext securityContext) {
        try {
            this.authorizationAgent.authorizeMergeSchemaVersion(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaVersionId);
            SchemaVersionMergeResult schemaVersionMergeResult = this.schemaRegistry.mergeSchemaVersion(schemaVersionId, disableCanonicalCheck.booleanValue());
            return WSUtils.respondEntity((Object)schemaVersionMergeResult, (Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaNotFoundException e) {
            return WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaVersionId.toString()});
        }
        catch (IncompatibleSchemaException e) {
            return WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.INCOMPATIBLE_SCHEMA, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while merging a schema version to {} branch with version : [{}]", new Object[]{"MASTER", schemaVersionId, ex});
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
    }

    @DELETE
    @Path(value="/schemas/branch/{branchId}")
    @ApiOperation(value="Delete a branch given its branch id", tags={"1. Schema"})
    @UnitOfWork
    public Response deleteSchemaBranch(@ApiParam(value="ID of the Schema Branch", required=true) @PathParam(value="branchId") Long schemaBranchId, @Context SecurityContext securityContext) {
        try {
            this.authorizationAgent.authorizeDeleteSchemaBranch(AuthorizationUtils.getUserAndGroups((SecurityContext)securityContext), this.schemaRegistry, schemaBranchId);
            this.schemaRegistry.deleteSchemaBranch(schemaBranchId);
            return WSUtils.respond((Response.Status)Response.Status.OK);
        }
        catch (AuthorizationException e) {
            LOG.debug("Access denied. ", (Throwable)e);
            return WSUtils.respond((Response.Status)Response.Status.FORBIDDEN, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ACCESS_DENIED, (String[])new String[]{e.getMessage()});
        }
        catch (SchemaBranchNotFoundException e) {
            return WSUtils.respond((Response.Status)Response.Status.NOT_FOUND, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.ENTITY_NOT_FOUND, (String[])new String[]{schemaBranchId.toString()});
        }
        catch (InvalidSchemaBranchDeletionException e) {
            return WSUtils.respond((Response.Status)Response.Status.BAD_REQUEST, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.BAD_REQUEST_WITH_MESSAGE, (String[])new String[]{e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("Encountered error while deleting a branch with name: [{}]", (Object)schemaBranchId, (Object)ex);
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{ex.getMessage()});
        }
    }

    @POST
    @Path(value="/cache/{cacheType}/invalidate")
    @UnitOfWork
    public Response invalidateCache(@ApiParam(value="Cache Id to be invalidated", required=true) @PathParam(value="cacheType") SchemaRegistryCacheType cacheType, String keyString) {
        try {
            LOG.debug("RetryableBlock to invalidate cache : {} with key : {} accepted", (Object)cacheType.name(), (Object)keyString);
            this.schemaRegistry.invalidateCache(cacheType, keyString);
            return WSUtils.respond((Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{e.getMessage()});
        }
    }

    @POST
    @Path(value="/notifications/node/debut")
    public Response registerNodeDebut(String nodeUrl) {
        try {
            LOG.debug("Acknowledged another peer server : {}", (Object)nodeUrl);
            this.schemaRegistry.registerNodeDebut(nodeUrl);
            return WSUtils.respond((Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            return WSUtils.respond((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (CatalogResponse.ResponseMessage)CatalogResponse.ResponseMessage.EXCEPTION, (String[])new String[]{e.getMessage()});
        }
    }
}

