/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.webservice.validator;

import com.hortonworks.registries.schemaregistry.webservice.validator.exception.InvalidJarFileException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarInputStream;
import java.util.zip.ZipException;
import org.apache.commons.io.IOUtils;

public class JarInputStreamValidator {
    public InputStream validate(InputStream inputStream) throws IOException, InvalidJarFileException {
        byte[] allBytesFromStream = null;
        try {
            allBytesFromStream = IOUtils.toByteArray((InputStream)inputStream);
            JarInputStream jarInputStream = new JarInputStream((InputStream)new ByteArrayInputStream(allBytesFromStream), false);
            if (jarInputStream.getNextJarEntry() == null) {
                throw new InvalidJarFileException("Jar file corrupted.");
            }
        }
        catch (ZipException e) {
            throw new InvalidJarFileException("Jar file corrupted.", e);
        }
        finally {
            inputStream.close();
        }
        return new ByteArrayInputStream(allBytesFromStream);
    }
}

