/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.avro.compatibility;

import com.hotels.avro.compatibility.Compatibility;
import com.hotels.avro.compatibility.CompatibilityCheckResult;
import com.hotels.avro.compatibility.SchemaCompatibilityException;
import java.util.Collections;
import java.util.List;
import org.apache.avro.SchemaCompatibility;

public class ChronologyCompatibilityCheckResult {
    private final List<CompatibilityCheckResult> results;
    private final Compatibility.CheckType compatibility;
    private final Compatibility.ChronologyType chronology;

    ChronologyCompatibilityCheckResult(Compatibility.CheckType strategy, Compatibility.ChronologyType chronologyStrategy, List<CompatibilityCheckResult> results) {
        this.compatibility = strategy;
        this.chronology = chronologyStrategy;
        this.results = Collections.unmodifiableList(results);
    }

    public List<CompatibilityCheckResult> getResults() {
        return this.results;
    }

    public SchemaCompatibility.SchemaCompatibilityType getType() {
        return this.isCompatible() ? SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE : SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE;
    }

    public boolean isCompatible() {
        for (CompatibilityCheckResult result : this.results) {
            if (result.isCompatible()) continue;
            return false;
        }
        return true;
    }

    public void throwIfIncompatible() throws SchemaCompatibilityException {
        if (!this.isCompatible()) {
            throw new SchemaCompatibilityException(this);
        }
    }

    public Compatibility.CheckType getCompatibility() {
        return this.compatibility;
    }

    public Compatibility.ChronologyType getChronology() {
        return this.chronology;
    }

    public String asMessage() {
        if (this.isCompatible()) {
            return String.format("Compatibility type '%s' holds for '%s' schema(s).", new Object[]{this.compatibility, this.chronology});
        }
        int incompatibleCount = 0;
        for (CompatibilityCheckResult result : this.results) {
            if (result.isCompatible()) continue;
            ++incompatibleCount;
        }
        StringBuilder message = new StringBuilder(String.format("Compatibility type '%s' does not hold between %s schema(s) in the chronology because: ", new Object[]{this.compatibility, incompatibleCount}));
        int i = 0;
        for (CompatibilityCheckResult result : this.results) {
            if (!result.isCompatible()) {
                if (i > 0) {
                    message.append(", ");
                }
                message.append(String.format("Schema[%s] has incompatibilities: [", i));
                boolean first = true;
                for (SchemaCompatibility.Incompatibility incompatibility : result.getResult().getIncompatibilities()) {
                    if (first) {
                        first = false;
                    } else {
                        message.append(',');
                    }
                    message.append(String.format("'%s: %s' at '%s'", incompatibility.getType(), incompatibility.getMessage(), incompatibility.getLocation()));
                }
                message.append(']');
            }
            ++i;
        }
        message.append(".");
        return message.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chronology == null ? 0 : this.chronology.hashCode());
        result = 31 * result + (this.compatibility == null ? 0 : this.compatibility.hashCode());
        result = 31 * result + (this.results == null ? 0 : this.results.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChronologyCompatibilityCheckResult other = (ChronologyCompatibilityCheckResult)obj;
        if (this.chronology != other.chronology) {
            return false;
        }
        if (this.compatibility != other.compatibility) {
            return false;
        }
        return !(this.results == null ? other.results != null : !this.results.equals(other.results));
    }
}

