/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.avro.compatibility;

import com.google.common.base.Preconditions;
import com.hotels.avro.compatibility.ChronologyCompatibilityCheckResult;
import com.hotels.avro.compatibility.CompatibilityCheckResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;

public final class Compatibility {
    private Compatibility() {
    }

    public static CheckSelector checkThat(Schema schema) {
        Preconditions.checkNotNull((Object)schema, (Object)"Schema to be checked cannot be null.");
        return new CheckSelector(schema);
    }

    private static SchemaCompatibility.SchemaPairCompatibility canRead(Schema writtenWith, Schema readUsing) {
        return SchemaCompatibility.checkReaderWriterCompatibility((Schema)readUsing, (Schema)writtenWith);
    }

    public static enum CheckType {
        CAN_READ{

            @Override
            public SchemaCompatibility.SchemaPairCompatibility validate(Schema toValidate, Schema existing) {
                return Compatibility.canRead(existing, toValidate);
            }
        }
        ,
        CAN_BE_READ_BY{

            @Override
            public SchemaCompatibility.SchemaPairCompatibility validate(Schema toValidate, Schema existing) {
                return Compatibility.canRead(toValidate, existing);
            }
        }
        ,
        MUTUAL_READ{

            @Override
            public SchemaCompatibility.SchemaPairCompatibility validate(Schema toValidate, Schema existing) {
                SchemaCompatibility.SchemaPairCompatibility canBeRead = Compatibility.canRead(toValidate, existing);
                if (canBeRead.getType() == SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE) {
                    return canBeRead;
                }
                SchemaCompatibility.SchemaPairCompatibility canRead = Compatibility.canRead(existing, toValidate);
                return canRead;
            }
        };


        abstract SchemaCompatibility.SchemaPairCompatibility validate(Schema var1, Schema var2);
    }

    public static enum ChronologyType {
        ALL{

            @Override
            public ChronologyCompatibilityCheckResult check(CheckType check, Schema toValidate, Iterable<Schema> schemasInOrder) {
                ArrayList<CompatibilityCheckResult> results = new ArrayList<CompatibilityCheckResult>();
                for (Schema existing : schemasInOrder) {
                    SchemaCompatibility.SchemaPairCompatibility schemaPairCompatibility = check.validate(toValidate, existing);
                    CompatibilityCheckResult result = new CompatibilityCheckResult(check, this, schemaPairCompatibility);
                    results.add(result);
                }
                return new ChronologyCompatibilityCheckResult(check, this, results);
            }
        }
        ,
        LATEST{

            @Override
            public ChronologyCompatibilityCheckResult check(CheckType check, Schema toValidate, Iterable<Schema> schemasInOrder) {
                Iterator<Schema> schemas = schemasInOrder.iterator();
                Schema existing = null;
                while (schemas.hasNext()) {
                    existing = schemas.next();
                }
                if (existing != null) {
                    SchemaCompatibility.SchemaPairCompatibility schemaPairCompatibility = check.validate(toValidate, existing);
                    CompatibilityCheckResult result = new CompatibilityCheckResult(check, this, schemaPairCompatibility);
                    return new ChronologyCompatibilityCheckResult(check, this, Collections.singletonList(result));
                }
                return new ChronologyCompatibilityCheckResult(check, this, Collections.emptyList());
            }
        };


        abstract ChronologyCompatibilityCheckResult check(CheckType var1, Schema var2, Iterable<Schema> var3);
    }

    private static class Checker {
        private final ChronologyType chronology;
        private final CheckType check;
        private final Schema toValidate;
        private final Iterable<Schema> schemasInOrder;

        private Checker(ChronologyType chronology, CheckType check, Schema toValidate, Iterable<Schema> schemasInOrder) {
            this.chronology = chronology;
            this.check = check;
            this.toValidate = toValidate;
            this.schemasInOrder = schemasInOrder;
        }

        ChronologyCompatibilityCheckResult check() {
            return this.chronology.check(this.check, this.toValidate, this.schemasInOrder);
        }
    }

    public static class CheckSelector {
        private final Schema toValidate;

        private CheckSelector(Schema toValidate) {
            this.toValidate = toValidate;
        }

        public CompatibilityCheckResult canRead(Schema schema) {
            Preconditions.checkNotNull((Object)schema, (Object)"Schema to compare against cannot be null.");
            return new Checker(ChronologyType.LATEST, CheckType.CAN_READ, this.toValidate, Collections.singletonList(schema)).check().getResults().get(0);
        }

        public CompatibilityCheckResult canBeReadBy(Schema schema) {
            Preconditions.checkNotNull((Object)schema, (Object)"Schema to compare against cannot be null.");
            return new Checker(ChronologyType.LATEST, CheckType.CAN_BE_READ_BY, this.toValidate, Collections.singletonList(schema)).check().getResults().get(0);
        }

        public CompatibilityCheckResult mutualReadWith(Schema schema) {
            Preconditions.checkNotNull((Object)schema, (Object)"Schema to compare against cannot be null.");
            return new Checker(ChronologyType.LATEST, CheckType.MUTUAL_READ, this.toValidate, Collections.singletonList(schema)).check().getResults().get(0);
        }

        public ChronologySelector canRead() {
            return new ChronologySelector(this.toValidate, CheckType.CAN_READ);
        }

        public ChronologySelector canBeReadBy() {
            return new ChronologySelector(this.toValidate, CheckType.CAN_BE_READ_BY);
        }

        public ChronologySelector mutualReadWith() {
            return new ChronologySelector(this.toValidate, CheckType.MUTUAL_READ);
        }

        public static class ChronologySelector {
            private final Schema toValidate;
            private final CheckType compatibilityStrategy;

            private ChronologySelector(Schema toValidate, CheckType check) {
                this.toValidate = toValidate;
                this.compatibilityStrategy = check;
            }

            public ChronologyCompatibilityCheckResult all(Iterable<Schema> schemasInOrder) {
                Preconditions.checkNotNull(schemasInOrder, (Object)"Schemas to compare against cannot be null.");
                return new Checker(ChronologyType.ALL, this.compatibilityStrategy, this.toValidate, schemasInOrder).check();
            }

            public ChronologyCompatibilityCheckResult all(Schema ... schemasInOrder) {
                Preconditions.checkNotNull((Object)schemasInOrder, (Object)"Schemas to compare against cannot be null.");
                return this.all(Arrays.asList(schemasInOrder));
            }

            public ChronologyCompatibilityCheckResult latestOf(Iterable<Schema> schemasInOrder) {
                Preconditions.checkNotNull(schemasInOrder, (Object)"Schemas to compare against cannot be null.");
                return new Checker(ChronologyType.LATEST, this.compatibilityStrategy, this.toValidate, schemasInOrder).check();
            }

            public ChronologyCompatibilityCheckResult latestOf(Schema ... schemasInOrder) {
                Preconditions.checkNotNull((Object)schemasInOrder, (Object)"Schemas to compare against cannot be null.");
                return this.latestOf(Arrays.asList(schemasInOrder));
            }
        }
    }

    public static enum Mode {
        CAN_READ_LATEST(ChronologyType.LATEST, CheckType.CAN_READ),
        CAN_READ_ALL(ChronologyType.ALL, CheckType.CAN_READ),
        CAN_BE_READ_BY_LATEST(ChronologyType.LATEST, CheckType.CAN_BE_READ_BY),
        CAN_BE_READ_BY_ALL(ChronologyType.ALL, CheckType.CAN_BE_READ_BY),
        MUTUAL_READ_WITH_LATEST(ChronologyType.LATEST, CheckType.MUTUAL_READ),
        MUTUAL_READ_WITH_ALL(ChronologyType.ALL, CheckType.MUTUAL_READ);

        private final ChronologyType chronology;
        private final CheckType check;

        private Mode(ChronologyType chronology, CheckType check) {
            this.chronology = chronology;
            this.check = check;
        }

        public ChronologyCompatibilityCheckResult check(Schema toValidate, Iterable<Schema> schemasInOrder) {
            Preconditions.checkNotNull((Object)toValidate, (Object)"Schema to be checked cannot be null.");
            Preconditions.checkNotNull(schemasInOrder, (Object)"Schemas to compare against cannot be null.");
            return new Checker(this.chronology, this.check, toValidate, schemasInOrder).check();
        }
    }
}

