/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.avro.compatibility;

import com.hotels.avro.compatibility.Compatibility;
import com.hotels.avro.compatibility.SchemaCompatibilityException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;

public class CompatibilityCheckResult {
    private final SchemaCompatibility.SchemaPairCompatibility schemaPairCompatibility;
    private final Compatibility.CheckType compatibility;
    private final Compatibility.ChronologyType chronology;

    CompatibilityCheckResult(Compatibility.CheckType compatibility, Compatibility.ChronologyType chronology, SchemaCompatibility.SchemaPairCompatibility schemaPairCompatibility) {
        this.compatibility = compatibility;
        this.chronology = chronology;
        this.schemaPairCompatibility = schemaPairCompatibility;
    }

    public SchemaCompatibility.SchemaCompatibilityType getType() {
        return this.schemaPairCompatibility.getType();
    }

    public SchemaCompatibility.SchemaCompatibilityResult getResult() {
        return this.schemaPairCompatibility.getResult();
    }

    public Schema getReader() {
        return this.schemaPairCompatibility.getReader();
    }

    public Schema getWriter() {
        return this.schemaPairCompatibility.getWriter();
    }

    public String getDescription() {
        return this.schemaPairCompatibility.getDescription();
    }

    public String asMessage() {
        if (this.isCompatible()) {
            return String.format("Compatibility type '%s' holds between schemas.", new Object[]{this.compatibility, this.chronology});
        }
        StringBuilder message = new StringBuilder();
        message.append(String.format("Compatibility type '%s' does not hold between schemas, incompatibilities: [", new Object[]{this.getCompatibility()}));
        boolean first = true;
        for (SchemaCompatibility.Incompatibility incompatibility : this.getResult().getIncompatibilities()) {
            if (first) {
                first = false;
            } else {
                message.append(',');
            }
            message.append(String.format("'%s: %s' at '%s'", incompatibility.getType(), incompatibility.getMessage(), incompatibility.getLocation()));
        }
        message.append("].");
        return message.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chronology == null ? 0 : this.chronology.hashCode());
        result = 31 * result + (this.compatibility == null ? 0 : this.compatibility.hashCode());
        result = 31 * result + (this.schemaPairCompatibility == null ? 0 : this.schemaPairCompatibility.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompatibilityCheckResult other = (CompatibilityCheckResult)obj;
        if (this.chronology != other.chronology) {
            return false;
        }
        if (this.compatibility != other.compatibility) {
            return false;
        }
        return !(this.schemaPairCompatibility == null ? other.schemaPairCompatibility != null : !this.schemaPairCompatibility.equals((Object)other.schemaPairCompatibility));
    }

    public boolean isCompatible() {
        return this.getType() == SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE;
    }

    public void throwIfIncompatible() throws SchemaCompatibilityException {
        if (!this.isCompatible()) {
            throw new SchemaCompatibilityException(this);
        }
    }

    public Compatibility.CheckType getCompatibility() {
        return this.compatibility;
    }

    public Compatibility.ChronologyType getChronology() {
        return this.chronology;
    }

    public String toString() {
        return "SchemaCompatibilityResult [compatibility=" + (Object)((Object)this.compatibility) + ", chronology=" + (Object)((Object)this.chronology) + ", schemaPairCompatibility=" + this.schemaPairCompatibility + "]";
    }
}

