/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.avro.compatibility;

import com.hotels.avro.compatibility.ChronologyCompatibilityCheckResult;
import com.hotels.avro.compatibility.CompatibilityCheckResult;
import java.util.Collections;

public class SchemaCompatibilityException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final ChronologyCompatibilityCheckResult chronologyResult;

    SchemaCompatibilityException(ChronologyCompatibilityCheckResult chronologyResult) {
        this.chronologyResult = chronologyResult;
    }

    SchemaCompatibilityException(CompatibilityCheckResult compatibilityResult) {
        this(new ChronologyCompatibilityCheckResult(compatibilityResult.getCompatibility(), compatibilityResult.getChronology(), Collections.singletonList(compatibilityResult)));
    }

    @Override
    public String getMessage() {
        switch (this.chronologyResult.getChronology()) {
            case LATEST: {
                return this.chronologyResult.getResults().get(0).toString();
            }
            case ALL: {
                return this.chronologyResult.asMessage();
            }
        }
        throw new IllegalStateException("Unexpected chronology: " + (Object)((Object)this.chronologyResult.getChronology()));
    }
}

